/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.common.app;

import java.awt.Component;
import org.optaplanner.core.api.solver.Solver;
import org.optaplanner.core.api.solver.SolverFactory;
import org.optaplanner.examples.common.app.LoggingMain;
import org.optaplanner.examples.common.business.SolutionBusiness;
import org.optaplanner.examples.common.persistence.AbstractSolutionExporter;
import org.optaplanner.examples.common.persistence.AbstractSolutionImporter;
import org.optaplanner.examples.common.persistence.SolutionDao;
import org.optaplanner.examples.common.swingui.SolutionPanel;
import org.optaplanner.examples.common.swingui.SolverAndPersistenceFrame;
import org.optaplanner.swing.impl.SwingUncaughtExceptionHandler;
import org.optaplanner.swing.impl.SwingUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CommonApp<Solution_>
extends LoggingMain {
    protected static final Logger logger = LoggerFactory.getLogger(CommonApp.class);
    protected final String name;
    protected final String description;
    protected final String solverConfig;
    protected final String iconResource;
    protected SolverAndPersistenceFrame<Solution_> solverAndPersistenceFrame;
    protected SolutionBusiness<Solution_> solutionBusiness;

    public static void prepareSwingEnvironment() {
        SwingUncaughtExceptionHandler.register();
        SwingUtils.fixateLookAndFeel();
    }

    protected CommonApp(String name, String description, String solverConfig, String iconResource) {
        this.name = name;
        this.description = description;
        this.solverConfig = solverConfig;
        this.iconResource = iconResource;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getIconResource() {
        return this.iconResource;
    }

    public void init() {
        this.init(null, true);
    }

    public void init(Component centerForComponent, boolean exitOnClose) {
        this.solutionBusiness = this.createSolutionBusiness();
        this.solverAndPersistenceFrame = new SolverAndPersistenceFrame<Solution_>(this.solutionBusiness, this.createSolutionPanel());
        this.solverAndPersistenceFrame.setDefaultCloseOperation(exitOnClose ? 3 : 2);
        this.solverAndPersistenceFrame.init(centerForComponent);
        this.solverAndPersistenceFrame.setVisible(true);
    }

    public SolutionBusiness<Solution_> createSolutionBusiness() {
        SolutionBusiness<Solution_> solutionBusiness = new SolutionBusiness<Solution_>(this);
        solutionBusiness.setSolutionDao(this.createSolutionDao());
        solutionBusiness.setImporters(this.createSolutionImporters());
        solutionBusiness.setExporter(this.createSolutionExporter());
        solutionBusiness.updateDataDirs();
        solutionBusiness.setSolver(this.createSolver());
        return solutionBusiness;
    }

    protected Solver<Solution_> createSolver() {
        SolverFactory solverFactory = SolverFactory.createFromXmlResource((String)this.solverConfig);
        return solverFactory.buildSolver();
    }

    protected abstract SolutionPanel<Solution_> createSolutionPanel();

    protected abstract SolutionDao createSolutionDao();

    protected AbstractSolutionImporter[] createSolutionImporters() {
        return new AbstractSolutionImporter[0];
    }

    protected AbstractSolutionExporter createSolutionExporter() {
        return null;
    }
}

