/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.pas.solver.move;

import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.optaplanner.core.impl.heuristic.move.AbstractMove;
import org.optaplanner.core.impl.score.director.ScoreDirector;
import org.optaplanner.examples.pas.domain.Bed;
import org.optaplanner.examples.pas.domain.BedDesignation;
import org.optaplanner.examples.pas.domain.PatientAdmissionSchedule;
import org.optaplanner.examples.pas.solver.move.PatientAdmissionMoveHelper;

public class BedDesignationSwapMove
extends AbstractMove<PatientAdmissionSchedule> {
    private BedDesignation leftBedDesignation;
    private BedDesignation rightBedDesignation;

    public BedDesignationSwapMove(BedDesignation leftBedDesignation, BedDesignation rightBedDesignation) {
        this.leftBedDesignation = leftBedDesignation;
        this.rightBedDesignation = rightBedDesignation;
    }

    public boolean isMoveDoable(ScoreDirector<PatientAdmissionSchedule> scoreDirector) {
        return !Objects.equals(this.leftBedDesignation.getBed(), this.rightBedDesignation.getBed());
    }

    public BedDesignationSwapMove createUndoMove(ScoreDirector<PatientAdmissionSchedule> scoreDirector) {
        return new BedDesignationSwapMove(this.rightBedDesignation, this.leftBedDesignation);
    }

    protected void doMoveOnGenuineVariables(ScoreDirector<PatientAdmissionSchedule> scoreDirector) {
        Bed oldLeftBed = this.leftBedDesignation.getBed();
        Bed oldRightBed = this.rightBedDesignation.getBed();
        PatientAdmissionMoveHelper.moveBed(scoreDirector, this.leftBedDesignation, oldRightBed);
        PatientAdmissionMoveHelper.moveBed(scoreDirector, this.rightBedDesignation, oldLeftBed);
    }

    public Collection<? extends Object> getPlanningEntities() {
        return Arrays.asList(this.leftBedDesignation, this.rightBedDesignation);
    }

    public Collection<? extends Object> getPlanningValues() {
        return Arrays.asList(this.leftBedDesignation.getBed(), this.rightBedDesignation.getBed());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof BedDesignationSwapMove) {
            BedDesignationSwapMove other = (BedDesignationSwapMove)((Object)o);
            return new EqualsBuilder().append((Object)this.leftBedDesignation, (Object)other.leftBedDesignation).append((Object)this.rightBedDesignation, (Object)other.rightBedDesignation).isEquals();
        }
        return false;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.leftBedDesignation).append((Object)this.rightBedDesignation).toHashCode();
    }

    public String toString() {
        return this.leftBedDesignation + " {" + this.leftBedDesignation.getBed() + "} <-> " + this.rightBedDesignation + " {" + this.rightBedDesignation.getBed() + "}";
    }
}

