/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.common.business;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.SwingUtilities;
import org.apache.commons.io.FileUtils;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.constraint.ConstraintMatchTotal;
import org.optaplanner.core.api.score.constraint.Indictment;
import org.optaplanner.core.api.solver.Solver;
import org.optaplanner.core.impl.domain.entity.descriptor.EntityDescriptor;
import org.optaplanner.core.impl.domain.solution.descriptor.SolutionDescriptor;
import org.optaplanner.core.impl.domain.variable.descriptor.GenuineVariableDescriptor;
import org.optaplanner.core.impl.domain.variable.descriptor.VariableDescriptor;
import org.optaplanner.core.impl.domain.variable.inverserelation.SingletonInverseVariableDemand;
import org.optaplanner.core.impl.domain.variable.inverserelation.SingletonInverseVariableSupply;
import org.optaplanner.core.impl.domain.variable.supply.Demand;
import org.optaplanner.core.impl.domain.variable.supply.SupplyManager;
import org.optaplanner.core.impl.heuristic.move.Move;
import org.optaplanner.core.impl.heuristic.selector.move.generic.ChangeMove;
import org.optaplanner.core.impl.heuristic.selector.move.generic.SwapMove;
import org.optaplanner.core.impl.heuristic.selector.move.generic.chained.ChainedChangeMove;
import org.optaplanner.core.impl.heuristic.selector.move.generic.chained.ChainedSwapMove;
import org.optaplanner.core.impl.score.director.InnerScoreDirector;
import org.optaplanner.core.impl.score.director.ScoreDirector;
import org.optaplanner.core.impl.score.director.ScoreDirectorFactory;
import org.optaplanner.core.impl.solver.ProblemFactChange;
import org.optaplanner.examples.common.app.CommonApp;
import org.optaplanner.examples.common.business.ProblemFileComparator;
import org.optaplanner.examples.common.persistence.AbstractSolutionExporter;
import org.optaplanner.examples.common.persistence.AbstractSolutionImporter;
import org.optaplanner.examples.common.swingui.SolverAndPersistenceFrame;
import org.optaplanner.persistence.common.api.domain.solution.SolutionFileIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolutionBusiness<Solution_> {
    private static final ProblemFileComparator FILE_COMPARATOR = new ProblemFileComparator();
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    private final CommonApp app;
    private File dataDir;
    private SolutionFileIO<Solution_> solutionFileIO;
    private AbstractSolutionImporter<Solution_>[] importers;
    private AbstractSolutionExporter<Solution_> exporter;
    private File importDataDir;
    private File unsolvedDataDir;
    private File solvedDataDir;
    private File exportDataDir;
    private volatile Solver<Solution_> solver;
    private String solutionFileName = null;
    private ScoreDirector<Solution_> guiScoreDirector;
    private final AtomicReference<Solution_> skipToBestSolutionRef = new AtomicReference();

    public SolutionBusiness(CommonApp app) {
        this.app = app;
    }

    public String getAppName() {
        return this.app.getName();
    }

    public String getAppDescription() {
        return this.app.getDescription();
    }

    public String getAppIconResource() {
        return this.app.getIconResource();
    }

    public File getDataDir() {
        return this.dataDir;
    }

    public void setDataDir(File dataDir) {
        this.dataDir = dataDir;
    }

    public SolutionFileIO<Solution_> getSolutionFileIO() {
        return this.solutionFileIO;
    }

    public void setSolutionFileIO(SolutionFileIO<Solution_> solutionFileIO) {
        this.solutionFileIO = solutionFileIO;
    }

    public AbstractSolutionImporter<Solution_>[] getImporters() {
        return this.importers;
    }

    public void setImporters(AbstractSolutionImporter<Solution_>[] importers) {
        this.importers = importers;
    }

    public void setExporter(AbstractSolutionExporter<Solution_> exporter) {
        this.exporter = exporter;
    }

    public boolean hasImporter() {
        return this.importers.length > 0;
    }

    public boolean hasExporter() {
        return this.exporter != null;
    }

    public void updateDataDirs() {
        if (this.hasImporter()) {
            this.importDataDir = new File(this.dataDir, "import");
            if (!this.importDataDir.exists()) {
                throw new IllegalStateException("The directory importDataDir (" + this.importDataDir.getAbsolutePath() + ") does not exist.");
            }
        }
        this.unsolvedDataDir = new File(this.dataDir, "unsolved");
        if (!this.unsolvedDataDir.exists()) {
            throw new IllegalStateException("The directory unsolvedDataDir (" + this.unsolvedDataDir.getAbsolutePath() + ") does not exist.");
        }
        this.solvedDataDir = new File(this.dataDir, "solved");
        if (!this.solvedDataDir.exists() && !this.solvedDataDir.mkdir()) {
            throw new IllegalStateException("The directory solvedDataDir (" + this.solvedDataDir.getAbsolutePath() + ") does not exist and could not be created.");
        }
        if (this.hasExporter()) {
            this.exportDataDir = new File(this.dataDir, "export");
            if (!this.exportDataDir.exists() && !this.exportDataDir.mkdir()) {
                throw new IllegalStateException("The directory exportDataDir (" + this.exportDataDir.getAbsolutePath() + ") does not exist and could not be created.");
            }
        }
    }

    public File getImportDataDir() {
        return this.importDataDir;
    }

    public File getUnsolvedDataDir() {
        return this.unsolvedDataDir;
    }

    public File getSolvedDataDir() {
        return this.solvedDataDir;
    }

    public File getExportDataDir() {
        return this.exportDataDir;
    }

    public String getExportFileSuffix() {
        return this.exporter.getOutputFileSuffix();
    }

    public void setSolver(Solver<Solution_> solver) {
        this.solver = solver;
        ScoreDirectorFactory scoreDirectorFactory = solver.getScoreDirectorFactory();
        this.guiScoreDirector = scoreDirectorFactory.buildScoreDirector();
    }

    public List<File> getUnsolvedFileList() {
        ArrayList<File> fileList = new ArrayList<File>(FileUtils.listFiles((File)this.unsolvedDataDir, (String[])new String[]{this.solutionFileIO.getInputFileExtension()}, (boolean)true));
        Collections.sort(fileList, FILE_COMPARATOR);
        return fileList;
    }

    public List<File> getSolvedFileList() {
        ArrayList<File> fileList = new ArrayList<File>(FileUtils.listFiles((File)this.solvedDataDir, (String[])new String[]{this.solutionFileIO.getOutputFileExtension()}, (boolean)true));
        Collections.sort(fileList, FILE_COMPARATOR);
        return fileList;
    }

    public Solution_ getSolution() {
        return (Solution_)this.guiScoreDirector.getWorkingSolution();
    }

    public void setSolution(Solution_ solution) {
        this.guiScoreDirector.setWorkingSolution(solution);
    }

    public String getSolutionFileName() {
        return this.solutionFileName;
    }

    public void setSolutionFileName(String solutionFileName) {
        this.solutionFileName = solutionFileName;
    }

    public Score getScore() {
        return this.guiScoreDirector.calculateScore();
    }

    public boolean isSolving() {
        return this.solver.isSolving();
    }

    public void registerForBestSolutionChanges(SolverAndPersistenceFrame solverAndPersistenceFrame) {
        this.solver.addEventListener(event -> {
            if (this.solver.isEveryProblemFactChangeProcessed()) {
                Object newBestSolution = event.getNewBestSolution();
                this.skipToBestSolutionRef.set(newBestSolution);
                SwingUtilities.invokeLater(() -> {
                    Solution_ skipToBestSolution = this.skipToBestSolutionRef.get();
                    if (newBestSolution != skipToBestSolution) {
                        return;
                    }
                    this.guiScoreDirector.setWorkingSolution(newBestSolution);
                    solverAndPersistenceFrame.bestSolutionChanged();
                });
            }
        });
    }

    public boolean isConstraintMatchEnabled() {
        return this.guiScoreDirector.isConstraintMatchEnabled();
    }

    public List<ConstraintMatchTotal> getConstraintMatchTotalList() {
        ArrayList<ConstraintMatchTotal> constraintMatchTotalList = new ArrayList<ConstraintMatchTotal>(this.guiScoreDirector.getConstraintMatchTotals());
        Collections.sort(constraintMatchTotalList);
        return constraintMatchTotalList;
    }

    public Map<Object, Indictment> getIndictmentMap() {
        return this.guiScoreDirector.getIndictmentMap();
    }

    public void importSolution(File file) {
        AbstractSolutionImporter<Solution_> importer = this.determineImporter(file);
        Solution_ solution = importer.readSolution(file);
        this.solutionFileName = file.getName();
        this.guiScoreDirector.setWorkingSolution(solution);
    }

    private AbstractSolutionImporter<Solution_> determineImporter(File file) {
        for (AbstractSolutionImporter<Solution_> importer : this.importers) {
            if (!importer.acceptInputFile(file)) continue;
            return importer;
        }
        return this.importers[0];
    }

    public void openSolution(File file) {
        Object solution = this.solutionFileIO.read(file);
        this.logger.info("Opened: {}", (Object)file);
        this.solutionFileName = file.getName();
        this.guiScoreDirector.setWorkingSolution(solution);
    }

    public void saveSolution(File file) {
        Object solution = this.guiScoreDirector.getWorkingSolution();
        this.solutionFileIO.write(solution, file);
        this.logger.info("Saved: {}", (Object)file);
    }

    public void exportSolution(File file) {
        Object solution = this.guiScoreDirector.getWorkingSolution();
        this.exporter.writeSolution(solution, file);
    }

    public void doMove(Move<Solution_> move) {
        if (this.solver.isSolving()) {
            this.logger.error("Not doing user move ({}) because the solver is solving.", move);
            return;
        }
        if (!move.isMoveDoable(this.guiScoreDirector)) {
            this.logger.warn("Not doing user move ({}) because it is not doable.", move);
            return;
        }
        this.logger.info("Doing user move ({}).", move);
        move.doMove(this.guiScoreDirector);
        this.guiScoreDirector.calculateScore();
    }

    public void doProblemFactChange(ProblemFactChange<Solution_> problemFactChange) {
        if (this.solver.isSolving()) {
            this.solver.addProblemFactChange(problemFactChange);
        } else {
            problemFactChange.doChange(this.guiScoreDirector);
            this.guiScoreDirector.calculateScore();
        }
    }

    public Solution_ solve(Solution_ problem) {
        return (Solution_)this.solver.solve(problem);
    }

    public void terminateSolvingEarly() {
        this.solver.terminateEarly();
    }

    public ChangeMove<Solution_> createChangeMove(Object entity, String variableName, Object toPlanningValue) {
        InnerScoreDirector guiInnerScoreDirector = (InnerScoreDirector)this.guiScoreDirector;
        SolutionDescriptor solutionDescriptor = guiInnerScoreDirector.getSolutionDescriptor();
        GenuineVariableDescriptor variableDescriptor = solutionDescriptor.findGenuineVariableDescriptorOrFail(entity, variableName);
        if (variableDescriptor.isChained()) {
            SupplyManager supplyManager = guiInnerScoreDirector.getSupplyManager();
            SingletonInverseVariableSupply inverseVariableSupply = (SingletonInverseVariableSupply)supplyManager.demand((Demand)new SingletonInverseVariableDemand((VariableDescriptor)variableDescriptor));
            return new ChainedChangeMove(entity, variableDescriptor, inverseVariableSupply, toPlanningValue);
        }
        return new ChangeMove(entity, variableDescriptor, toPlanningValue);
    }

    public void doChangeMove(Object entity, String variableName, Object toPlanningValue) {
        ChangeMove<Solution_> move = this.createChangeMove(entity, variableName, toPlanningValue);
        this.doMove((Move<Solution_>)move);
    }

    public SwapMove<Solution_> createSwapMove(Object leftEntity, Object rightEntity) {
        InnerScoreDirector guiInnerScoreDirector = (InnerScoreDirector)this.guiScoreDirector;
        SolutionDescriptor solutionDescriptor = guiInnerScoreDirector.getSolutionDescriptor();
        EntityDescriptor entityDescriptor = solutionDescriptor.findEntityDescriptor(leftEntity.getClass());
        List variableDescriptorList = entityDescriptor.getGenuineVariableDescriptorList();
        if (entityDescriptor.hasAnyChainedGenuineVariables()) {
            ArrayList<SingletonInverseVariableSupply> inverseVariableSupplyList = new ArrayList<SingletonInverseVariableSupply>(variableDescriptorList.size());
            SupplyManager supplyManager = guiInnerScoreDirector.getSupplyManager();
            for (GenuineVariableDescriptor variableDescriptor : variableDescriptorList) {
                SingletonInverseVariableSupply inverseVariableSupply = variableDescriptor.isChained() ? (SingletonInverseVariableSupply)supplyManager.demand((Demand)new SingletonInverseVariableDemand((VariableDescriptor)variableDescriptor)) : null;
                inverseVariableSupplyList.add(inverseVariableSupply);
            }
            return new ChainedSwapMove(variableDescriptorList, inverseVariableSupplyList, leftEntity, rightEntity);
        }
        return new SwapMove(variableDescriptorList, leftEntity, rightEntity);
    }

    public void doSwapMove(Object leftEntity, Object rightEntity) {
        SwapMove<Solution_> move = this.createSwapMove(leftEntity, rightEntity);
        this.doMove((Move<Solution_>)move);
    }
}

