/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.common.persistence;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Objects;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.optaplanner.examples.common.app.CommonApp;
import org.optaplanner.examples.common.app.LoggingTest;
import org.optaplanner.examples.common.business.ProblemFileComparator;
import org.optaplanner.examples.common.persistence.AbstractSolutionImporter;

@RunWith(value=Parameterized.class)
public abstract class ImportDataFilesTest<Solution_>
extends LoggingTest {
    protected final File importFile;
    protected AbstractSolutionImporter<Solution_> solutionImporter;

    protected static <Solution_> Collection<Object[]> getInputFilesAsParameters(String dataDirName, AbstractSolutionImporter solutionImporter) {
        File importDir = new File(CommonApp.determineDataDir((String)dataDirName), "import");
        ArrayList<Object> fileList = solutionImporter.isInputFileDirectory() ? new ArrayList<Object>(Arrays.asList((Object[])Objects.requireNonNull(importDir.listFiles((FileFilter)DirectoryFileFilter.INSTANCE)))) : new ArrayList(FileUtils.listFiles((File)importDir, (String[])new String[]{solutionImporter.getInputFileSuffix()}, (boolean)true));
        fileList.sort((Comparator<Object>)new ProblemFileComparator());
        ArrayList<Object[]> filesAsParameters = new ArrayList<Object[]>();
        for (File file : fileList) {
            filesAsParameters.add(new Object[]{file});
        }
        return filesAsParameters;
    }

    protected ImportDataFilesTest(File importFile) {
        this.importFile = importFile;
    }

    @Before
    public void setUp() {
        this.solutionImporter = this.createSolutionImporter();
    }

    protected abstract AbstractSolutionImporter<Solution_> createSolutionImporter();

    @Test
    public void readSolution() {
        this.solutionImporter.readSolution(this.importFile);
    }
}

