/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.common.app;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.optaplanner.core.api.solver.SolverFactory;
import org.optaplanner.core.config.constructionheuristic.ConstructionHeuristicPhaseConfig;
import org.optaplanner.core.config.constructionheuristic.ConstructionHeuristicType;
import org.optaplanner.core.config.solver.SolverConfig;
import org.optaplanner.core.config.solver.termination.TerminationConfig;
import org.optaplanner.examples.common.app.AbstractPhaseTest;
import org.optaplanner.examples.common.persistence.SolutionDao;
import org.optaplanner.examples.curriculumcourse.persistence.CurriculumCourseDao;

public abstract class AbstractConstructionHeuristicTest<Solution_>
extends AbstractPhaseTest<Solution_> {
    protected ConstructionHeuristicType constructionHeuristicType;

    protected static <Solution_> Collection<Object[]> buildParameters(SolutionDao<Solution_> solutionDao, String ... unsolvedFileNames) {
        if (solutionDao instanceof CurriculumCourseDao) {
            ArrayList<ConstructionHeuristicType> typeList = new ArrayList<ConstructionHeuristicType>();
            for (ConstructionHeuristicType type : ConstructionHeuristicType.values()) {
                if (type == ConstructionHeuristicType.ALLOCATE_TO_VALUE_FROM_QUEUE) continue;
                typeList.add(type);
            }
            return AbstractConstructionHeuristicTest.buildParameters(solutionDao, (Enum[])((Enum[])typeList.toArray(new ConstructionHeuristicType[0])), (String[])unsolvedFileNames);
        }
        return AbstractConstructionHeuristicTest.buildParameters(solutionDao, (Enum[])ConstructionHeuristicType.values(), (String[])unsolvedFileNames);
    }

    protected AbstractConstructionHeuristicTest(File dataFile, ConstructionHeuristicType constructionHeuristicType) {
        super(dataFile);
        this.constructionHeuristicType = constructionHeuristicType;
    }

    @Override
    protected SolverFactory<Solution_> buildSolverFactory() {
        SolverFactory solverFactory = SolverFactory.createFromXmlResource((String)this.createSolverConfigResource());
        SolverConfig solverConfig = solverFactory.getSolverConfig();
        solverConfig.setTerminationConfig(new TerminationConfig());
        ConstructionHeuristicPhaseConfig constructionHeuristicPhaseConfig = new ConstructionHeuristicPhaseConfig();
        constructionHeuristicPhaseConfig.setConstructionHeuristicType(this.constructionHeuristicType);
        solverConfig.setPhaseConfigList(Arrays.asList(constructionHeuristicPhaseConfig));
        return solverFactory;
    }
}

