/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.common.app;

import java.util.Random;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.junit.Test;
import org.optaplanner.core.api.solver.Solver;
import org.optaplanner.core.api.solver.SolverFactory;
import org.optaplanner.core.config.solver.SolverConfig;
import org.optaplanner.core.config.solver.termination.TerminationConfig;
import org.optaplanner.core.impl.solver.ProblemFactChange;
import org.optaplanner.examples.common.app.AbstractTurtleTest;

public abstract class RealTimePlanningTurtleTest<Solution_>
extends AbstractTurtleTest {
    public static final int FREQUENCY = 300;
    public static final long SPENT_LIMIT = 5000L;
    protected Solver<Solution_> solver;

    @Test
    public void realTimePlanning() throws InterruptedException, ExecutionException {
        RealTimePlanningTurtleTest.checkRunTurtleTests();
        SolverFactory<Solution_> solverFactory = this.buildSolverFactory();
        Solution_ problem = this.readProblem();
        this.solver = solverFactory.buildSolver();
        ExecutorService executorService = Executors.newFixedThreadPool(2);
        Future<?> solveFuture = executorService.submit(() -> this.runSolve(this.solver, problem));
        Future<?> changesFuture = executorService.submit(() -> this.runChanges());
        solveFuture.get();
        changesFuture.get();
    }

    protected SolverFactory<Solution_> buildSolverFactory() {
        SolverFactory solverFactory = SolverFactory.createFromXmlResource((String)this.createSolverConfigResource());
        SolverConfig solverConfig = solverFactory.getSolverConfig();
        solverConfig.setDaemon(Boolean.valueOf(true));
        TerminationConfig terminationConfig = new TerminationConfig();
        terminationConfig.setMillisecondsSpentLimit(Long.valueOf(5000L));
        solverConfig.setTerminationConfig(terminationConfig);
        return solverFactory;
    }

    protected abstract String createSolverConfigResource();

    protected abstract Solution_ readProblem();

    protected void runSolve(Solver<Solution_> solver, Solution_ problem) {
        solver.solve(problem);
    }

    protected void runChanges() {
        Random random = new Random(37L);
        long startSystemTimeMillis = System.currentTimeMillis();
        while (System.currentTimeMillis() - startSystemTimeMillis < 600000L) {
            ProblemFactChange<Solution_> factChange = this.nextProblemFactChange(random);
            this.solver.addProblemFactChange(factChange);
            long sleepMillis = random.nextInt(300);
            if (sleepMillis <= 3L) {
                sleepMillis = 5500L;
            } else if (sleepMillis <= 30L) {
                sleepMillis = 0L;
            }
            try {
                Thread.sleep(sleepMillis);
            }
            catch (InterruptedException e) {
                this.solver.terminateEarly();
                throw new IllegalStateException("runChanges() interrupted.", e);
            }
        }
        this.solver.terminateEarly();
    }

    protected abstract ProblemFactChange<Solution_> nextProblemFactChange(Random var1);
}

