/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.common.app;

import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.optaplanner.core.api.solver.SolverFactory;
import org.optaplanner.core.config.exhaustivesearch.ExhaustiveSearchPhaseConfig;
import org.optaplanner.core.config.exhaustivesearch.ExhaustiveSearchType;
import org.optaplanner.core.config.solver.SolverConfig;
import org.optaplanner.core.config.solver.termination.TerminationConfig;
import org.optaplanner.examples.common.app.AbstractPhaseTest;
import org.optaplanner.examples.common.app.CommonApp;

@RunWith(value=Parameterized.class)
public abstract class AbstractExhaustiveSearchTest<Solution_>
extends AbstractPhaseTest<Solution_> {
    protected ExhaustiveSearchType exhaustiveSearchType;

    protected static <Solution_> Collection<Object[]> buildParameters(CommonApp<Solution_> commonApp, String ... unsolvedFileNames) {
        return AbstractExhaustiveSearchTest.buildParameters(commonApp, (Enum[])ExhaustiveSearchType.values(), (String[])unsolvedFileNames);
    }

    protected AbstractExhaustiveSearchTest(CommonApp<Solution_> commonApp, File dataFile, ExhaustiveSearchType exhaustiveSearchType) {
        super(commonApp, dataFile);
        this.exhaustiveSearchType = exhaustiveSearchType;
    }

    @Override
    protected SolverFactory<Solution_> buildSolverFactory() {
        SolverConfig solverConfig = SolverConfig.createFromXmlResource((String)this.commonApp.getSolverConfigResource());
        solverConfig.setTerminationConfig(new TerminationConfig());
        ExhaustiveSearchPhaseConfig exhaustiveSearchPhaseConfig = new ExhaustiveSearchPhaseConfig();
        exhaustiveSearchPhaseConfig.setExhaustiveSearchType(this.exhaustiveSearchType);
        solverConfig.setPhaseConfigList(Arrays.asList(exhaustiveSearchPhaseConfig));
        return SolverFactory.create((SolverConfig)solverConfig);
    }
}

