/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.common.persistence;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.FilenameUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.optaplanner.examples.common.persistence.AbstractSolutionImporter;

public abstract class AbstractXlsxSolutionImporter<Solution_>
extends AbstractSolutionImporter<Solution_> {
    private static final String DEFAULT_INPUT_FILE_SUFFIX = "xlsx";

    @Override
    public String getInputFileSuffix() {
        return DEFAULT_INPUT_FILE_SUFFIX;
    }

    public abstract XlsxInputBuilder<Solution_> createXlsxInputBuilder();

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public Solution_ readSolution(File inputFile) {
        try {
            Throwable throwable = null;
            try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(inputFile));){
                Solution_ Solution_;
                XSSFWorkbook workbook = new XSSFWorkbook((InputStream)in);
                XlsxInputBuilder<Solution_> xlsxInputBuilder = this.createXlsxInputBuilder();
                xlsxInputBuilder.setInputFile(inputFile);
                xlsxInputBuilder.setWorkbook(workbook);
                try {
                    Solution_ solution = xlsxInputBuilder.readSolution();
                    this.logger.info("Imported: {}", (Object)inputFile);
                    Solution_ = solution;
                }
                catch (IllegalArgumentException | IllegalStateException e) {
                    try {
                        throw new IllegalArgumentException("Exception in inputFile (" + inputFile + ")", e);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                }
                return Solution_;
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Could not read the file (" + inputFile.getName() + ").", e);
        }
    }

    public static abstract class XlsxInputBuilder<Solution_>
    extends AbstractSolutionImporter.InputBuilder {
        protected File inputFile;
        protected XSSFWorkbook workbook;

        public void setInputFile(File inputFile) {
            this.inputFile = inputFile;
        }

        public void setWorkbook(XSSFWorkbook document) {
            this.workbook = document;
        }

        public abstract Solution_ readSolution() throws IOException;

        public String getInputId() {
            return FilenameUtils.getBaseName((String)this.inputFile.getPath());
        }

        protected XSSFSheet readSheet(int index, String name) {
            XSSFSheet sheet = this.workbook.getSheetAt(index);
            if (!sheet.getSheetName().equals(name)) {
                throw new IllegalArgumentException("The sheet (" + sheet.getSheetName() + ") at index (" + index + ") is expected to have another name (" + name + ")");
            }
            return sheet;
        }

        protected void assertCellConstant(Cell cell, String constant) {
            if (!constant.equals(cell.getStringCellValue())) {
                throw new IllegalArgumentException("The cell (" + cell.getRow().getRowNum() + "," + cell.getColumnIndex() + ") with value (" + cell.getStringCellValue() + ") is expected to have the constant (" + constant + ")");
            }
        }

        protected long readLongCell(Cell cell) {
            long l;
            double d = cell.getNumericCellValue();
            if (d - (double)(l = (long)d) != 0.0) {
                throw new IllegalArgumentException("The keyCell (" + cell.getRow().getRowNum() + "," + cell.getColumnIndex() + ") with value (" + d + ") is expected to be a long.");
            }
            return l;
        }

        protected double readDoubleCell(Cell cell) {
            return cell.getNumericCellValue();
        }

        protected String readStringCell(Cell cell) {
            return cell.getStringCellValue();
        }

        protected String readStringParameter(Row row, String key) {
            Cell keyCell = row.getCell(0);
            if (!key.equals(keyCell.getStringCellValue())) {
                throw new IllegalArgumentException("The keyCell (" + keyCell.getRow().getRowNum() + "," + keyCell.getColumnIndex() + ") with value (" + keyCell.getStringCellValue() + ") is expected to have the key (" + key + ")");
            }
            Cell valueCell = row.getCell(1);
            return valueCell.getStringCellValue();
        }

        protected double readDoubleParameter(Row row, String key) {
            Cell keyCell = row.getCell(0);
            if (!key.equals(keyCell.getStringCellValue())) {
                throw new IllegalArgumentException("The keyCell (" + keyCell.getRow().getRowNum() + "," + keyCell.getColumnIndex() + ") with value (" + keyCell.getStringCellValue() + ") is expected to have the key (" + key + ")");
            }
            Cell valueCell = row.getCell(1);
            return valueCell.getNumericCellValue();
        }
    }
}

