/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.nqueens.app;

import java.io.File;
import java.util.Arrays;
import org.junit.Test;
import org.optaplanner.benchmark.api.PlannerBenchmark;
import org.optaplanner.benchmark.api.PlannerBenchmarkFactory;
import org.optaplanner.benchmark.config.PlannerBenchmarkConfig;
import org.optaplanner.benchmark.config.ProblemBenchmarksConfig;
import org.optaplanner.benchmark.config.statistic.ProblemStatisticType;
import org.optaplanner.benchmark.config.statistic.SingleStatisticType;
import org.optaplanner.benchmark.impl.DefaultPlannerBenchmark;
import org.optaplanner.examples.common.app.PlannerBenchmarkTest;
import org.optaplanner.examples.nqueens.domain.NQueens;
import org.optaplanner.persistence.xstream.impl.domain.solution.XStreamSolutionFileIO;

public class NQueensBenchmarkTest
extends PlannerBenchmarkTest {
    public NQueensBenchmarkTest() {
        super("org/optaplanner/examples/nqueens/solver/nqueensSolverConfig.xml");
    }

    @Test(timeout=600000L)
    public void benchmark64queens() {
        NQueens problem = (NQueens)new XStreamSolutionFileIO(new Class[]{NQueens.class}).read(new File("data/nqueens/unsolved/64queens.xml"));
        PlannerBenchmarkConfig benchmarkConfig = this.buildPlannerBenchmarkConfig();
        this.addAllStatistics(benchmarkConfig);
        benchmarkConfig.setParallelBenchmarkCount("AUTO");
        PlannerBenchmark benchmark = PlannerBenchmarkFactory.create((PlannerBenchmarkConfig)benchmarkConfig).buildPlannerBenchmark((Object[])new NQueens[]{problem});
        benchmark.benchmark();
    }

    @Test(timeout=600000L)
    public void benchmark64queensSingleThread() {
        NQueens problem = (NQueens)new XStreamSolutionFileIO(new Class[]{NQueens.class}).read(new File("data/nqueens/unsolved/64queens.xml"));
        PlannerBenchmarkConfig benchmarkConfig = this.buildPlannerBenchmarkConfig();
        this.addAllStatistics(benchmarkConfig);
        benchmarkConfig.setParallelBenchmarkCount("1");
        PlannerBenchmark benchmark = PlannerBenchmarkFactory.create((PlannerBenchmarkConfig)benchmarkConfig).buildPlannerBenchmark((Object[])new NQueens[]{problem});
        benchmark.benchmark();
    }

    protected void addAllStatistics(PlannerBenchmarkConfig benchmarkConfig) {
        ProblemBenchmarksConfig problemBenchmarksConfig = new ProblemBenchmarksConfig();
        problemBenchmarksConfig.setSingleStatisticTypeList(Arrays.asList(SingleStatisticType.values()));
        problemBenchmarksConfig.setProblemStatisticTypeList(Arrays.asList(ProblemStatisticType.values()));
        benchmarkConfig.getInheritedSolverBenchmarkConfig().setProblemBenchmarksConfig(problemBenchmarksConfig);
    }

    @Test
    public void benchmarkDirectoryNameDuplication() {
        NQueens problem = (NQueens)new XStreamSolutionFileIO(new Class[]{NQueens.class}).read(new File("data/nqueens/unsolved/4queens.xml"));
        PlannerBenchmarkConfig benchmarkConfig = this.buildPlannerBenchmarkConfig();
        PlannerBenchmarkFactory benchmarkFactory = PlannerBenchmarkFactory.create((PlannerBenchmarkConfig)benchmarkConfig);
        DefaultPlannerBenchmark plannerBenchmark = (DefaultPlannerBenchmark)benchmarkFactory.buildPlannerBenchmark((Object[])new NQueens[]{problem});
        plannerBenchmark.benchmarkingStarted();
        plannerBenchmark.getPlannerBenchmarkResult().initBenchmarkReportDirectory(benchmarkConfig.getBenchmarkDirectory());
        plannerBenchmark.getPlannerBenchmarkResult().initBenchmarkReportDirectory(benchmarkConfig.getBenchmarkDirectory());
    }
}

