/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.examination.domain;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import org.optaplanner.core.api.domain.constraintweight.ConstraintConfiguration;
import org.optaplanner.core.api.domain.constraintweight.ConstraintWeight;
import org.optaplanner.core.api.score.buildin.hardsoft.HardSoftScore;
import org.optaplanner.examples.common.domain.AbstractPersistable;

@ConstraintConfiguration(constraintPackage="org.optaplanner.examples.examination.solver")
@XStreamAlias(value="ExaminationConstraintConfiguration")
public class ExaminationConstraintConfiguration
extends AbstractPersistable {
    private int twoInARowPenalty;
    private int twoInADayPenalty;
    private int periodSpreadLength;
    private int periodSpreadPenalty;
    private int mixedDurationPenalty;
    private int frontLoadLargeTopicSize;
    private int frontLoadLastPeriodSize;
    private int frontLoadPenalty;

    @ConstraintWeight(value="twoExamsInARow")
    public HardSoftScore getTwoInARowPenaltyAsScore() {
        return HardSoftScore.ofSoft((int)this.twoInARowPenalty);
    }

    @ConstraintWeight(value="twoExamsInADay")
    public HardSoftScore getTwoInADayPenaltyAsScore() {
        return HardSoftScore.ofSoft((int)this.twoInADayPenalty);
    }

    @ConstraintWeight(value="periodSpread")
    public HardSoftScore getPeriodSpreadPenaltyAsScore() {
        return HardSoftScore.ofSoft((int)this.periodSpreadPenalty);
    }

    @ConstraintWeight(value="mixedDurations")
    public HardSoftScore getMixedDurationPenaltyAsScore() {
        return HardSoftScore.ofSoft((int)this.mixedDurationPenalty);
    }

    @ConstraintWeight(value="frontLoad")
    public HardSoftScore getFrontLoadPenaltyAsScore() {
        return HardSoftScore.ofSoft((int)this.frontLoadPenalty);
    }

    public int getTwoInARowPenalty() {
        return this.twoInARowPenalty;
    }

    public void setTwoInARowPenalty(int twoInARowPenalty) {
        this.twoInARowPenalty = twoInARowPenalty;
    }

    public int getTwoInADayPenalty() {
        return this.twoInADayPenalty;
    }

    public void setTwoInADayPenalty(int twoInADayPenalty) {
        this.twoInADayPenalty = twoInADayPenalty;
    }

    public int getPeriodSpreadLength() {
        return this.periodSpreadLength;
    }

    public void setPeriodSpreadLength(int periodSpreadLength) {
        this.periodSpreadLength = periodSpreadLength;
    }

    public int getPeriodSpreadPenalty() {
        return this.periodSpreadPenalty;
    }

    public void setPeriodSpreadPenalty(int periodSpreadPenalty) {
        this.periodSpreadPenalty = periodSpreadPenalty;
    }

    public int getMixedDurationPenalty() {
        return this.mixedDurationPenalty;
    }

    public void setMixedDurationPenalty(int mixedDurationPenalty) {
        this.mixedDurationPenalty = mixedDurationPenalty;
    }

    public int getFrontLoadLargeTopicSize() {
        return this.frontLoadLargeTopicSize;
    }

    public void setFrontLoadLargeTopicSize(int frontLoadLargeTopicSize) {
        this.frontLoadLargeTopicSize = frontLoadLargeTopicSize;
    }

    public int getFrontLoadLastPeriodSize() {
        return this.frontLoadLastPeriodSize;
    }

    public void setFrontLoadLastPeriodSize(int frontLoadLastPeriodSize) {
        this.frontLoadLastPeriodSize = frontLoadLastPeriodSize;
    }

    public int getFrontLoadPenalty() {
        return this.frontLoadPenalty;
    }

    public void setFrontLoadPenalty(int frontLoadPenalty) {
        this.frontLoadPenalty = frontLoadPenalty;
    }
}

