/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.common.app;

import java.io.File;
import java.util.stream.Stream;
import org.junit.Assert;
import org.junit.jupiter.api.DynamicContainer;
import org.junit.jupiter.api.DynamicTest;
import org.junit.jupiter.api.TestFactory;
import org.junit.jupiter.api.Timeout;
import org.optaplanner.core.api.score.ScoreManager;
import org.optaplanner.core.api.solver.Solver;
import org.optaplanner.core.api.solver.SolverFactory;
import org.optaplanner.examples.common.app.CommonApp;
import org.optaplanner.examples.common.app.LoggingTest;
import org.optaplanner.persistence.common.api.domain.solution.SolutionFileIO;

public abstract class AbstractPhaseTest<Solution_, T>
extends LoggingTest {
    protected abstract CommonApp<Solution_> createCommonApp();

    protected abstract Stream<String> unsolvedFileNames();

    protected abstract Stream<T> solverFactoryParams();

    protected abstract SolverFactory<Solution_> buildSolverFactory(CommonApp<Solution_> var1, T var2);

    protected void assertSolution(Solution_ bestSolution) {
        Assert.assertNotNull(bestSolution);
    }

    @TestFactory
    @Timeout(value=600L)
    Stream<DynamicContainer> runPhase() {
        CommonApp<Solution_> commonApp = this.createCommonApp();
        SolutionFileIO solutionFileIO = commonApp.createSolutionFileIO();
        File dataDir = CommonApp.determineDataDir((String)commonApp.getDataDirName());
        File unsolvedDataDir = new File(dataDir, "unsolved");
        return this.solverFactoryParams().map(solverFactoryParam -> {
            SolverFactory<Solution_> solverFactory = this.buildSolverFactory(commonApp, solverFactoryParam);
            return DynamicContainer.dynamicContainer((String)solverFactoryParam.toString(), this.unsolvedFileNames().map(unsolvedFileName -> {
                File dataFile = AbstractPhaseTest.buildFile(unsolvedDataDir, unsolvedFileName);
                return DynamicTest.dynamicTest((String)unsolvedFileName, () -> this.runPhase(solverFactory, this.readProblem(solutionFileIO, dataFile)));
            }));
        });
    }

    private void runPhase(SolverFactory<Solution_> solverFactory, Solution_ problem) {
        Solver solver = solverFactory.buildSolver();
        Object bestSolution = solver.solve(problem);
        this.assertSolution(bestSolution);
        ScoreManager scoreManager = ScoreManager.create(solverFactory);
        Assert.assertNotNull((Object)scoreManager.updateScore(bestSolution));
    }

    private static File buildFile(File unsolvedDataDir, String unsolvedFileName) {
        File unsolvedFile = new File(unsolvedDataDir, unsolvedFileName);
        if (!unsolvedFile.exists()) {
            throw new IllegalStateException("The directory unsolvedFile (" + unsolvedFile.getAbsolutePath() + ") does not exist.");
        }
        return unsolvedFile;
    }

    private Solution_ readProblem(SolutionFileIO<Solution_> solutionFileIO, File dataFile) {
        Object problem = solutionFileIO.read(dataFile);
        this.logger.info("Opened: {}", (Object)dataFile);
        return (Solution_)problem;
    }
}

