/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.common.app;

import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import java.util.stream.Stream;
import org.junit.Assert;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.DynamicTest;
import org.junit.jupiter.api.TestFactory;
import org.junit.jupiter.api.Timeout;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.constraint.ConstraintMatchTotal;
import org.optaplanner.core.api.solver.Solver;
import org.optaplanner.core.api.solver.SolverFactory;
import org.optaplanner.core.config.solver.EnvironmentMode;
import org.optaplanner.core.config.solver.SolverConfig;
import org.optaplanner.core.config.solver.termination.TerminationConfig;
import org.optaplanner.core.impl.score.definition.ScoreDefinition;
import org.optaplanner.core.impl.score.director.InnerScoreDirector;
import org.optaplanner.core.impl.score.director.InnerScoreDirectorFactory;
import org.optaplanner.examples.common.app.CommonApp;
import org.optaplanner.examples.common.app.LoggingTest;
import org.optaplanner.persistence.common.api.domain.solution.SolutionFileIO;

public abstract class SolverPerformanceTest<Solution_>
extends LoggingTest {
    private static final String MOVE_THREAD_COUNTS_STRING = System.getProperty("moveThreadCounts");
    protected SolutionFileIO<Solution_> solutionFileIO;
    protected String solverConfigResource;

    private static Stream<String> moveThreadCounts() {
        return Optional.ofNullable(MOVE_THREAD_COUNTS_STRING).map(s -> Arrays.stream(s.split(","))).orElse(Stream.of("NONE"));
    }

    @TestFactory
    @Timeout(value=600L)
    Stream<DynamicTest> runSpeedTest() {
        return SolverPerformanceTest.moveThreadCounts().flatMap(moveThreadCount -> this.testData().map(testData -> DynamicTest.dynamicTest((String)(((TestData)testData).unsolvedDataFile.replaceFirst(".*/", "") + ", " + ((TestData)testData).environmentMode + ", threads: " + moveThreadCount), () -> this.runSpeedTest(new File(((TestData)testData).unsolvedDataFile), ((TestData)testData).bestScoreLimit, ((TestData)testData).environmentMode, (String)moveThreadCount))));
    }

    @BeforeEach
    public void setUp() {
        CommonApp<Solution_> commonApp = this.createCommonApp();
        this.solutionFileIO = commonApp.createSolutionFileIO();
        this.solverConfigResource = commonApp.getSolverConfigResource();
    }

    protected abstract CommonApp<Solution_> createCommonApp();

    protected abstract Stream<TestData> testData();

    private void runSpeedTest(File unsolvedDataFile, String bestScoreLimitString, EnvironmentMode environmentMode, String moveThreadCount) {
        SolverFactory<Solution_> solverFactory = this.buildSolverFactory(bestScoreLimitString, environmentMode, moveThreadCount);
        Object problem = this.solutionFileIO.read(unsolvedDataFile);
        this.logger.info("Opened: {}", (Object)unsolvedDataFile);
        Solver solver = solverFactory.buildSolver();
        Object bestSolution = solver.solve(problem);
        this.assertScoreAndConstraintMatches(solverFactory, bestSolution, bestScoreLimitString);
    }

    private SolverFactory<Solution_> buildSolverFactory(String bestScoreLimitString, EnvironmentMode environmentMode, String moveThreadCount) {
        SolverConfig solverConfig = SolverConfig.createFromXmlResource((String)this.solverConfigResource);
        solverConfig.withEnvironmentMode(environmentMode).withTerminationConfig(new TerminationConfig().withBestScoreLimit(bestScoreLimitString)).withMoveThreadCount(moveThreadCount);
        return SolverFactory.create((SolverConfig)solverConfig);
    }

    private void assertScoreAndConstraintMatches(SolverFactory<Solution_> solverFactory, Solution_ bestSolution, String bestScoreLimitString) {
        Assert.assertNotNull(bestSolution);
        InnerScoreDirectorFactory scoreDirectorFactory = (InnerScoreDirectorFactory)solverFactory.getScoreDirectorFactory();
        Score bestScore = scoreDirectorFactory.getSolutionDescriptor().getScore(bestSolution);
        ScoreDefinition scoreDefinition = scoreDirectorFactory.getScoreDefinition();
        Score bestScoreLimit = scoreDefinition.parseScore(bestScoreLimitString);
        Assert.assertTrue((String)("The bestScore (" + bestScore + ") must be at least the bestScoreLimit (" + bestScoreLimit + ")."), (bestScore.compareTo((Object)bestScoreLimit) >= 0 ? 1 : 0) != 0);
        try (InnerScoreDirector scoreDirector = scoreDirectorFactory.buildScoreDirector();){
            scoreDirector.setWorkingSolution(bestSolution);
            Score score = scoreDirector.calculateScore();
            Assert.assertEquals((Object)score, (Object)bestScore);
            if (scoreDirector.isConstraintMatchEnabled()) {
                Collection constraintMatchTotals = scoreDirector.getConstraintMatchTotals();
                Assert.assertNotNull((Object)constraintMatchTotals);
                Assert.assertEquals((Object)score, (Object)constraintMatchTotals.stream().map(ConstraintMatchTotal::getScore).reduce(Score::add).orElse(scoreDefinition.getZeroScore()));
                Assert.assertNotNull((Object)scoreDirector.getIndictmentMap());
            }
        }
    }

    protected static TestData testData(String unsolvedDataFile, String bestScoreLimit, EnvironmentMode environmentMode) {
        return new TestData(unsolvedDataFile, bestScoreLimit, environmentMode);
    }

    protected static class TestData {
        private final String unsolvedDataFile;
        private final String bestScoreLimit;
        private final EnvironmentMode environmentMode;

        private TestData(String unsolvedDataFile, String bestScoreLimit, EnvironmentMode environmentMode) {
            this.unsolvedDataFile = unsolvedDataFile;
            this.bestScoreLimit = bestScoreLimit;
            this.environmentMode = environmentMode;
        }
    }
}

