/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.common.app;

import java.io.File;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.optaplanner.examples.common.app.CommonApp;
import org.optaplanner.examples.common.app.SolveAllTurtleTest;
import org.optaplanner.examples.common.business.ProblemFileComparator;
import org.optaplanner.examples.common.persistence.AbstractSolutionImporter;

public abstract class ImportDirSolveAllTurtleTest<Solution_>
extends SolveAllTurtleTest<Solution_> {
    private static <Solution_> List<File> getImportDirFiles(CommonApp<Solution_> commonApp) {
        File dataDir = CommonApp.determineDataDir((String)commonApp.getDataDirName());
        File importDataDir = new File(dataDir, "import");
        if (!importDataDir.exists()) {
            throw new IllegalStateException("The directory importDataDir (" + importDataDir.getAbsolutePath() + ") does not exist.");
        }
        String inputFileSuffix = ImportDirSolveAllTurtleTest.createSolutionImporter(commonApp).getInputFileSuffix();
        ArrayList<File> fileList = new ArrayList<File>(FileUtils.listFiles((File)importDataDir, (String[])new String[]{inputFileSuffix}, (boolean)true));
        fileList.sort((Comparator<File>)new ProblemFileComparator());
        return fileList;
    }

    private static <Solution_> AbstractSolutionImporter<Solution_> createSolutionImporter(CommonApp<Solution_> commonApp) {
        AbstractSolutionImporter[] importers = commonApp.createSolutionImporters();
        if (importers.length != 1) {
            throw new IllegalStateException("The importers size (" + importers.length + ") should be 1.");
        }
        return importers[0];
    }

    @Override
    protected List<File> getSolutionFiles(CommonApp<Solution_> commonApp) {
        return ImportDirSolveAllTurtleTest.getImportDirFiles(commonApp);
    }

    @Override
    protected SolveAllTurtleTest.ProblemFactory<Solution_> createProblemFactory(CommonApp<Solution_> commonApp) {
        AbstractSolutionImporter<Solution_> solutionImporter = ImportDirSolveAllTurtleTest.createSolutionImporter(commonApp);
        return arg_0 -> solutionImporter.readSolution(arg_0);
    }
}

