/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.coachshuttlegathering.domain.location;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.util.Map;
import org.optaplanner.examples.coachshuttlegathering.domain.location.RoadLocationArc;
import org.optaplanner.examples.common.domain.AbstractPersistable;

@XStreamAlias(value="CsgRoadLocation")
public class RoadLocation
extends AbstractPersistable {
    protected double latitude;
    protected double longitude;
    protected Map<RoadLocation, RoadLocationArc> travelDistanceMap;

    public RoadLocation() {
    }

    public RoadLocation(long id, double latitude, double longitude) {
        super(id);
        this.latitude = latitude;
        this.longitude = longitude;
    }

    public double getLatitude() {
        return this.latitude;
    }

    public void setLatitude(double latitude) {
        this.latitude = latitude;
    }

    public double getLongitude() {
        return this.longitude;
    }

    public void setLongitude(double longitude) {
        this.longitude = longitude;
    }

    public Map<RoadLocation, RoadLocationArc> getTravelDistanceMap() {
        return this.travelDistanceMap;
    }

    public void setTravelDistanceMap(Map<RoadLocation, RoadLocationArc> travelDistanceMap) {
        this.travelDistanceMap = travelDistanceMap;
    }

    public int getCoachDistanceTo(RoadLocation location) {
        return this.travelDistanceMap.get(location).getCoachDistance();
    }

    public int getCoachDurationTo(RoadLocation location) {
        return this.travelDistanceMap.get(location).getCoachDuration();
    }

    public int getShuttleDistanceTo(RoadLocation location) {
        return this.travelDistanceMap.get(location).getShuttleDistance();
    }

    public int getShuttleDurationTo(RoadLocation location) {
        return this.travelDistanceMap.get(location).getShuttleDuration();
    }

    public int getMaximumDistanceTo(RoadLocation location) {
        RoadLocationArc locationArc = this.travelDistanceMap.get(location);
        return Math.max(locationArc.getCoachDistance(), locationArc.getShuttleDistance());
    }

    public double getAirDistanceDouble(RoadLocation location) {
        double latitudeDifference = location.latitude - this.latitude;
        double longitudeDifference = location.longitude - this.longitude;
        return Math.sqrt(latitudeDifference * latitudeDifference + longitudeDifference * longitudeDifference);
    }

    public double getAngle(RoadLocation location) {
        double latitudeDifference = location.latitude - this.latitude;
        double longitudeDifference = location.longitude - this.longitude;
        return Math.atan2(latitudeDifference, longitudeDifference);
    }
}

