/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.common.persistence;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.jdom.Document;
import org.jdom.JDOMException;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.optaplanner.examples.common.persistence.AbstractSolutionExporter;
import org.optaplanner.examples.common.persistence.SolutionDao;

public abstract class AbstractXmlSolutionExporter<Solution_>
extends AbstractSolutionExporter<Solution_> {
    protected static final String DEFAULT_OUTPUT_FILE_SUFFIX = "xml";

    protected AbstractXmlSolutionExporter(SolutionDao<Solution_> solutionDao) {
        super(solutionDao);
    }

    protected AbstractXmlSolutionExporter(boolean withoutDao) {
        super(withoutDao);
    }

    @Override
    public String getOutputFileSuffix() {
        return DEFAULT_OUTPUT_FILE_SUFFIX;
    }

    public abstract XmlOutputBuilder<Solution_> createXmlOutputBuilder();

    @Override
    public void writeSolution(Solution_ solution, File outputFile) {
        try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(outputFile));){
            Document document = new Document();
            XmlOutputBuilder<Solution_> xmlOutputBuilder = this.createXmlOutputBuilder();
            xmlOutputBuilder.setDocument(document);
            xmlOutputBuilder.setSolution(solution);
            xmlOutputBuilder.writeSolution();
            XMLOutputter outputter = new XMLOutputter(Format.getPrettyFormat());
            outputter.output(document, (OutputStream)out);
            this.logger.info("Exported: {}", (Object)outputFile);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Could not write the file (" + outputFile.getName() + ").", e);
        }
        catch (JDOMException e) {
            throw new IllegalArgumentException("Could not format the XML file (" + outputFile.getName() + ").", e);
        }
    }

    public static abstract class XmlOutputBuilder<Solution_>
    extends AbstractSolutionExporter.OutputBuilder {
        protected Document document;

        public void setDocument(Document document) {
            this.document = document;
        }

        public abstract void setSolution(Solution_ var1);

        public abstract void writeSolution() throws IOException, JDOMException;
    }
}

