/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.common.app;

import java.io.File;
import java.util.Collections;
import org.optaplanner.benchmark.config.PlannerBenchmarkConfig;
import org.optaplanner.benchmark.config.SolverBenchmarkConfig;
import org.optaplanner.benchmark.config.blueprint.SolverBenchmarkBluePrintConfig;
import org.optaplanner.benchmark.config.blueprint.SolverBenchmarkBluePrintType;
import org.optaplanner.core.config.solver.SolverConfig;
import org.optaplanner.core.config.solver.termination.TerminationConfig;
import org.optaplanner.examples.common.app.LoggingTest;

public abstract class PlannerBenchmarkTest
extends LoggingTest {
    private static final long WARM_UP_SECONDS_SPENT = 2L;
    private static final long MAXIMUM_SECONDS_SPENT = 8L;
    private final String solverConfigResource;

    public PlannerBenchmarkTest(String solverConfigResource) {
        this.solverConfigResource = solverConfigResource;
    }

    protected PlannerBenchmarkConfig buildPlannerBenchmarkConfig() {
        SolverConfig solverConfig = SolverConfig.createFromXmlResource((String)this.solverConfigResource);
        File benchmarkDirectory = new File("target/test/data");
        PlannerBenchmarkConfig benchmarkConfig = PlannerBenchmarkConfig.createFromSolverConfig((SolverConfig)solverConfig, (File)benchmarkDirectory);
        benchmarkConfig.setWarmUpSecondsSpentLimit(Long.valueOf(2L));
        benchmarkConfig.setSolverBenchmarkConfigList(Collections.emptyList());
        benchmarkConfig.setSolverBenchmarkBluePrintConfigList(Collections.singletonList(new SolverBenchmarkBluePrintConfig().withSolverBenchmarkBluePrintType(SolverBenchmarkBluePrintType.CONSTRUCTION_HEURISTIC_WITH_AND_WITHOUT_LOCAL_SEARCH)));
        long maximumSecondsSpentPerSolverBenchmark = 4L;
        SolverBenchmarkConfig inheritedSolverBenchmarkConfig = benchmarkConfig.getInheritedSolverBenchmarkConfig();
        inheritedSolverBenchmarkConfig.getSolverConfig().setTerminationConfig(new TerminationConfig().withSecondsSpentLimit(Long.valueOf(maximumSecondsSpentPerSolverBenchmark)));
        return benchmarkConfig;
    }
}

