/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.nqueens.solver.score;

import java.io.IOException;
import java.io.InputStream;
import org.junit.jupiter.api.Test;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.buildin.simple.SimpleScore;
import org.optaplanner.core.api.score.stream.ConstraintProvider;
import org.optaplanner.examples.nqueens.domain.Column;
import org.optaplanner.examples.nqueens.domain.NQueens;
import org.optaplanner.examples.nqueens.domain.Queen;
import org.optaplanner.examples.nqueens.domain.Row;
import org.optaplanner.examples.nqueens.solver.score.NQueensConstraintProvider;
import org.optaplanner.persistence.xstream.impl.domain.solution.XStreamSolutionFileIO;
import org.optaplanner.test.api.score.stream.ConstraintVerifier;

public class NQueensConstraintProviderTest {
    private final ConstraintVerifier<NQueensConstraintProvider, NQueens> constraintVerifier = ConstraintVerifier.build((ConstraintProvider)new NQueensConstraintProvider(), NQueens.class, (Class[])new Class[]{Queen.class});
    private final Row row1 = new Row(0);
    private final Row row2 = new Row(1);
    private final Row row3 = new Row(2);
    private final Column column1 = new Column(0);
    private final Column column2 = new Column(1);
    private final Column column3 = new Column(2);

    @Test
    public void noHorizontalConflictWithOneQueen() {
        Queen queen1 = new Queen(0L, this.row1, this.column1);
        this.constraintVerifier.verifyThat(NQueensConstraintProvider::horizontalConflict).given(new Object[]{queen1}).penalizesBy(0);
    }

    @Test
    public void horizontalConflictWithTwoQueens() {
        Queen queen1 = new Queen(0L, this.row1, this.column1);
        Queen queen2 = new Queen(1L, this.row1, this.column2);
        this.constraintVerifier.verifyThat(NQueensConstraintProvider::horizontalConflict).given(new Object[]{queen1, queen2}).penalizesBy(1);
    }

    @Test
    public void horizontalConflictWithThreeQueens() {
        Queen queen1 = new Queen(0L, this.row1, this.column1);
        Queen queen2 = new Queen(1L, this.row1, this.column2);
        Queen queen3 = new Queen(2L, this.row1, this.column3);
        this.constraintVerifier.verifyThat(NQueensConstraintProvider::horizontalConflict).given(new Object[]{queen1, queen2, queen3}).penalizesBy(3);
    }

    @Test
    public void noAscendingDiagonalConflictWithOneQueen() {
        Queen queen1 = new Queen(0L, this.row1, this.column1);
        this.constraintVerifier.verifyThat(NQueensConstraintProvider::ascendingDiagonalConflict).given(new Object[]{queen1}).penalizesBy(0);
    }

    @Test
    public void ascendingDiagonalConflictWithTwoQueens() {
        Queen queen1 = new Queen(0L, this.row1, this.column2);
        Queen queen2 = new Queen(1L, this.row2, this.column1);
        this.constraintVerifier.verifyThat(NQueensConstraintProvider::ascendingDiagonalConflict).given(new Object[]{queen1, queen2}).penalizesBy(1);
    }

    @Test
    public void ascendingDiagonalConflictWithThreeQueens() {
        Queen queen1 = new Queen(0L, this.row1, this.column3);
        Queen queen2 = new Queen(1L, this.row2, this.column2);
        Queen queen3 = new Queen(2L, this.row3, this.column1);
        this.constraintVerifier.verifyThat(NQueensConstraintProvider::ascendingDiagonalConflict).given(new Object[]{queen1, queen2, queen3}).penalizesBy(3);
    }

    @Test
    public void noDescendingDiagonalConflictWithOneQueen() {
        Queen queen1 = new Queen(0L, this.row1, this.column1);
        this.constraintVerifier.verifyThat(NQueensConstraintProvider::descendingDiagonalConflict).given(new Object[]{queen1}).penalizesBy(0);
    }

    @Test
    public void descendingDiagonalConflictWithTwoQueens() {
        Queen queen1 = new Queen(0L, this.row1, this.column1);
        Queen queen2 = new Queen(1L, this.row2, this.column2);
        this.constraintVerifier.verifyThat(NQueensConstraintProvider::descendingDiagonalConflict).given(new Object[]{queen1, queen2}).penalizesBy(1);
    }

    @Test
    public void descendingDiagonalConflictWithThreeQueens() {
        Queen queen1 = new Queen(0L, this.row1, this.column1);
        Queen queen2 = new Queen(1L, this.row2, this.column2);
        Queen queen3 = new Queen(2L, this.row3, this.column3);
        this.constraintVerifier.verifyThat(NQueensConstraintProvider::descendingDiagonalConflict).given(new Object[]{queen1, queen2, queen3}).penalizesBy(3);
    }

    private static NQueens readSolution(String resource) throws IOException {
        XStreamSolutionFileIO solutionFileIO = new XStreamSolutionFileIO(new Class[]{NQueens.class});
        try (InputStream inputStream = NQueensConstraintProviderTest.class.getResourceAsStream(resource);){
            NQueens nQueens = (NQueens)solutionFileIO.read(inputStream);
            return nQueens;
        }
    }

    @Test
    public void givenSolutionMultipleConstraints() throws IOException {
        this.constraintVerifier.verifyThat().givenSolution((Object)NQueensConstraintProviderTest.readSolution("256queensScore-30.xml")).scores((Score)SimpleScore.of((int)-30));
    }

    @Test
    public void givenFactsMultipleConstraints() {
        Queen queen1 = new Queen(0L, this.row1, this.column1);
        Queen queen2 = new Queen(1L, this.row2, this.column2);
        Queen queen3 = new Queen(2L, this.row3, this.column3);
        this.constraintVerifier.verifyThat().given(new Object[]{queen1, queen2, queen3}).scores((Score)SimpleScore.of((int)-3));
    }
}

