/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.curriculumcourse.domain.solver;

import java.util.Comparator;
import org.optaplanner.core.impl.heuristic.selector.common.decorator.SelectionSorterWeightFactory;
import org.optaplanner.examples.common.domain.AbstractPersistable;
import org.optaplanner.examples.curriculumcourse.domain.Course;
import org.optaplanner.examples.curriculumcourse.domain.CourseSchedule;
import org.optaplanner.examples.curriculumcourse.domain.Lecture;
import org.optaplanner.examples.curriculumcourse.domain.UnavailablePeriodPenalty;

public class LectureDifficultyWeightFactory
implements SelectionSorterWeightFactory<CourseSchedule, Lecture> {
    public LectureDifficultyWeight createSorterWeight(CourseSchedule schedule, Lecture lecture) {
        Course course = lecture.getCourse();
        int unavailablePeriodPenaltyCount = 0;
        for (UnavailablePeriodPenalty penalty : schedule.getUnavailablePeriodPenaltyList()) {
            if (!penalty.getCourse().equals(course)) continue;
            ++unavailablePeriodPenaltyCount;
        }
        return new LectureDifficultyWeight(lecture, unavailablePeriodPenaltyCount);
    }

    public static class LectureDifficultyWeight
    implements Comparable<LectureDifficultyWeight> {
        private static final Comparator<LectureDifficultyWeight> COMPARATOR = Comparator.comparingInt(c -> c.lecture.getCurriculumList().size()).thenComparing(c -> c.unavailablePeriodPenaltyCount).thenComparingInt(c -> c.lecture.getCourse().getLectureSize()).thenComparingInt(c -> c.lecture.getCourse().getStudentSize()).thenComparing(c -> c.lecture.getCourse().getMinWorkingDaySize()).thenComparing(c -> c.lecture, Comparator.comparingLong(AbstractPersistable::getId));
        private final Lecture lecture;
        private final int unavailablePeriodPenaltyCount;

        public LectureDifficultyWeight(Lecture lecture, int unavailablePeriodPenaltyCount) {
            this.lecture = lecture;
            this.unavailablePeriodPenaltyCount = unavailablePeriodPenaltyCount;
        }

        @Override
        public int compareTo(LectureDifficultyWeight other) {
            return COMPARATOR.compare(this, other);
        }
    }
}

