/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.tsp.domain.solver;

import java.util.Comparator;
import org.optaplanner.core.impl.heuristic.selector.common.decorator.SelectionSorterWeightFactory;
import org.optaplanner.examples.common.domain.AbstractPersistable;
import org.optaplanner.examples.tsp.domain.Domicile;
import org.optaplanner.examples.tsp.domain.TspSolution;
import org.optaplanner.examples.tsp.domain.Visit;

public class DomicileAngleVisitDifficultyWeightFactory
implements SelectionSorterWeightFactory<TspSolution, Visit> {
    public DomicileAngleVisitDifficultyWeight createSorterWeight(TspSolution vehicleRoutingSolution, Visit visit) {
        Domicile domicile = vehicleRoutingSolution.getDomicile();
        return new DomicileAngleVisitDifficultyWeight(visit, visit.getLocation().getAngle(domicile.getLocation()), visit.getLocation().getDistanceTo(domicile.getLocation()) + domicile.getLocation().getDistanceTo(visit.getLocation()));
    }

    public static class DomicileAngleVisitDifficultyWeight
    implements Comparable<DomicileAngleVisitDifficultyWeight> {
        private static final Comparator<DomicileAngleVisitDifficultyWeight> COMPARATOR = Comparator.comparingDouble(weight -> weight.domicileAngle).thenComparingLong(weight -> weight.domicileRoundTripDistance).thenComparing(weight -> weight.visit, Comparator.comparingLong(AbstractPersistable::getId));
        private final Visit visit;
        private final double domicileAngle;
        private final long domicileRoundTripDistance;

        public DomicileAngleVisitDifficultyWeight(Visit visit, double domicileAngle, long domicileRoundTripDistance) {
            this.visit = visit;
            this.domicileAngle = domicileAngle;
            this.domicileRoundTripDistance = domicileRoundTripDistance;
        }

        @Override
        public int compareTo(DomicileAngleVisitDifficultyWeight other) {
            return COMPARATOR.compare(this, other);
        }
    }
}

