/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.tsp.domain;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import org.optaplanner.core.api.domain.entity.PlanningEntity;
import org.optaplanner.core.api.domain.variable.PlanningVariable;
import org.optaplanner.core.api.domain.variable.PlanningVariableGraphType;
import org.optaplanner.examples.common.domain.AbstractPersistable;
import org.optaplanner.examples.tsp.domain.Standstill;
import org.optaplanner.examples.tsp.domain.location.Location;
import org.optaplanner.examples.tsp.domain.solver.DomicileAngleVisitDifficultyWeightFactory;
import org.optaplanner.examples.tsp.domain.solver.DomicileDistanceStandstillStrengthWeightFactory;

@PlanningEntity(difficultyWeightFactoryClass=DomicileAngleVisitDifficultyWeightFactory.class)
@XStreamAlias(value="Visit")
public class Visit
extends AbstractPersistable
implements Standstill {
    private Location location;
    private Standstill previousStandstill;

    @Override
    public Location getLocation() {
        return this.location;
    }

    public void setLocation(Location location) {
        this.location = location;
    }

    @PlanningVariable(valueRangeProviderRefs={"domicileRange", "visitRange"}, graphType=PlanningVariableGraphType.CHAINED, strengthWeightFactoryClass=DomicileDistanceStandstillStrengthWeightFactory.class)
    public Standstill getPreviousStandstill() {
        return this.previousStandstill;
    }

    public void setPreviousStandstill(Standstill previousStandstill) {
        this.previousStandstill = previousStandstill;
    }

    public long getDistanceFromPreviousStandstill() {
        if (this.previousStandstill == null) {
            return 0L;
        }
        return this.getDistanceFrom(this.previousStandstill);
    }

    public long getDistanceFrom(Standstill standstill) {
        return standstill.getLocation().getDistanceTo(this.location);
    }

    @Override
    public long getDistanceTo(Standstill standstill) {
        return this.location.getDistanceTo(standstill.getLocation());
    }

    @Override
    public String toString() {
        if (this.location.getName() == null) {
            return super.toString();
        }
        return this.location.getName();
    }
}

