/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.scrabble.swingui;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import org.optaplanner.examples.common.swingui.SolutionPanel;
import org.optaplanner.examples.common.swingui.timetable.TimeTablePanel;
import org.optaplanner.examples.scrabble.domain.ScrabbleCell;
import org.optaplanner.examples.scrabble.domain.ScrabbleSolution;
import org.optaplanner.swing.impl.SwingUtils;
import org.optaplanner.swing.impl.TangoColorFactory;

public class ScrabblePanel
extends SolutionPanel<ScrabbleSolution> {
    public static final String LOGO_PATH = "/org/optaplanner/examples/scrabble/swingui/scrabbleLogo.png";
    private final TimeTablePanel<Integer, Integer> gridPanel;

    public ScrabblePanel() {
        this.setLayout(new BorderLayout());
        JTabbedPane tabbedPane = new JTabbedPane();
        this.gridPanel = new TimeTablePanel();
        tabbedPane.add("Grid", new JScrollPane(this.gridPanel));
        this.add((Component)tabbedPane, "Center");
        this.setPreferredSize(PREFERRED_SCROLLABLE_VIEWPORT_SIZE);
    }

    @Override
    public boolean isWrapInScrollPane() {
        return false;
    }

    @Override
    public void resetPanel(ScrabbleSolution solution) {
        this.gridPanel.reset();
        this.defineGrid(solution);
        this.fillCells(solution);
        this.repaint();
    }

    private void defineGrid(ScrabbleSolution solution) {
        JButton footprint = SwingUtils.makeSmallButton((JButton)new JButton("99"));
        int footprintWidth = footprint.getPreferredSize().width;
        this.gridPanel.defineColumnHeaderByKey(TimeTablePanel.HeaderColumnKey.HEADER_COLUMN);
        for (int x = 0; x < solution.getGridWidth(); ++x) {
            this.gridPanel.defineColumnHeader(x, footprintWidth);
        }
        this.gridPanel.defineRowHeaderByKey(TimeTablePanel.HeaderRowKey.HEADER_ROW);
        for (int y = 0; y < solution.getGridHeight(); ++y) {
            this.gridPanel.defineRowHeader(y);
        }
        this.gridPanel.defineRowHeader(null);
    }

    private void fillCells(ScrabbleSolution solution) {
        this.fillXCells(solution);
        this.fillYCells(solution);
        this.fillTeamAssignmentCells(solution);
    }

    private void fillXCells(ScrabbleSolution solution) {
        for (int x = 0; x < solution.getGridWidth(); ++x) {
            this.gridPanel.addColumnHeader(x, TimeTablePanel.HeaderRowKey.HEADER_ROW, this.createTableHeader(new JLabel(Integer.toString(x), 0)));
        }
    }

    private void fillYCells(ScrabbleSolution solution) {
        for (int y = 0; y < solution.getGridHeight(); ++y) {
            this.gridPanel.addRowHeader(TimeTablePanel.HeaderColumnKey.HEADER_COLUMN, y, this.createTableHeader(new JLabel(Integer.toString(y))));
        }
        this.gridPanel.addRowHeader(TimeTablePanel.HeaderColumnKey.HEADER_COLUMN, null, this.createTableHeader(new JLabel("Unassigned")));
    }

    private void fillTeamAssignmentCells(ScrabbleSolution solution) {
        for (ScrabbleCell cell : solution.getCellList()) {
            for (Character c : cell.getCharacterSet()) {
                this.gridPanel.addCell(cell.getX(), cell.getY(), new JLabel(c.toString(), 0));
            }
        }
    }

    private JPanel createTableHeader(JLabel label) {
        JPanel headerPanel = new JPanel(new BorderLayout());
        headerPanel.add((Component)label, "North");
        headerPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(TangoColorFactory.ALUMINIUM_5), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
        return headerPanel;
    }
}

