/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.vehiclerouting.app;

import org.optaplanner.examples.common.app.CommonApp;
import org.optaplanner.examples.common.persistence.AbstractSolutionImporter;
import org.optaplanner.examples.vehiclerouting.domain.VehicleRoutingSolution;
import org.optaplanner.examples.vehiclerouting.persistence.VehicleRoutingImporter;
import org.optaplanner.examples.vehiclerouting.swingui.VehicleRoutingPanel;
import org.optaplanner.persistence.common.api.domain.solution.SolutionFileIO;
import org.optaplanner.persistence.xstream.impl.domain.solution.XStreamSolutionFileIO;

public class VehicleRoutingApp
extends CommonApp<VehicleRoutingSolution> {
    public static final String SOLVER_CONFIG = "org/optaplanner/examples/vehiclerouting/solver/vehicleRoutingSolverConfig.xml";
    public static final String DATA_DIR_NAME = "vehiclerouting";

    public static void main(String[] args) {
        VehicleRoutingApp.prepareSwingEnvironment();
        new VehicleRoutingApp().init();
    }

    public VehicleRoutingApp() {
        super("Vehicle routing", "Official competition name: Capacitated vehicle routing problem (CVRP), optionally with time windows (CVRPTW)\n\nPick up all items of all customers with a few vehicles.\n\nFind the shortest route possible.\nDo not overload the capacity of the vehicles.\nArrive within the time window of each customer.", SOLVER_CONFIG, DATA_DIR_NAME, "/org/optaplanner/examples/vehiclerouting/swingui/vehicleRoutingLogo.png");
    }

    protected VehicleRoutingPanel createSolutionPanel() {
        return new VehicleRoutingPanel();
    }

    @Override
    public SolutionFileIO<VehicleRoutingSolution> createSolutionFileIO() {
        return new XStreamSolutionFileIO(new Class[]{VehicleRoutingSolution.class});
    }

    @Override
    protected AbstractSolutionImporter[] createSolutionImporters() {
        return new AbstractSolutionImporter[]{new VehicleRoutingImporter()};
    }
}

