/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.travelingtournament.persistence;

import java.io.IOException;
import org.optaplanner.examples.common.persistence.AbstractTxtSolutionExporter;
import org.optaplanner.examples.travelingtournament.domain.Day;
import org.optaplanner.examples.travelingtournament.domain.Match;
import org.optaplanner.examples.travelingtournament.domain.Team;
import org.optaplanner.examples.travelingtournament.domain.TravelingTournament;
import org.optaplanner.examples.travelingtournament.persistence.TravelingTournamentDao;

public class TravelingTournamentExporter
extends AbstractTxtSolutionExporter<TravelingTournament> {
    private static final String OUTPUT_FILE_SUFFIX = "trick.txt";

    public static void main(String[] args) {
        new TravelingTournamentExporter().convertAll();
    }

    public TravelingTournamentExporter() {
        super(new TravelingTournamentDao());
    }

    @Override
    public String getOutputFileSuffix() {
        return OUTPUT_FILE_SUFFIX;
    }

    @Override
    public AbstractTxtSolutionExporter.TxtOutputBuilder<TravelingTournament> createTxtOutputBuilder() {
        return new TravelingTournamentOutputBuilder();
    }

    public static class TravelingTournamentOutputBuilder
    extends AbstractTxtSolutionExporter.TxtOutputBuilder<TravelingTournament> {
        @Override
        public void writeSolution() throws IOException {
            int maximumTeamNameLength = 0;
            for (Team team : ((TravelingTournament)this.solution).getTeamList()) {
                if (team.getName().length() <= maximumTeamNameLength) continue;
                maximumTeamNameLength = team.getName().length();
            }
            for (Team team : ((TravelingTournament)this.solution).getTeamList()) {
                this.bufferedWriter.write(String.format("%-" + (maximumTeamNameLength + 3) + "s", team.getName()));
            }
            this.bufferedWriter.write("\n");
            for (Team team : ((TravelingTournament)this.solution).getTeamList()) {
                this.bufferedWriter.write(String.format("%-" + (maximumTeamNameLength + 3) + "s", team.getName().replaceAll("[\\w\\d]", "-")));
            }
            this.bufferedWriter.write("\n");
            for (Day day : ((TravelingTournament)this.solution).getDayList()) {
                for (Team team : ((TravelingTournament)this.solution).getTeamList()) {
                    boolean opponentIsHome = false;
                    Team opponentTeam = null;
                    for (Match match : ((TravelingTournament)this.solution).getMatchList()) {
                        if (!match.getDay().equals(day)) continue;
                        if (match.getHomeTeam().equals(team)) {
                            opponentIsHome = false;
                            opponentTeam = match.getAwayTeam();
                            continue;
                        }
                        if (!match.getAwayTeam().equals(team)) continue;
                        opponentIsHome = true;
                        opponentTeam = match.getHomeTeam();
                    }
                    String opponentName = (opponentIsHome ? "@" : "") + opponentTeam.getName();
                    this.bufferedWriter.write(String.format("%-" + (maximumTeamNameLength + 3) + "s", opponentName));
                }
                this.bufferedWriter.write("\n");
            }
        }
    }
}

