/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.nqueens.domain;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import org.optaplanner.core.api.domain.entity.PlanningEntity;
import org.optaplanner.core.api.domain.variable.PlanningVariable;
import org.optaplanner.examples.common.domain.AbstractPersistable;
import org.optaplanner.examples.nqueens.domain.Column;
import org.optaplanner.examples.nqueens.domain.Row;
import org.optaplanner.examples.nqueens.domain.solution.QueenDifficultyWeightFactory;
import org.optaplanner.examples.nqueens.domain.solution.RowStrengthWeightFactory;

@PlanningEntity(difficultyWeightFactoryClass=QueenDifficultyWeightFactory.class)
@XStreamAlias(value="Queen")
public class Queen
extends AbstractPersistable {
    private Column column;
    private Row row;

    public Queen() {
    }

    public Queen(long id, Row row, Column column) {
        super(id);
        this.row = row;
        this.column = column;
    }

    public Column getColumn() {
        return this.column;
    }

    public void setColumn(Column column) {
        this.column = column;
    }

    @PlanningVariable(valueRangeProviderRefs={"rowRange"}, strengthWeightFactoryClass=RowStrengthWeightFactory.class)
    public Row getRow() {
        return this.row;
    }

    public void setRow(Row row) {
        this.row = row;
    }

    public int getColumnIndex() {
        return this.column.getIndex();
    }

    public int getRowIndex() {
        if (this.row == null) {
            return Integer.MIN_VALUE;
        }
        return this.row.getIndex();
    }

    public int getAscendingDiagonalIndex() {
        return this.getColumnIndex() + this.getRowIndex();
    }

    public int getDescendingDiagonalIndex() {
        return this.getColumnIndex() - this.getRowIndex();
    }

    @Override
    public String toString() {
        return "Queen-" + this.column.getIndex();
    }
}

