/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.cloudbalancing.optional.benchmark;

import java.util.Arrays;
import java.util.List;
import org.optaplanner.benchmark.api.PlannerBenchmark;
import org.optaplanner.benchmark.api.PlannerBenchmarkFactory;
import org.optaplanner.benchmark.impl.aggregator.swingui.BenchmarkAggregatorFrame;
import org.optaplanner.examples.cloudbalancing.domain.CloudBalance;
import org.optaplanner.examples.cloudbalancing.persistence.CloudBalancingGenerator;

public class CloudBalancingBenchmarkHelloWorld {
    public static void main(String[] args) {
        List<String> argList = Arrays.asList(args);
        boolean advanced = argList.contains("--advanced");
        if (!advanced) {
            CloudBalancingBenchmarkHelloWorld.runBasicBenchmark();
        } else {
            boolean aggregator = argList.contains("--aggregator");
            CloudBalancingBenchmarkHelloWorld.runAdvancedBenchmark(aggregator);
        }
    }

    public static void runBasicBenchmark() {
        PlannerBenchmarkFactory benchmarkFactory = PlannerBenchmarkFactory.createFromSolverConfigXmlResource((String)"org/optaplanner/examples/cloudbalancing/solver/cloudBalancingSolverConfig.xml");
        CloudBalancingGenerator generator = new CloudBalancingGenerator();
        PlannerBenchmark benchmark = benchmarkFactory.buildPlannerBenchmark((Object[])new CloudBalance[]{generator.createCloudBalance(200, 600), generator.createCloudBalance(400, 1200)});
        benchmark.benchmarkAndShowReportInBrowser();
    }

    public static void runAdvancedBenchmark(boolean aggregator) {
        PlannerBenchmarkFactory benchmarkFactory = PlannerBenchmarkFactory.createFromXmlResource((String)"org/optaplanner/examples/cloudbalancing/optional/benchmark/cloudBalancingBenchmarkConfig.xml");
        PlannerBenchmark benchmark = benchmarkFactory.buildPlannerBenchmark();
        benchmark.benchmarkAndShowReportInBrowser();
        if (aggregator) {
            BenchmarkAggregatorFrame.createAndDisplayFromXmlResource((String)"org/optaplanner/examples/cloudbalancing/optional/benchmark/cloudBalancingBenchmarkConfig.xml");
        }
    }
}

