/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.common.app;

import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.optaplanner.benchmark.api.PlannerBenchmark;
import org.optaplanner.benchmark.api.PlannerBenchmarkFactory;
import org.optaplanner.benchmark.impl.aggregator.swingui.BenchmarkAggregatorFrame;
import org.optaplanner.examples.common.app.LoggingMain;

public abstract class CommonBenchmarkApp
extends LoggingMain {
    public static final String AGGREGATOR_ARG = "--aggregator";
    private final Map<String, ArgOption> benchmarkArgumentMap;

    public CommonBenchmarkApp(ArgOption ... argOptions) {
        this.benchmarkArgumentMap = new LinkedHashMap<String, ArgOption>(argOptions.length);
        for (ArgOption argOption : argOptions) {
            this.benchmarkArgumentMap.put(argOption.getName(), argOption);
        }
    }

    public Collection<ArgOption> getArgOptions() {
        return this.benchmarkArgumentMap.values();
    }

    public void buildAndBenchmark(String[] args) {
        boolean aggregator = false;
        ArgOption argOption = null;
        for (String arg : args) {
            if (arg.equalsIgnoreCase(AGGREGATOR_ARG)) {
                aggregator = true;
                continue;
            }
            if (this.benchmarkArgumentMap.containsKey(arg)) {
                if (argOption != null) {
                    throw new IllegalArgumentException("The args (" + Arrays.toString(args) + ") contains arg name (" + argOption.getName() + ") and arg name (" + arg + ").");
                }
                argOption = this.benchmarkArgumentMap.get(arg);
                continue;
            }
            throw new IllegalArgumentException("The args (" + Arrays.toString(args) + ") contains an arg (" + arg + ") which is not part of the recognized args (" + this.benchmarkArgumentMap.keySet() + " or " + AGGREGATOR_ARG + ").");
        }
        if (argOption == null) {
            argOption = this.benchmarkArgumentMap.values().iterator().next();
        }
        boolean template = argOption.isTemplate();
        String benchmarkConfigResource = argOption.getBenchmarkConfigResource();
        if (!aggregator) {
            PlannerBenchmarkFactory benchmarkFactory = !template ? PlannerBenchmarkFactory.createFromXmlResource((String)benchmarkConfigResource) : PlannerBenchmarkFactory.createFromFreemarkerXmlResource((String)benchmarkConfigResource);
            PlannerBenchmark benchmark = benchmarkFactory.buildPlannerBenchmark();
            benchmark.benchmarkAndShowReportInBrowser();
        } else if (!template) {
            BenchmarkAggregatorFrame.createAndDisplayFromXmlResource((String)benchmarkConfigResource);
        } else {
            BenchmarkAggregatorFrame.createAndDisplayFromFreemarkerXmlResource((String)benchmarkConfigResource);
        }
    }

    public static class ArgOption {
        private String name;
        private String benchmarkConfigResource;
        private boolean template;

        public ArgOption(String name, String benchmarkConfigResource) {
            this(name, benchmarkConfigResource, false);
        }

        public ArgOption(String name, String benchmarkConfigResource, boolean template) {
            this.name = name;
            this.benchmarkConfigResource = benchmarkConfigResource;
            this.template = template;
        }

        public String getName() {
            return this.name;
        }

        public String getBenchmarkConfigResource() {
            return this.benchmarkConfigResource;
        }

        public boolean isTemplate() {
            return this.template;
        }

        public String toString() {
            return this.name + " (" + this.benchmarkConfigResource + ")";
        }
    }
}

