/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.vehiclerouting.domain.solver;

import java.util.Comparator;
import org.optaplanner.core.impl.heuristic.selector.common.decorator.SelectionSorterWeightFactory;
import org.optaplanner.examples.common.domain.AbstractPersistable;
import org.optaplanner.examples.vehiclerouting.domain.Customer;
import org.optaplanner.examples.vehiclerouting.domain.Depot;
import org.optaplanner.examples.vehiclerouting.domain.VehicleRoutingSolution;

public class DepotAngleCustomerDifficultyWeightFactory
implements SelectionSorterWeightFactory<VehicleRoutingSolution, Customer> {
    public DepotAngleCustomerDifficultyWeight createSorterWeight(VehicleRoutingSolution vehicleRoutingSolution, Customer customer) {
        Depot depot = vehicleRoutingSolution.getDepotList().get(0);
        return new DepotAngleCustomerDifficultyWeight(customer, customer.getLocation().getAngle(depot.getLocation()), customer.getLocation().getDistanceTo(depot.getLocation()) + depot.getLocation().getDistanceTo(customer.getLocation()));
    }

    public static class DepotAngleCustomerDifficultyWeight
    implements Comparable<DepotAngleCustomerDifficultyWeight> {
        private static final Comparator<DepotAngleCustomerDifficultyWeight> COMPARATOR = Comparator.comparingDouble(weight -> weight.depotAngle).thenComparingLong(weight -> weight.depotRoundTripDistance).thenComparing(weight -> weight.customer, Comparator.comparingLong(AbstractPersistable::getId));
        private final Customer customer;
        private final double depotAngle;
        private final long depotRoundTripDistance;

        public DepotAngleCustomerDifficultyWeight(Customer customer, double depotAngle, long depotRoundTripDistance) {
            this.customer = customer;
            this.depotAngle = depotAngle;
            this.depotRoundTripDistance = depotRoundTripDistance;
        }

        @Override
        public int compareTo(DepotAngleCustomerDifficultyWeight other) {
            return COMPARATOR.compare(this, other);
        }
    }
}

