/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.common.persistence;

import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.optaplanner.examples.common.persistence.generator.StringDataGenerator;

public class StringDataGeneratorTest {
    @Test
    public void with2Parts() {
        StringDataGenerator generator = new StringDataGenerator();
        generator.addPart(new String[]{"a", "b", "c", "d"});
        generator.addPart(new String[]{"h", "i", "j", "k"});
        Assertions.assertThat((String)generator.generateNextValue()).isEqualTo("a h");
        Assertions.assertThat((String)generator.generateNextValue()).isEqualTo("b i");
        Assertions.assertThat((String)generator.generateNextValue()).isEqualTo("c j");
        Assertions.assertThat((String)generator.generateNextValue()).isEqualTo("d k");
        Assertions.assertThat((String)generator.generateNextValue()).isEqualTo("a i");
        Assertions.assertThat((String)generator.generateNextValue()).isEqualTo("b j");
        Assertions.assertThat((String)generator.generateNextValue()).isEqualTo("c k");
        Assertions.assertThat((String)generator.generateNextValue()).isEqualTo("d h");
        Assertions.assertThat((String)generator.generateNextValue()).isEqualTo("a j");
        Assertions.assertThat((String)generator.generateNextValue()).isEqualTo("b k");
        Assertions.assertThat((String)generator.generateNextValue()).isEqualTo("c h");
        Assertions.assertThat((String)generator.generateNextValue()).isEqualTo("d i");
    }

    @Test
    public void with3Parts() {
        StringDataGenerator generator = new StringDataGenerator();
        generator.addPart(new String[]{"a", "b", "c", "d"});
        generator.addPart(new String[]{"h", "i", "j", "k"});
        generator.addPart(new String[]{"o", "p", "q", "r"});
        Assertions.assertThat((String)generator.generateNextValue()).isEqualTo("a h o");
        Assertions.assertThat((String)generator.generateNextValue()).isEqualTo("b i p");
        Assertions.assertThat((String)generator.generateNextValue()).isEqualTo("c j q");
        Assertions.assertThat((String)generator.generateNextValue()).isEqualTo("d k r");
        Assertions.assertThat((String)generator.generateNextValue()).isEqualTo("a h p");
        Assertions.assertThat((String)generator.generateNextValue()).isEqualTo("b i q");
        Assertions.assertThat((String)generator.generateNextValue()).isEqualTo("c j r");
        Assertions.assertThat((String)generator.generateNextValue()).isEqualTo("d k o");
    }

    @Test
    public void with4Parts() {
        StringDataGenerator generator = new StringDataGenerator();
        generator.addPart(new String[]{"a", "b", "c", "d"});
        generator.addPart(new String[]{"h", "i", "j", "k"});
        generator.addPart(new String[]{"o", "p", "q", "r"});
        generator.addPart(new String[]{"v", "w", "x", "y"});
        Assertions.assertThat((String)generator.generateNextValue()).isEqualTo("a h o v");
        Assertions.assertThat((String)generator.generateNextValue()).isEqualTo("b i p w");
        Assertions.assertThat((String)generator.generateNextValue()).isEqualTo("c j q x");
        Assertions.assertThat((String)generator.generateNextValue()).isEqualTo("d k r y");
        Assertions.assertThat((String)generator.generateNextValue()).isEqualTo("a h p w");
        Assertions.assertThat((String)generator.generateNextValue()).isEqualTo("b i q x");
        Assertions.assertThat((String)generator.generateNextValue()).isEqualTo("c j r y");
        Assertions.assertThat((String)generator.generateNextValue()).isEqualTo("d k o v");
        Assertions.assertThat((String)generator.generateNextValue()).isEqualTo("a h q x");
        Assertions.assertThat((String)generator.generateNextValue()).isEqualTo("b i r y");
        Assertions.assertThat((String)generator.generateNextValue()).isEqualTo("c j o v");
        Assertions.assertThat((String)generator.generateNextValue()).isEqualTo("d k p w");
    }

    @Test
    public void with4PartsMaximumSizeFor2() {
        StringDataGenerator generator = new StringDataGenerator();
        generator.addPart(new String[]{"a", "b", "c", "d"});
        generator.addPart(new String[]{"h", "i", "j", "k"});
        generator.addPart(new String[]{"o", "p", "q", "r"});
        generator.addPart(new String[]{"v", "w", "x", "y"});
        generator.predictMaximumSizeAndReset(9);
        Assertions.assertThat((String)generator.generateNextValue()).isEqualTo("a v");
        Assertions.assertThat((String)generator.generateNextValue()).isEqualTo("b w");
        Assertions.assertThat((String)generator.generateNextValue()).isEqualTo("c x");
        Assertions.assertThat((String)generator.generateNextValue()).isEqualTo("d y");
        Assertions.assertThat((String)generator.generateNextValue()).isEqualTo("a w");
        Assertions.assertThat((String)generator.generateNextValue()).isEqualTo("b x");
        Assertions.assertThat((String)generator.generateNextValue()).isEqualTo("c y");
        Assertions.assertThat((String)generator.generateNextValue()).isEqualTo("d v");
    }

    @Test
    public void with4PartsMaximumSizeFor3() {
        StringDataGenerator generator = new StringDataGenerator();
        generator.addPart(new String[]{"a", "b", "c", "d"});
        generator.addPart(new String[]{"h", "i", "j", "k"});
        generator.addPart(new String[]{"o", "p", "q", "r"});
        generator.addPart(new String[]{"v", "w", "x", "y"});
        generator.predictMaximumSizeAndReset(19);
        Assertions.assertThat((String)generator.generateNextValue()).isEqualTo("a o v");
        Assertions.assertThat((String)generator.generateNextValue()).isEqualTo("b p w");
        Assertions.assertThat((String)generator.generateNextValue()).isEqualTo("c q x");
        Assertions.assertThat((String)generator.generateNextValue()).isEqualTo("d r y");
        Assertions.assertThat((String)generator.generateNextValue()).isEqualTo("a o w");
        Assertions.assertThat((String)generator.generateNextValue()).isEqualTo("b p x");
        Assertions.assertThat((String)generator.generateNextValue()).isEqualTo("c q y");
        Assertions.assertThat((String)generator.generateNextValue()).isEqualTo("d r v");
    }
}

