/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.coachshuttlegathering.solver;

import java.util.LinkedHashMap;
import java.util.List;
import org.optaplanner.core.api.score.buildin.hardsoftlong.HardSoftLongScore;
import org.optaplanner.core.api.score.calculator.EasyScoreCalculator;
import org.optaplanner.examples.coachshuttlegathering.domain.Bus;
import org.optaplanner.examples.coachshuttlegathering.domain.BusStop;
import org.optaplanner.examples.coachshuttlegathering.domain.Coach;
import org.optaplanner.examples.coachshuttlegathering.domain.CoachShuttleGatheringSolution;
import org.optaplanner.examples.coachshuttlegathering.domain.Shuttle;
import org.optaplanner.examples.coachshuttlegathering.domain.StopOrHub;

public class CoachShuttleGatheringEasyScoreCalculator
implements EasyScoreCalculator<CoachShuttleGatheringSolution, HardSoftLongScore> {
    public HardSoftLongScore calculateScore(CoachShuttleGatheringSolution solution) {
        long hardScore = 0L;
        long softScore = 0L;
        List<Bus> busList = solution.getBusList();
        LinkedHashMap<Bus, Integer> busToPassengerTotalMap = new LinkedHashMap<Bus, Integer>(busList.size());
        LinkedHashMap<Coach, Integer> coachToStopCountMap = new LinkedHashMap<Coach, Integer>(busList.size());
        for (BusStop stop : solution.getStopList()) {
            Integer transportTimeRemainder;
            Bus bus = stop.getBus();
            if (bus != null) {
                Bus destinationBus;
                Shuttle shuttle;
                StopOrHub destination;
                Integer passengerTotal = (Integer)busToPassengerTotalMap.get(bus);
                if (passengerTotal == null) {
                    passengerTotal = 0;
                }
                passengerTotal = passengerTotal + stop.getPassengerQuantity();
                busToPassengerTotalMap.put(bus, passengerTotal);
                if (bus instanceof Shuttle && (destination = (shuttle = (Shuttle)bus).getDestination()) instanceof BusStop && (destinationBus = ((BusStop)destination).getBus()) != null && destinationBus instanceof Coach) {
                    Integer destinationPassengerTotal = (Integer)busToPassengerTotalMap.get(destinationBus);
                    if (destinationPassengerTotal == null) {
                        destinationPassengerTotal = 0;
                    }
                    destinationPassengerTotal = destinationPassengerTotal + stop.getPassengerQuantity();
                    busToPassengerTotalMap.put(destinationBus, destinationPassengerTotal);
                }
                if (bus instanceof Coach) {
                    Coach coach = (Coach)bus;
                    Integer stopCount = (Integer)coachToStopCountMap.get(coach);
                    stopCount = stopCount == null ? 1 : stopCount + 1;
                    coachToStopCountMap.put(coach, stopCount);
                }
            }
            if ((transportTimeRemainder = stop.getTransportTimeRemainder()) != null && transportTimeRemainder < 0) {
                hardScore += (long)transportTimeRemainder.intValue();
            }
            if (stop.getPreviousBusOrStop() != null) {
                softScore -= (long)stop.getDistanceFromPreviousCost();
            }
            if (stop.getNextStop() != null || bus == null || bus.getDestination() == null) continue;
            softScore -= (long)stop.getDistanceToDestinationCost(bus.getDestination());
        }
        for (Bus bus : busList) {
            Bus destinationBus;
            Integer passengerTotal = (Integer)busToPassengerTotalMap.get(bus);
            if (passengerTotal != null && passengerTotal > bus.getCapacity()) {
                hardScore += (long)(bus.getCapacity() - passengerTotal) * 1000L;
            }
            if (bus instanceof Coach) {
                Coach coach = (Coach)bus;
                Integer stopCount = (Integer)coachToStopCountMap.get(coach);
                if (stopCount != null && stopCount > coach.getStopLimit()) {
                    hardScore += (long)(coach.getStopLimit() - stopCount) * 1000000L;
                }
                if (coach.getNextStop() == null) {
                    softScore -= (long)coach.getDistanceToDestinationCost();
                }
            }
            if (!(bus instanceof Shuttle)) continue;
            Shuttle shuttle = (Shuttle)bus;
            StopOrHub destination = shuttle.getDestination();
            if (destination instanceof BusStop && (destinationBus = ((BusStop)destination).getBus()) instanceof Shuttle) {
                hardScore -= 1000000000L;
            }
            if (shuttle.getNextStop() == null) continue;
            softScore -= (long)shuttle.getSetupCost();
        }
        return HardSoftLongScore.of((long)hardScore, (long)softScore);
    }
}

