/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.curriculumcourse.swingui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import org.optaplanner.examples.common.swingui.CommonIcons;
import org.optaplanner.examples.common.swingui.SolutionPanel;
import org.optaplanner.examples.common.swingui.components.LabeledComboBoxRenderer;
import org.optaplanner.examples.common.swingui.timetable.TimeTablePanel;
import org.optaplanner.examples.curriculumcourse.domain.CourseSchedule;
import org.optaplanner.examples.curriculumcourse.domain.Curriculum;
import org.optaplanner.examples.curriculumcourse.domain.Day;
import org.optaplanner.examples.curriculumcourse.domain.Lecture;
import org.optaplanner.examples.curriculumcourse.domain.Period;
import org.optaplanner.examples.curriculumcourse.domain.Room;
import org.optaplanner.examples.curriculumcourse.domain.Teacher;
import org.optaplanner.swing.impl.SwingUtils;
import org.optaplanner.swing.impl.TangoColorFactory;

public class CurriculumCoursePanel
extends SolutionPanel<CourseSchedule> {
    public static final String LOGO_PATH = "/org/optaplanner/examples/curriculumcourse/swingui/curriculumCourseLogo.png";
    private final TimeTablePanel<Room, Period> roomsPanel;
    private final TimeTablePanel<Teacher, Period> teachersPanel;
    private final TimeTablePanel<Curriculum, Period> curriculaPanel;

    public CurriculumCoursePanel() {
        this.setLayout(new BorderLayout());
        JTabbedPane tabbedPane = new JTabbedPane();
        this.roomsPanel = new TimeTablePanel();
        tabbedPane.add("Rooms", new JScrollPane(this.roomsPanel));
        this.teachersPanel = new TimeTablePanel();
        tabbedPane.add("Teachers", new JScrollPane(this.teachersPanel));
        this.curriculaPanel = new TimeTablePanel();
        tabbedPane.add("Curricula", new JScrollPane(this.curriculaPanel));
        this.add((Component)tabbedPane, "Center");
        this.setPreferredSize(PREFERRED_SCROLLABLE_VIEWPORT_SIZE);
    }

    @Override
    public boolean isWrapInScrollPane() {
        return false;
    }

    @Override
    public void resetPanel(CourseSchedule courseSchedule) {
        this.roomsPanel.reset();
        this.teachersPanel.reset();
        this.curriculaPanel.reset();
        this.defineGrid(courseSchedule);
        this.fillCells(courseSchedule);
        this.repaint();
    }

    private void defineGrid(CourseSchedule courseSchedule) {
        JButton footprint = SwingUtils.makeSmallButton((JButton)new JButton("LinLetGre1-0"));
        int footprintWidth = footprint.getPreferredSize().width;
        this.roomsPanel.defineColumnHeaderByKey(TimeTablePanel.HeaderColumnKey.HEADER_COLUMN_GROUP1);
        this.roomsPanel.defineColumnHeaderByKey(TimeTablePanel.HeaderColumnKey.HEADER_COLUMN);
        for (Room room : courseSchedule.getRoomList()) {
            this.roomsPanel.defineColumnHeader(room, footprintWidth);
        }
        this.roomsPanel.defineColumnHeader(null, footprintWidth);
        this.teachersPanel.defineColumnHeaderByKey(TimeTablePanel.HeaderColumnKey.HEADER_COLUMN_GROUP1);
        this.teachersPanel.defineColumnHeaderByKey(TimeTablePanel.HeaderColumnKey.HEADER_COLUMN);
        for (Teacher teacher : courseSchedule.getTeacherList()) {
            this.teachersPanel.defineColumnHeader(teacher, footprintWidth);
        }
        this.curriculaPanel.defineColumnHeaderByKey(TimeTablePanel.HeaderColumnKey.HEADER_COLUMN_GROUP1);
        this.curriculaPanel.defineColumnHeaderByKey(TimeTablePanel.HeaderColumnKey.HEADER_COLUMN);
        for (Curriculum curriculum : courseSchedule.getCurriculumList()) {
            this.curriculaPanel.defineColumnHeader(curriculum, footprintWidth);
        }
        this.roomsPanel.defineRowHeaderByKey(TimeTablePanel.HeaderRowKey.HEADER_ROW);
        this.teachersPanel.defineRowHeaderByKey(TimeTablePanel.HeaderRowKey.HEADER_ROW);
        this.curriculaPanel.defineRowHeaderByKey(TimeTablePanel.HeaderRowKey.HEADER_ROW);
        for (Period period : courseSchedule.getPeriodList()) {
            this.roomsPanel.defineRowHeader(period);
            this.teachersPanel.defineRowHeader(period);
            this.curriculaPanel.defineRowHeader(period);
        }
        this.roomsPanel.defineRowHeader(null);
        this.teachersPanel.defineRowHeader(null);
        this.curriculaPanel.defineRowHeader(null);
    }

    private void fillCells(CourseSchedule courseSchedule) {
        this.roomsPanel.addCornerHeader(TimeTablePanel.HeaderColumnKey.HEADER_COLUMN_GROUP1, TimeTablePanel.HeaderRowKey.HEADER_ROW, this.createTableHeader(new JLabel("Day")));
        this.roomsPanel.addCornerHeader(TimeTablePanel.HeaderColumnKey.HEADER_COLUMN, TimeTablePanel.HeaderRowKey.HEADER_ROW, this.createTableHeader(new JLabel("Time")));
        this.fillRoomCells(courseSchedule);
        this.teachersPanel.addCornerHeader(TimeTablePanel.HeaderColumnKey.HEADER_COLUMN_GROUP1, TimeTablePanel.HeaderRowKey.HEADER_ROW, this.createTableHeader(new JLabel("Day")));
        this.teachersPanel.addCornerHeader(TimeTablePanel.HeaderColumnKey.HEADER_COLUMN, TimeTablePanel.HeaderRowKey.HEADER_ROW, this.createTableHeader(new JLabel("Time")));
        this.fillTeacherCells(courseSchedule);
        this.curriculaPanel.addCornerHeader(TimeTablePanel.HeaderColumnKey.HEADER_COLUMN_GROUP1, TimeTablePanel.HeaderRowKey.HEADER_ROW, this.createTableHeader(new JLabel("Day")));
        this.curriculaPanel.addCornerHeader(TimeTablePanel.HeaderColumnKey.HEADER_COLUMN, TimeTablePanel.HeaderRowKey.HEADER_ROW, this.createTableHeader(new JLabel("Time")));
        this.fillCurriculumCells(courseSchedule);
        this.fillDayCells(courseSchedule);
        this.fillLectureCells(courseSchedule);
    }

    private void fillRoomCells(CourseSchedule courseSchedule) {
        for (Room room : courseSchedule.getRoomList()) {
            this.roomsPanel.addColumnHeader(room, TimeTablePanel.HeaderRowKey.HEADER_ROW, this.createTableHeader(new JLabel(room.getLabel(), 0)));
        }
        this.roomsPanel.addColumnHeader(null, TimeTablePanel.HeaderRowKey.HEADER_ROW, this.createTableHeader(new JLabel("Unassigned", 0)));
    }

    private void fillTeacherCells(CourseSchedule courseSchedule) {
        for (Teacher teacher : courseSchedule.getTeacherList()) {
            this.teachersPanel.addColumnHeader(teacher, TimeTablePanel.HeaderRowKey.HEADER_ROW, this.createTableHeader(new JLabel(teacher.getLabel(), 0)));
        }
    }

    private void fillCurriculumCells(CourseSchedule courseSchedule) {
        for (Curriculum curriculum : courseSchedule.getCurriculumList()) {
            this.curriculaPanel.addColumnHeader(curriculum, TimeTablePanel.HeaderRowKey.HEADER_ROW, this.createTableHeader(new JLabel(curriculum.getLabel(), 0)));
        }
    }

    private void fillDayCells(CourseSchedule courseSchedule) {
        for (Day day : courseSchedule.getDayList()) {
            Period dayStartPeriod = day.getPeriodList().get(0);
            Period dayEndPeriod = day.getPeriodList().get(day.getPeriodList().size() - 1);
            this.roomsPanel.addRowHeader(TimeTablePanel.HeaderColumnKey.HEADER_COLUMN_GROUP1, dayStartPeriod, TimeTablePanel.HeaderColumnKey.HEADER_COLUMN_GROUP1, dayEndPeriod, this.createTableHeader(new JLabel(day.getLabel())));
            this.teachersPanel.addRowHeader(TimeTablePanel.HeaderColumnKey.HEADER_COLUMN_GROUP1, dayStartPeriod, TimeTablePanel.HeaderColumnKey.HEADER_COLUMN_GROUP1, dayEndPeriod, this.createTableHeader(new JLabel(day.getLabel())));
            this.curriculaPanel.addRowHeader(TimeTablePanel.HeaderColumnKey.HEADER_COLUMN_GROUP1, dayStartPeriod, TimeTablePanel.HeaderColumnKey.HEADER_COLUMN_GROUP1, dayEndPeriod, this.createTableHeader(new JLabel(day.getLabel())));
            for (Period period : day.getPeriodList()) {
                this.roomsPanel.addRowHeader(TimeTablePanel.HeaderColumnKey.HEADER_COLUMN, period, this.createTableHeader(new JLabel(period.getTimeslot().getLabel())));
                this.teachersPanel.addRowHeader(TimeTablePanel.HeaderColumnKey.HEADER_COLUMN, period, this.createTableHeader(new JLabel(period.getTimeslot().getLabel())));
                this.curriculaPanel.addRowHeader(TimeTablePanel.HeaderColumnKey.HEADER_COLUMN, period, this.createTableHeader(new JLabel(period.getTimeslot().getLabel())));
            }
        }
        this.roomsPanel.addRowHeader(TimeTablePanel.HeaderColumnKey.HEADER_COLUMN_GROUP1, null, TimeTablePanel.HeaderColumnKey.HEADER_COLUMN, null, this.createTableHeader(new JLabel("Unassigned")));
        this.teachersPanel.addRowHeader(TimeTablePanel.HeaderColumnKey.HEADER_COLUMN_GROUP1, null, TimeTablePanel.HeaderColumnKey.HEADER_COLUMN, null, this.createTableHeader(new JLabel("Unassigned")));
        this.curriculaPanel.addRowHeader(TimeTablePanel.HeaderColumnKey.HEADER_COLUMN_GROUP1, null, TimeTablePanel.HeaderColumnKey.HEADER_COLUMN, null, this.createTableHeader(new JLabel("Unassigned")));
    }

    private void fillLectureCells(CourseSchedule courseSchedule) {
        this.preparePlanningEntityColors(courseSchedule.getLectureList());
        for (Lecture lecture : courseSchedule.getLectureList()) {
            Color color = this.determinePlanningEntityColor(lecture, lecture.getCourse());
            String toolTip = this.determinePlanningEntityTooltip(lecture);
            this.roomsPanel.addCell(lecture.getRoom(), lecture.getPeriod(), this.createButton(lecture, color, toolTip));
            this.teachersPanel.addCell(lecture.getTeacher(), lecture.getPeriod(), this.createButton(lecture, color, toolTip));
            for (Curriculum curriculum : lecture.getCurriculumList()) {
                this.curriculaPanel.addCell(curriculum, lecture.getPeriod(), this.createButton(lecture, color, toolTip));
            }
        }
    }

    private JPanel createTableHeader(JLabel label) {
        JPanel headerPanel = new JPanel(new BorderLayout());
        headerPanel.add((Component)label, "North");
        headerPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(TangoColorFactory.ALUMINIUM_5), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
        return headerPanel;
    }

    private JButton createButton(Lecture lecture, Color color, String toolTip) {
        JButton button = SwingUtils.makeSmallButton((JButton)new JButton(new LectureAction(lecture)));
        button.setBackground(color);
        if (lecture.isPinned()) {
            button.setIcon(CommonIcons.PINNED_ICON);
        }
        button.setToolTipText(toolTip);
        return button;
    }

    @Override
    public boolean isIndictmentHeatMapEnabled() {
        return true;
    }

    private class LectureAction
    extends AbstractAction {
        private Lecture lecture;

        public LectureAction(Lecture lecture) {
            super(lecture.getLabel());
            this.lecture = lecture;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JPanel listFieldsPanel = new JPanel(new GridLayout(3, 2));
            listFieldsPanel.add(new JLabel("Period:"));
            CourseSchedule courseSchedule = (CourseSchedule)CurriculumCoursePanel.this.getSolution();
            List<Period> periodList = courseSchedule.getPeriodList();
            JComboBox<Object> periodListField = new JComboBox<Object>(periodList.toArray(new Object[periodList.size() + 1]));
            LabeledComboBoxRenderer.applyToComboBox(periodListField);
            periodListField.setSelectedItem(this.lecture.getPeriod());
            listFieldsPanel.add(periodListField);
            listFieldsPanel.add(new JLabel("Room:"));
            List<Room> roomList = courseSchedule.getRoomList();
            JComboBox<Object> roomListField = new JComboBox<Object>(roomList.toArray(new Object[roomList.size() + 1]));
            LabeledComboBoxRenderer.applyToComboBox(roomListField);
            roomListField.setSelectedItem(this.lecture.getRoom());
            listFieldsPanel.add(roomListField);
            listFieldsPanel.add(new JLabel("Pinned:"));
            JCheckBox pinnedField = new JCheckBox("can not move during solving");
            pinnedField.setSelected(this.lecture.isPinned());
            listFieldsPanel.add(pinnedField);
            int result = JOptionPane.showConfirmDialog(CurriculumCoursePanel.this.getRootPane(), listFieldsPanel, "Select period and room", 2);
            if (result == 0) {
                Period toPeriod = (Period)periodListField.getSelectedItem();
                if (this.lecture.getPeriod() != toPeriod) {
                    CurriculumCoursePanel.this.solutionBusiness.doChangeMove(this.lecture, "period", toPeriod);
                }
                Room toRoom = (Room)roomListField.getSelectedItem();
                if (this.lecture.getRoom() != toRoom) {
                    CurriculumCoursePanel.this.solutionBusiness.doChangeMove(this.lecture, "room", toRoom);
                }
                boolean toPinned = pinnedField.isSelected();
                if (this.lecture.isPinned() != toPinned) {
                    if (CurriculumCoursePanel.this.solutionBusiness.isSolving()) {
                        CurriculumCoursePanel.this.logger.error("Not doing user change because the solver is solving.");
                        return;
                    }
                    this.lecture.setPinned(toPinned);
                }
                CurriculumCoursePanel.this.solverAndPersistenceFrame.resetScreen();
            }
        }
    }
}

