/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.tsp.optional.score;

import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.buildin.simplelong.SimpleLongScore;
import org.optaplanner.core.api.score.stream.Constraint;
import org.optaplanner.core.api.score.stream.ConstraintFactory;
import org.optaplanner.core.api.score.stream.ConstraintProvider;
import org.optaplanner.core.api.score.stream.Joiners;
import org.optaplanner.examples.tsp.domain.Domicile;
import org.optaplanner.examples.tsp.domain.Visit;

public final class TspConstraintProvider
implements ConstraintProvider {
    public Constraint[] defineConstraints(ConstraintFactory constraintFactory) {
        return new Constraint[]{this.distanceToPreviousStandstill(constraintFactory), this.distanceFromLastVisitToDomicile(constraintFactory)};
    }

    private Constraint distanceToPreviousStandstill(ConstraintFactory constraintFactory) {
        return constraintFactory.from(Visit.class).penalizeLong("Distance to previous standstill", (Score)SimpleLongScore.ONE, Visit::getDistanceFromPreviousStandstill);
    }

    private Constraint distanceFromLastVisitToDomicile(ConstraintFactory constraintFactory) {
        return constraintFactory.from(Visit.class).ifNotExists(Visit.class, Joiners.equal(visit -> visit, Visit::getPreviousStandstill)).join(Domicile.class).penalizeLong("Distance from last visit to domicile", (Score)SimpleLongScore.ONE, Visit::getDistanceTo);
    }
}

