/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.common.app;

import java.io.File;
import java.util.Collection;
import org.junit.Assert;
import org.junit.Before;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.constraint.ConstraintMatchTotal;
import org.optaplanner.core.api.solver.Solver;
import org.optaplanner.core.api.solver.SolverFactory;
import org.optaplanner.core.config.solver.EnvironmentMode;
import org.optaplanner.core.config.solver.termination.TerminationConfig;
import org.optaplanner.core.impl.score.definition.ScoreDefinition;
import org.optaplanner.core.impl.score.director.InnerScoreDirector;
import org.optaplanner.core.impl.score.director.InnerScoreDirectorFactory;
import org.optaplanner.examples.common.app.CommonApp;
import org.optaplanner.examples.common.app.LoggingTest;
import org.optaplanner.persistence.common.api.domain.solution.SolutionFileIO;

public abstract class SolverPerformanceTest<Solution_>
extends LoggingTest {
    protected SolutionFileIO<Solution_> solutionFileIO;
    protected String solverConfig;

    @Before
    public void setUp() {
        CommonApp<Solution_> commonApp = this.createCommonApp();
        this.solutionFileIO = commonApp.createSolutionFileIO();
        this.solverConfig = commonApp.getSolverConfig();
    }

    protected abstract CommonApp<Solution_> createCommonApp();

    protected void runSpeedTest(File unsolvedDataFile, String bestScoreLimitString) {
        this.runSpeedTest(unsolvedDataFile, bestScoreLimitString, EnvironmentMode.REPRODUCIBLE);
    }

    protected void runSpeedTest(File unsolvedDataFile, String bestScoreLimitString, EnvironmentMode environmentMode) {
        SolverFactory<Solution_> solverFactory = this.buildSolverFactory(bestScoreLimitString, environmentMode);
        Object problem = this.solutionFileIO.read(unsolvedDataFile);
        this.logger.info("Opened: {}", (Object)unsolvedDataFile);
        Solver solver = solverFactory.buildSolver();
        Object bestSolution = solver.solve(problem);
        this.assertScoreAndConstraintMatches(solver, bestSolution, bestScoreLimitString);
    }

    protected SolverFactory<Solution_> buildSolverFactory(String bestScoreLimitString, EnvironmentMode environmentMode) {
        SolverFactory solverFactory = SolverFactory.createFromXmlResource((String)this.solverConfig);
        solverFactory.getSolverConfig().setEnvironmentMode(environmentMode);
        solverFactory.getSolverConfig().setTerminationConfig(new TerminationConfig().withBestScoreLimit(bestScoreLimitString));
        return solverFactory;
    }

    private void assertScoreAndConstraintMatches(Solver<Solution_> solver, Solution_ bestSolution, String bestScoreLimitString) {
        Assert.assertNotNull(bestSolution);
        InnerScoreDirectorFactory scoreDirectorFactory = (InnerScoreDirectorFactory)solver.getScoreDirectorFactory();
        Score bestScore = scoreDirectorFactory.getSolutionDescriptor().getScore(bestSolution);
        ScoreDefinition scoreDefinition = scoreDirectorFactory.getScoreDefinition();
        Score bestScoreLimit = scoreDefinition.parseScore(bestScoreLimitString);
        Assert.assertTrue((String)("The bestScore (" + bestScore + ") must be at least the bestScoreLimit (" + bestScoreLimit + ")."), (bestScore.compareTo((Object)bestScoreLimit) >= 0 ? 1 : 0) != 0);
        try (InnerScoreDirector scoreDirector = scoreDirectorFactory.buildScoreDirector();){
            scoreDirector.setWorkingSolution(bestSolution);
            Score score = scoreDirector.calculateScore();
            Assert.assertEquals((Object)score, (Object)bestScore);
            if (scoreDirector.isConstraintMatchEnabled()) {
                Collection constraintMatchTotals = scoreDirector.getConstraintMatchTotals();
                Assert.assertNotNull((Object)constraintMatchTotals);
                Assert.assertEquals((Object)score, (Object)constraintMatchTotals.stream().map(ConstraintMatchTotal::getScore).reduce(Score::add).orElse(scoreDefinition.getZeroScore()));
                Assert.assertNotNull((Object)scoreDirector.getIndictmentMap());
            }
        }
    }
}

