/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.common.persistence;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.io.FileUtils;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.optaplanner.examples.common.app.CommonApp;
import org.optaplanner.examples.common.app.LoggingTest;
import org.optaplanner.examples.common.business.ProblemFileComparator;
import org.optaplanner.persistence.common.api.domain.solution.SolutionFileIO;

@RunWith(value=Parameterized.class)
public abstract class OpenDataFilesTest<Solution_>
extends LoggingTest {
    protected final CommonApp<Solution_> commonApp;
    protected final File solutionFile;
    protected SolutionFileIO<Solution_> solutionFileIO;

    protected static <Solution_> Collection<Object[]> getSolutionFilesAsParameters(CommonApp<Solution_> commonApp) {
        ArrayList fileList = new ArrayList(0);
        File dataDir = CommonApp.determineDataDir((String)commonApp.getDataDirName());
        File unsolvedDataDir = new File(dataDir, "unsolved");
        if (!unsolvedDataDir.exists()) {
            throw new IllegalStateException("The directory unsolvedDataDir (" + unsolvedDataDir.getAbsolutePath() + ") does not exist.");
        }
        String inputFileExtension = commonApp.createSolutionFileIO().getInputFileExtension();
        fileList.addAll(FileUtils.listFiles((File)unsolvedDataDir, (String[])new String[]{inputFileExtension}, (boolean)true));
        File solvedDataDir = new File(dataDir, "solved");
        if (solvedDataDir.exists()) {
            String outputFileExtension = commonApp.createSolutionFileIO().getOutputFileExtension();
            fileList.addAll(FileUtils.listFiles((File)solvedDataDir, (String[])new String[]{outputFileExtension}, (boolean)true));
        }
        fileList.sort(new ProblemFileComparator());
        ArrayList<Object[]> filesAsParameters = new ArrayList<Object[]>();
        for (File file : fileList) {
            filesAsParameters.add(new Object[]{file});
        }
        return filesAsParameters;
    }

    protected OpenDataFilesTest(CommonApp<Solution_> commonApp, File solutionFile) {
        this.commonApp = commonApp;
        this.solutionFile = solutionFile;
    }

    @Before
    public void setUp() {
        this.solutionFileIO = this.commonApp.createSolutionFileIO();
    }

    @Test
    public void readSolution() {
        this.solutionFileIO.read(this.solutionFile);
        this.logger.info("Opened: {}", (Object)this.solutionFile);
    }
}

