/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.cheaptime.optional.score;

import org.junit.jupiter.api.Test;
import org.optaplanner.core.api.score.stream.ConstraintProvider;
import org.optaplanner.examples.cheaptime.domain.CheapTimeSolution;
import org.optaplanner.examples.cheaptime.domain.Machine;
import org.optaplanner.examples.cheaptime.domain.MachineCapacity;
import org.optaplanner.examples.cheaptime.domain.Period;
import org.optaplanner.examples.cheaptime.domain.Resource;
import org.optaplanner.examples.cheaptime.domain.Task;
import org.optaplanner.examples.cheaptime.domain.TaskAssignment;
import org.optaplanner.examples.cheaptime.domain.TaskRequirement;
import org.optaplanner.examples.cheaptime.optional.score.CheapTimeConstraintProvider;
import org.optaplanner.test.api.score.stream.ConstraintVerifier;

class CheapTimeConstraintProviderTest {
    private static final Period PERIOD_0 = new Period(0, 100000L);
    private static final Period PERIOD_1 = new Period(1, 150000L);
    private static final Period PERIOD_2 = new Period(2, 250000L);
    private static final Period PERIOD_3 = new Period(3, 500000L);
    private static final Resource RESOURCE_0 = new Resource(0);
    private static final Resource RESOURCE_1 = new Resource(1);
    private static final Resource RESOURCE_2 = new Resource(2);
    private static final MachineCapacity CAPACITY_MACHINE0_RESOURCE0 = new MachineCapacity(0L, RESOURCE_0, 1);
    private static final MachineCapacity CAPACITY_MACHINE0_RESOURCE1 = new MachineCapacity(1L, RESOURCE_1, 2);
    private static final MachineCapacity CAPACITY_MACHINE0_RESOURCE2 = new MachineCapacity(2L, RESOURCE_2, 3);
    private static final MachineCapacity CAPACITY_MACHINE1_RESOURCE0 = new MachineCapacity(3L, RESOURCE_0, 0);
    private static final MachineCapacity CAPACITY_MACHINE1_RESOURCE1 = new MachineCapacity(4L, RESOURCE_1, 1);
    private static final MachineCapacity CAPACITY_MACHINE1_RESOURCE2 = new MachineCapacity(5L, RESOURCE_2, 2);
    private static final Machine MACHINE_O = new Machine(0, 1000000L, 5L, new MachineCapacity[]{CAPACITY_MACHINE0_RESOURCE0, CAPACITY_MACHINE0_RESOURCE1, CAPACITY_MACHINE0_RESOURCE2});
    private static final Machine MACHINE_1 = new Machine(1, 2000000L, 10L, new MachineCapacity[]{CAPACITY_MACHINE1_RESOURCE0, CAPACITY_MACHINE1_RESOURCE1, CAPACITY_MACHINE1_RESOURCE2});
    private static final TaskRequirement REQUIREMENT_TASK0_RESOURCE0 = new TaskRequirement(0L, RESOURCE_0, 1);
    private static final TaskRequirement REQUIREMENT_TASK0_RESOURCE1 = new TaskRequirement(1L, RESOURCE_1, 2);
    private static final TaskRequirement REQUIREMENT_TASK0_RESOURCE2 = new TaskRequirement(2L, RESOURCE_2, 0);
    private static final TaskRequirement REQUIREMENT_TASK1_RESOURCE0 = new TaskRequirement(3L, RESOURCE_0, 0);
    private static final TaskRequirement REQUIREMENT_TASK1_RESOURCE1 = new TaskRequirement(4L, RESOURCE_1, 1);
    private static final TaskRequirement REQUIREMENT_TASK1_RESOURCE2 = new TaskRequirement(5L, RESOURCE_2, 2);
    private static final TaskRequirement REQUIREMENT_TASK2_RESOURCE0 = new TaskRequirement(6L, RESOURCE_0, 1);
    private static final TaskRequirement REQUIREMENT_TASK2_RESOURCE1 = new TaskRequirement(7L, RESOURCE_1, 0);
    private static final TaskRequirement REQUIREMENT_TASK2_RESOURCE2 = new TaskRequirement(8L, RESOURCE_2, 2);
    private static final Task TASK_0 = new Task(0L, PERIOD_0, PERIOD_1, 2, 1000000L, new TaskRequirement[]{REQUIREMENT_TASK0_RESOURCE0, REQUIREMENT_TASK0_RESOURCE1, REQUIREMENT_TASK0_RESOURCE2});
    private static final Task TASK_1 = new Task(1L, PERIOD_1, PERIOD_2, 1, 2000000L, new TaskRequirement[]{REQUIREMENT_TASK1_RESOURCE0, REQUIREMENT_TASK1_RESOURCE1, REQUIREMENT_TASK1_RESOURCE2});
    private static final Task TASK_2 = new Task(2L, PERIOD_1, PERIOD_3, 1, 3000000L, new TaskRequirement[]{REQUIREMENT_TASK2_RESOURCE0, REQUIREMENT_TASK2_RESOURCE1, REQUIREMENT_TASK2_RESOURCE2});
    private final ConstraintVerifier<CheapTimeConstraintProvider, CheapTimeSolution> constraintVerifier = ConstraintVerifier.build((ConstraintProvider)new CheapTimeConstraintProvider(), CheapTimeSolution.class, (Class[])new Class[]{TaskAssignment.class});

    CheapTimeConstraintProviderTest() {
    }

    @Test
    void startTimeLimitsFrom() {
        TaskAssignment correctTaskAssignment1 = new TaskAssignment(TASK_0, MACHINE_O, PERIOD_0);
        TaskAssignment correctTaskAssignment2 = new TaskAssignment(TASK_1, MACHINE_O, PERIOD_2);
        TaskAssignment wrongTaskAssignment = new TaskAssignment(TASK_2, MACHINE_O, PERIOD_0);
        this.constraintVerifier.verifyThat(CheapTimeConstraintProvider::startTimeLimitsFrom).given(new Object[]{correctTaskAssignment1, correctTaskAssignment2, wrongTaskAssignment}).penalizesBy(1);
    }

    @Test
    void startTimeLimitsTo() {
        TaskAssignment correctTaskAssignment1 = new TaskAssignment(TASK_2, MACHINE_O, PERIOD_3);
        TaskAssignment correctTaskAssignment2 = new TaskAssignment(TASK_1, MACHINE_O, PERIOD_1);
        TaskAssignment wrongTaskAssignment = new TaskAssignment(TASK_0, MACHINE_O, PERIOD_2);
        this.constraintVerifier.verifyThat(CheapTimeConstraintProvider::startTimeLimitsTo).given(new Object[]{correctTaskAssignment1, correctTaskAssignment2, wrongTaskAssignment}).penalizesBy(1);
    }

    @Test
    void maximumCapacity() {
        TaskAssignment taskAssignment1 = new TaskAssignment(TASK_0, MACHINE_O, PERIOD_0);
        TaskAssignment taskAssignment2 = new TaskAssignment(TASK_1, MACHINE_O, PERIOD_1);
        TaskAssignment taskAssignment3 = new TaskAssignment(TASK_2, MACHINE_1, PERIOD_1);
        this.constraintVerifier.verifyThat(CheapTimeConstraintProvider::maximumCapacity).given(new Object[]{taskAssignment1, taskAssignment2, taskAssignment3, RESOURCE_0, RESOURCE_1, RESOURCE_2, PERIOD_0, PERIOD_1, PERIOD_2, PERIOD_3}).penalizesBy(2);
    }

    @Test
    void activeMachinePowerCost() {
        TaskAssignment taskAssignment = new TaskAssignment(TASK_0, MACHINE_O, PERIOD_0);
        this.constraintVerifier.verifyThat(CheapTimeConstraintProvider::activeMachinePowerCost).given(new Object[]{taskAssignment, MACHINE_O, MACHINE_1, PERIOD_0, PERIOD_1, PERIOD_2, PERIOD_3}).penalizesBy(3);
    }

    @Test
    void activeMachineSpinUpAndDownCost() {
        TaskAssignment taskAssignment = new TaskAssignment(TASK_0, MACHINE_O, PERIOD_0);
        this.constraintVerifier.verifyThat(CheapTimeConstraintProvider::activeMachineSpinUpAndDownCost).given(new Object[]{taskAssignment, MACHINE_O, MACHINE_1, PERIOD_0, PERIOD_1, PERIOD_2, PERIOD_3}).penalizesBy(5);
    }

    @Test
    void idleCosts() {
        TaskAssignment taskAssignment1 = new TaskAssignment(TASK_0, MACHINE_O, PERIOD_0);
        TaskAssignment taskAssignment2 = new TaskAssignment(TASK_2, MACHINE_O, PERIOD_3);
        this.constraintVerifier.verifyThat(CheapTimeConstraintProvider::idleCosts).given(new Object[]{taskAssignment1, taskAssignment2, PERIOD_0, PERIOD_1, PERIOD_2, PERIOD_3}).penalizesBy(3);
    }

    @Test
    void taskPowerCost() {
        TaskAssignment taskAssignment1 = new TaskAssignment(TASK_0, MACHINE_O, PERIOD_0);
        TaskAssignment taskAssignment2 = new TaskAssignment(TASK_1, MACHINE_1, PERIOD_1);
        this.constraintVerifier.verifyThat(CheapTimeConstraintProvider::taskPowerCost).given(new Object[]{taskAssignment1, taskAssignment2, PERIOD_0, PERIOD_1, PERIOD_2, PERIOD_3}).penalizesBy(6);
    }

    @Test
    void startEarly() {
        TaskAssignment taskAssignment1 = new TaskAssignment(TASK_0, MACHINE_O, PERIOD_1);
        TaskAssignment taskAssignment2 = new TaskAssignment(TASK_1, MACHINE_1, PERIOD_2);
        this.constraintVerifier.verifyThat(CheapTimeConstraintProvider::startEarly).given(new Object[]{taskAssignment1, taskAssignment2}).penalizesBy(taskAssignment1.getStartPeriod() + taskAssignment2.getStartPeriod());
    }
}

