/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.nurserostering.score;

import java.time.DayOfWeek;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.optaplanner.core.api.score.stream.ConstraintProvider;
import org.optaplanner.examples.nurserostering.domain.Employee;
import org.optaplanner.examples.nurserostering.domain.NurseRoster;
import org.optaplanner.examples.nurserostering.domain.NurseRosterParametrization;
import org.optaplanner.examples.nurserostering.domain.Shift;
import org.optaplanner.examples.nurserostering.domain.ShiftAssignment;
import org.optaplanner.examples.nurserostering.domain.ShiftDate;
import org.optaplanner.examples.nurserostering.domain.ShiftType;
import org.optaplanner.examples.nurserostering.domain.ShiftTypeSkillRequirement;
import org.optaplanner.examples.nurserostering.domain.Skill;
import org.optaplanner.examples.nurserostering.domain.SkillProficiency;
import org.optaplanner.examples.nurserostering.domain.WeekendDefinition;
import org.optaplanner.examples.nurserostering.domain.contract.BooleanContractLine;
import org.optaplanner.examples.nurserostering.domain.contract.Contract;
import org.optaplanner.examples.nurserostering.domain.contract.ContractLineType;
import org.optaplanner.examples.nurserostering.domain.contract.MinMaxContractLine;
import org.optaplanner.examples.nurserostering.domain.contract.PatternContractLine;
import org.optaplanner.examples.nurserostering.domain.pattern.FreeBefore2DaysWithAWorkDayPattern;
import org.optaplanner.examples.nurserostering.domain.pattern.Pattern;
import org.optaplanner.examples.nurserostering.domain.pattern.ShiftType2DaysPattern;
import org.optaplanner.examples.nurserostering.domain.pattern.ShiftType3DaysPattern;
import org.optaplanner.examples.nurserostering.domain.request.DayOffRequest;
import org.optaplanner.examples.nurserostering.domain.request.DayOnRequest;
import org.optaplanner.examples.nurserostering.domain.request.ShiftOffRequest;
import org.optaplanner.examples.nurserostering.domain.request.ShiftOnRequest;
import org.optaplanner.examples.nurserostering.score.NurseRosteringConstraintProvider;
import org.optaplanner.test.api.score.stream.ConstraintVerifier;

public class NurseRosteringConstraintProviderTest {
    private final ConstraintVerifier<NurseRosteringConstraintProvider, NurseRoster> constraintVerifier = ConstraintVerifier.build((ConstraintProvider)new NurseRosteringConstraintProvider(), NurseRoster.class, (Class[])new Class[]{ShiftAssignment.class});
    private final AtomicLong idSupplier = new AtomicLong(0L);
    private final Map<Pair<Integer, ShiftType>, Shift> indexShiftTypePairToShiftMap = new HashMap<Pair<Integer, ShiftType>, Shift>();
    private final Map<Integer, ShiftDate> indexToShiftDateMap = new HashMap<Integer, ShiftDate>();
    private final ShiftType dayShiftType = new ShiftType();
    private final ShiftType nightShiftType = new ShiftType();

    @BeforeEach
    public void setup() {
        this.idSupplier.set(0L);
        this.indexShiftTypePairToShiftMap.clear();
        this.indexToShiftDateMap.clear();
        this.dayShiftType.setId(Long.valueOf(this.idSupplier.incrementAndGet()));
        this.dayShiftType.setNight(false);
        this.dayShiftType.setStartTimeString("09:00");
        this.dayShiftType.setEndTimeString("17:00");
        this.dayShiftType.setCode("ShiftType - Day");
        this.dayShiftType.setIndex(0);
        this.dayShiftType.setDescription("Day Shift");
        this.nightShiftType.setId(Long.valueOf(this.idSupplier.incrementAndGet()));
        this.nightShiftType.setNight(true);
        this.nightShiftType.setStartTimeString("07:00");
        this.nightShiftType.setEndTimeString("04:00");
        this.nightShiftType.setCode("ShiftType - Night");
        this.nightShiftType.setIndex(1);
        this.nightShiftType.setDescription("Night Shift");
    }

    private Employee getEmployee() {
        return this.getEmployee(new MinMaxContractBuilder(ContractLineType.TOTAL_ASSIGNMENTS).build());
    }

    private Employee getEmployee(Contract contract) {
        Employee employee = new Employee();
        employee.setContract(contract);
        employee.setId(Long.valueOf(this.idSupplier.incrementAndGet()));
        employee.setName("Employee " + employee.getId());
        employee.setCode(employee.getName());
        employee.setDayOffRequestMap(new HashMap());
        employee.setDayOnRequestMap(new HashMap());
        employee.setShiftOffRequestMap(new HashMap());
        employee.setShiftOnRequestMap(new HashMap());
        return employee;
    }

    private ShiftDate getShiftDate(int dayIndex) {
        return this.indexToShiftDateMap.computeIfAbsent(dayIndex, key -> {
            ShiftDate shiftDate = new ShiftDate();
            shiftDate.setDayIndex(dayIndex);
            shiftDate.setId(Long.valueOf(this.idSupplier.incrementAndGet()));
            shiftDate.setDate(LocalDate.of(2000, 1, 1).plusDays(dayIndex));
            shiftDate.setShiftList(new ArrayList());
            return shiftDate;
        });
    }

    private ShiftAssignment getShiftAssignment(int dayIndex, Employee employee) {
        return this.getShiftAssignment(dayIndex, employee, this.dayShiftType);
    }

    private ShiftAssignment getShiftAssignment(int dayIndex, Employee employee, ShiftType shiftType) {
        Shift shift = this.indexShiftTypePairToShiftMap.computeIfAbsent((Pair<Integer, ShiftType>)ImmutablePair.of((Object)dayIndex, (Object)shiftType), key -> {
            ShiftDate shiftDate = this.getShiftDate(dayIndex);
            Shift newShift = new Shift();
            newShift.setShiftType(shiftType);
            newShift.setId(Long.valueOf(this.idSupplier.incrementAndGet()));
            newShift.setRequiredEmployeeSize(0);
            newShift.setIndex(0);
            newShift.setShiftDate(shiftDate);
            shiftDate.getShiftList().add(newShift);
            return newShift;
        });
        shift.setRequiredEmployeeSize(shift.getRequiredEmployeeSize() + 1);
        ShiftAssignment shiftAssignment = new ShiftAssignment();
        shiftAssignment.setId(Long.valueOf(this.idSupplier.incrementAndGet()));
        shiftAssignment.setEmployee(employee);
        shiftAssignment.setIndexInShift(0);
        shiftAssignment.setShift(shift);
        return shiftAssignment;
    }

    private DayOffRequest getDayOffRequest(Employee employee, ShiftDate shiftDate, int weight) {
        DayOffRequest dayOffRequest = new DayOffRequest();
        dayOffRequest.setId(Long.valueOf(this.idSupplier.incrementAndGet()));
        dayOffRequest.setEmployee(employee);
        dayOffRequest.setShiftDate(shiftDate);
        dayOffRequest.setWeight(weight);
        return dayOffRequest;
    }

    private DayOnRequest getDayOnRequest(Employee employee, ShiftDate shiftDate, int weight) {
        DayOnRequest dayOnRequest = new DayOnRequest();
        dayOnRequest.setId(Long.valueOf(this.idSupplier.incrementAndGet()));
        dayOnRequest.setEmployee(employee);
        dayOnRequest.setShiftDate(shiftDate);
        dayOnRequest.setWeight(weight);
        return dayOnRequest;
    }

    private ShiftOffRequest getShiftOffRequest(Employee employee, Shift shift, int weight) {
        ShiftOffRequest shiftOffRequest = new ShiftOffRequest();
        shiftOffRequest.setId(Long.valueOf(this.idSupplier.incrementAndGet()));
        shiftOffRequest.setEmployee(employee);
        shiftOffRequest.setShift(shift);
        shiftOffRequest.setWeight(weight);
        return shiftOffRequest;
    }

    private ShiftOnRequest getShiftOnRequest(Employee employee, Shift shift, int weight) {
        ShiftOnRequest shiftOnRequest = new ShiftOnRequest();
        shiftOnRequest.setId(Long.valueOf(this.idSupplier.incrementAndGet()));
        shiftOnRequest.setEmployee(employee);
        shiftOnRequest.setShift(shift);
        shiftOnRequest.setWeight(weight);
        return shiftOnRequest;
    }

    private Skill getSkill(String name) {
        Skill skill = new Skill();
        skill.setId(Long.valueOf(this.idSupplier.incrementAndGet()));
        skill.setCode("Skill - " + name);
        return skill;
    }

    private SkillProficiency getSkillProficiency(Employee employee, Skill skill) {
        SkillProficiency skillProficiency = new SkillProficiency();
        skillProficiency.setId(Long.valueOf(this.idSupplier.incrementAndGet()));
        skillProficiency.setSkill(skill);
        skillProficiency.setEmployee(employee);
        return skillProficiency;
    }

    private ShiftTypeSkillRequirement getSkillRequirement(ShiftType shiftType, Skill skill) {
        ShiftTypeSkillRequirement skillRequirement = new ShiftTypeSkillRequirement();
        skillRequirement.setId(Long.valueOf(this.idSupplier.incrementAndGet()));
        skillRequirement.setShiftType(shiftType);
        skillRequirement.setSkill(skill);
        return skillRequirement;
    }

    @Test
    public void oneShiftPerDay() {
        Employee employee = this.getEmployee();
        ShiftAssignment shift1 = this.getShiftAssignment(0, employee);
        ShiftAssignment shift2 = this.getShiftAssignment(0, employee);
        ShiftAssignment shift3 = this.getShiftAssignment(1, employee);
        ShiftAssignment shift4 = this.getShiftAssignment(2, employee);
        ShiftAssignment shift5 = this.getShiftAssignment(2, employee);
        this.constraintVerifier.verifyThat(NurseRosteringConstraintProvider::oneShiftPerDay).given(new Object[]{shift1, shift2, shift3, shift4, shift5}).penalizesBy(2);
    }

    @Test
    public void minimumAndMaximumNumberOfAssignments() {
        Contract contract = new MinMaxContractBuilder(ContractLineType.TOTAL_ASSIGNMENTS).withMinimum(2).withMaximum(3).withMinimumWeight(2).withMaximumWeight(4).build();
        Employee employee = this.getEmployee(contract);
        ShiftAssignment shift1 = this.getShiftAssignment(0, employee);
        ShiftAssignment shift2 = this.getShiftAssignment(0, employee);
        ShiftAssignment shift3 = this.getShiftAssignment(1, employee);
        ShiftAssignment shift4 = this.getShiftAssignment(2, employee);
        ShiftAssignment shift5 = this.getShiftAssignment(2, employee);
        this.constraintVerifier.verifyThat(NurseRosteringConstraintProvider::minimumAndMaximumNumberOfAssignments).given(new Object[]{contract.getContractLineList().get(0), employee, shift1, shift2, shift3, shift4, shift5}).penalizesBy(8);
        this.constraintVerifier.verifyThat(NurseRosteringConstraintProvider::minimumAndMaximumNumberOfAssignments).given(new Object[]{contract.getContractLineList().get(0), employee, shift1}).penalizesBy(2);
        this.constraintVerifier.verifyThat(NurseRosteringConstraintProvider::minimumAndMaximumNumberOfAssignments).given(new Object[]{contract.getContractLineList().get(0), employee, shift1, shift2, shift3}).penalizesBy(0);
        this.constraintVerifier.verifyThat(NurseRosteringConstraintProvider::minimumAndMaximumNumberOfAssignments).given(new Object[]{contract.getContractLineList().get(0), employee, shift1, shift2}).penalizesBy(0);
    }

    @Test
    public void minimumNumberOfAssignmentsNoAssignments() {
        Contract contract = new MinMaxContractBuilder(ContractLineType.TOTAL_ASSIGNMENTS).withMinimum(2).withMinimumWeight(5).build();
        Employee employeeNoShifts = this.getEmployee(contract);
        Employee employeeWithShifts = this.getEmployee(contract);
        ShiftAssignment shift = this.getShiftAssignment(0, employeeWithShifts);
        this.constraintVerifier.verifyThat(NurseRosteringConstraintProvider::minimumNumberOfAssignmentsNoAssignments).given(new Object[]{contract.getContractLineList().get(0), employeeNoShifts, employeeWithShifts, shift}).penalizesBy(10);
    }

    @Test
    public void consecutiveWorkingDays() {
        Contract contract = new MinMaxContractBuilder(ContractLineType.CONSECUTIVE_WORKING_DAYS).withMinimum(2).withMaximum(3).withMinimumWeight(2).withMaximumWeight(4).build();
        Employee employee = this.getEmployee(contract);
        ShiftAssignment shift1 = this.getShiftAssignment(0, employee);
        ShiftAssignment shift2 = this.getShiftAssignment(1, employee);
        ShiftAssignment shift3 = this.getShiftAssignment(2, employee);
        ShiftAssignment shift4 = this.getShiftAssignment(3, employee);
        ShiftAssignment shift5 = this.getShiftAssignment(4, employee);
        this.constraintVerifier.verifyThat(NurseRosteringConstraintProvider::consecutiveWorkingDays).given(new Object[]{contract.getContractLineList().get(0), employee, shift1, shift2, shift3, shift4, shift5}).penalizesBy(8);
        this.constraintVerifier.verifyThat(NurseRosteringConstraintProvider::consecutiveWorkingDays).given(new Object[]{contract.getContractLineList().get(0), employee, shift1}).penalizesBy(2);
        this.constraintVerifier.verifyThat(NurseRosteringConstraintProvider::consecutiveWorkingDays).given(new Object[]{contract.getContractLineList().get(0), employee, shift1, shift2, shift3}).penalizesBy(0);
        this.constraintVerifier.verifyThat(NurseRosteringConstraintProvider::consecutiveWorkingDays).given(new Object[]{contract.getContractLineList().get(0), employee, shift1, shift2}).penalizesBy(0);
        this.constraintVerifier.verifyThat(NurseRosteringConstraintProvider::consecutiveWorkingDays).given(new Object[]{contract.getContractLineList().get(0), employee, shift1, shift2, shift4, shift5}).penalizesBy(0);
    }

    @Test
    public void consecutiveFreeDays() {
        Contract contract = new MinMaxContractBuilder(ContractLineType.CONSECUTIVE_FREE_DAYS).withMinimum(2).withMaximum(3).withMinimumWeight(2).withMaximumWeight(4).build();
        Employee employee = this.getEmployee(contract);
        ShiftAssignment shift1 = this.getShiftAssignment(0, employee);
        ShiftAssignment shift3 = this.getShiftAssignment(2, employee);
        ShiftAssignment shift4 = this.getShiftAssignment(3, employee);
        ShiftAssignment shift5 = this.getShiftAssignment(4, employee);
        ShiftAssignment shift7 = this.getShiftAssignment(6, employee);
        this.constraintVerifier.verifyThat(NurseRosteringConstraintProvider::consecutiveFreeDays).given(new Object[]{contract.getContractLineList().get(0), employee, shift1, shift7}).penalizesBy(8);
        this.constraintVerifier.verifyThat(NurseRosteringConstraintProvider::consecutiveFreeDays).given(new Object[]{contract.getContractLineList().get(0), employee, shift1, shift3}).penalizesBy(2);
        this.constraintVerifier.verifyThat(NurseRosteringConstraintProvider::consecutiveFreeDays).given(new Object[]{contract.getContractLineList().get(0), employee, shift1, shift5}).penalizesBy(0);
        this.constraintVerifier.verifyThat(NurseRosteringConstraintProvider::consecutiveFreeDays).given(new Object[]{contract.getContractLineList().get(0), employee, shift1, shift4}).penalizesBy(0);
        this.constraintVerifier.verifyThat(NurseRosteringConstraintProvider::consecutiveFreeDays).given(new Object[]{contract.getContractLineList().get(0), employee, shift1, shift4, shift7}).penalizesBy(0);
    }

    @Test
    public void maximumConsecutiveFreeDaysNoAssignments() {
        Contract contract = new MinMaxContractBuilder(ContractLineType.CONSECUTIVE_FREE_DAYS).withMaximum(1).withMaximumWeight(1).build();
        Employee employeeNoShifts = this.getEmployee(contract);
        Employee employeeWithShifts = this.getEmployee(contract);
        ShiftAssignment shift = this.getShiftAssignment(0, employeeWithShifts);
        NurseRosterParametrization nurseRosterParametrization = new NurseRosterParametrization();
        nurseRosterParametrization.setId(Long.valueOf(this.idSupplier.incrementAndGet()));
        nurseRosterParametrization.setPlanningWindowStart(this.getShiftDate(0));
        nurseRosterParametrization.setFirstShiftDate(this.getShiftDate(0));
        nurseRosterParametrization.setLastShiftDate(this.getShiftDate(5));
        this.constraintVerifier.verifyThat(NurseRosteringConstraintProvider::maximumConsecutiveFreeDaysNoAssignments).given(new Object[]{contract.getContractLineList().get(0), employeeNoShifts, employeeWithShifts, shift, nurseRosterParametrization}).penalizesBy(5);
    }

    @Test
    public void consecutiveFreeDaysFirstBreak() {
        Contract contract = new MinMaxContractBuilder(ContractLineType.CONSECUTIVE_FREE_DAYS).withMinimum(2).withMaximum(3).withMinimumWeight(2).withMaximumWeight(4).build();
        Employee employee = this.getEmployee(contract);
        ShiftAssignment shift2 = this.getShiftAssignment(1, employee);
        ShiftAssignment shift3 = this.getShiftAssignment(2, employee);
        ShiftAssignment shift5 = this.getShiftAssignment(4, employee);
        NurseRosterParametrization nurseRosterParametrization = new NurseRosterParametrization();
        nurseRosterParametrization.setId(Long.valueOf(this.idSupplier.incrementAndGet()));
        nurseRosterParametrization.setPlanningWindowStart(this.getShiftDate(0));
        nurseRosterParametrization.setFirstShiftDate(this.getShiftDate(0));
        nurseRosterParametrization.setLastShiftDate(this.getShiftDate(5));
        this.constraintVerifier.verifyThat(NurseRosteringConstraintProvider::consecutiveFreeDaysFirstBreak).given(new Object[]{contract.getContractLineList().get(0), employee, shift2, nurseRosterParametrization}).penalizesBy(2);
        this.constraintVerifier.verifyThat(NurseRosteringConstraintProvider::consecutiveFreeDaysFirstBreak).given(new Object[]{contract.getContractLineList().get(0), employee, shift5, nurseRosterParametrization}).penalizesBy(4);
        this.constraintVerifier.verifyThat(NurseRosteringConstraintProvider::consecutiveFreeDaysFirstBreak).given(new Object[]{contract.getContractLineList().get(0), employee, shift3, shift5, nurseRosterParametrization}).penalizesBy(0);
    }

    @Test
    public void consecutiveFreeDaysFinalBreak() {
        Contract contract = new MinMaxContractBuilder(ContractLineType.CONSECUTIVE_FREE_DAYS).withMinimum(2).withMaximum(3).withMinimumWeight(2).withMaximumWeight(4).build();
        Employee employee = this.getEmployee(contract);
        ShiftAssignment shift1 = this.getShiftAssignment(0, employee);
        ShiftAssignment shift2 = this.getShiftAssignment(1, employee);
        ShiftAssignment shift4 = this.getShiftAssignment(3, employee);
        ShiftAssignment shift5 = this.getShiftAssignment(4, employee);
        NurseRosterParametrization nurseRosterParametrization = new NurseRosterParametrization();
        nurseRosterParametrization.setId(Long.valueOf(this.idSupplier.incrementAndGet()));
        nurseRosterParametrization.setPlanningWindowStart(this.getShiftDate(0));
        nurseRosterParametrization.setFirstShiftDate(this.getShiftDate(0));
        nurseRosterParametrization.setLastShiftDate(this.getShiftDate(5));
        this.constraintVerifier.verifyThat(NurseRosteringConstraintProvider::consecutiveFreeDaysFinalBreak).given(new Object[]{contract.getContractLineList().get(0), employee, shift5, nurseRosterParametrization}).penalizesBy(2);
        this.constraintVerifier.verifyThat(NurseRosteringConstraintProvider::consecutiveFreeDaysFinalBreak).given(new Object[]{contract.getContractLineList().get(0), employee, shift2, nurseRosterParametrization}).penalizesBy(4);
        this.constraintVerifier.verifyThat(NurseRosteringConstraintProvider::consecutiveFreeDaysFinalBreak).given(new Object[]{contract.getContractLineList().get(0), employee, shift1, shift4, nurseRosterParametrization}).penalizesBy(0);
    }

    @Test
    public void consecutiveWorkingWeekends() {
        Contract contract = new MinMaxContractBuilder(ContractLineType.CONSECUTIVE_WORKING_WEEKENDS).withMinimum(2).withMinimumWeight(2).withMaximum(3).withMaximumWeight(4).build();
        Employee employee = this.getEmployee(contract);
        ShiftAssignment shift1 = this.getShiftAssignment(0, employee);
        ShiftAssignment shift2 = this.getShiftAssignment(1, employee);
        ShiftAssignment shift3 = this.getShiftAssignment(8, employee);
        ShiftAssignment shift4 = this.getShiftAssignment(14, employee);
        ShiftAssignment shift5 = this.getShiftAssignment(15, employee);
        ShiftAssignment shift6 = this.getShiftAssignment(21, employee);
        this.constraintVerifier.verifyThat(NurseRosteringConstraintProvider::consecutiveWorkingWeekends).given(new Object[]{contract.getContractLineList().get(0), employee, shift1, shift2, shift3, shift4, shift5, shift6}).penalizesBy(4);
        this.constraintVerifier.verifyThat(NurseRosteringConstraintProvider::consecutiveWorkingWeekends).given(new Object[]{contract.getContractLineList().get(0), employee, shift1}).penalizesBy(2);
        this.constraintVerifier.verifyThat(NurseRosteringConstraintProvider::consecutiveWorkingWeekends).given(new Object[]{contract.getContractLineList().get(0), employee, shift1, shift2, shift3}).penalizesBy(0);
        this.constraintVerifier.verifyThat(NurseRosteringConstraintProvider::consecutiveWorkingWeekends).given(new Object[]{contract.getContractLineList().get(0), employee, shift1, shift2}).penalizesBy(2);
        this.constraintVerifier.verifyThat(NurseRosteringConstraintProvider::consecutiveWorkingWeekends).given(new Object[]{contract.getContractLineList().get(0), employee, shift1, shift2, shift4, shift5}).penalizesBy(4);
    }

    @Test
    public void startOnNotFirstDayOfWeekend() {
        Contract contract = new BooleanContractBuilder(ContractLineType.COMPLETE_WEEKENDS).withWeight(3).build();
        Employee employee = this.getEmployee(contract);
        ShiftAssignment shift1 = this.getShiftAssignment(0, employee);
        ShiftAssignment shift2 = this.getShiftAssignment(1, employee);
        ShiftAssignment shift3 = this.getShiftAssignment(7, employee);
        ShiftAssignment shift4 = this.getShiftAssignment(8, employee);
        ShiftAssignment shift5 = this.getShiftAssignment(14, employee);
        ShiftAssignment shift6 = this.getShiftAssignment(15, employee);
        this.constraintVerifier.verifyThat(NurseRosteringConstraintProvider::startOnNotFirstDayOfWeekend).given(new Object[]{contract.getContractLineList().get(0), employee, shift2, shift3, shift4, shift5}).penalizesBy(3);
        this.constraintVerifier.verifyThat(NurseRosteringConstraintProvider::startOnNotFirstDayOfWeekend).given(new Object[]{contract.getContractLineList().get(0), employee, shift1}).penalizesBy(0);
        this.constraintVerifier.verifyThat(NurseRosteringConstraintProvider::startOnNotFirstDayOfWeekend).given(new Object[]{contract.getContractLineList().get(0), employee, shift1, shift2, shift3}).penalizesBy(0);
        this.constraintVerifier.verifyThat(NurseRosteringConstraintProvider::startOnNotFirstDayOfWeekend).given(new Object[]{contract.getContractLineList().get(0), employee, shift2, shift6}).penalizesBy(6);
        this.constraintVerifier.verifyThat(NurseRosteringConstraintProvider::startOnNotFirstDayOfWeekend).given(new Object[]{contract.getContractLineList().get(0), employee, shift1, shift2, shift3, shift4}).penalizesBy(0);
    }

    @Test
    public void endOnNotLastDayOfWeekend() {
        Contract contract = new BooleanContractBuilder(ContractLineType.COMPLETE_WEEKENDS).withWeight(3).build();
        Employee employee = this.getEmployee(contract);
        ShiftAssignment shift1 = this.getShiftAssignment(0, employee);
        ShiftAssignment shift2 = this.getShiftAssignment(1, employee);
        ShiftAssignment shift3 = this.getShiftAssignment(7, employee);
        ShiftAssignment shift4 = this.getShiftAssignment(8, employee);
        ShiftAssignment shift5 = this.getShiftAssignment(14, employee);
        this.constraintVerifier.verifyThat(NurseRosteringConstraintProvider::endOnNotLastDayOfWeekend).given(new Object[]{contract.getContractLineList().get(0), employee, shift1}).penalizesBy(3);
        this.constraintVerifier.verifyThat(NurseRosteringConstraintProvider::endOnNotLastDayOfWeekend).given(new Object[]{contract.getContractLineList().get(0), employee, shift1}).penalizesBy(3);
        this.constraintVerifier.verifyThat(NurseRosteringConstraintProvider::endOnNotLastDayOfWeekend).given(new Object[]{contract.getContractLineList().get(0), employee, shift1, shift2, shift3}).penalizesBy(3);
        this.constraintVerifier.verifyThat(NurseRosteringConstraintProvider::endOnNotLastDayOfWeekend).given(new Object[]{contract.getContractLineList().get(0), employee, shift1, shift5}).penalizesBy(6);
        this.constraintVerifier.verifyThat(NurseRosteringConstraintProvider::endOnNotLastDayOfWeekend).given(new Object[]{contract.getContractLineList().get(0), employee, shift1, shift2, shift3, shift4}).penalizesBy(0);
    }

    @Test
    public void identicalShiftTypesDuringWeekend() {
        Contract contract = new BooleanContractBuilder(ContractLineType.IDENTICAL_SHIFT_TYPES_DURING_WEEKEND).withWeight(3).build();
        Employee employee = this.getEmployee(contract);
        ShiftAssignment shift1Day = this.getShiftAssignment(0, employee, this.dayShiftType);
        ShiftAssignment shift2Day = this.getShiftAssignment(1, employee, this.dayShiftType);
        ShiftAssignment shift4Day = this.getShiftAssignment(8, employee, this.dayShiftType);
        ShiftAssignment shift2Night = this.getShiftAssignment(1, employee, this.nightShiftType);
        ShiftAssignment shift3Night = this.getShiftAssignment(7, employee, this.nightShiftType);
        this.constraintVerifier.verifyThat(NurseRosteringConstraintProvider::identicalShiftTypesDuringWeekend).given(new Object[]{contract.getContractLineList().get(0), employee, shift1Day, shift2Night, shift1Day.getShiftDate(), shift2Night.getShiftDate()}).penalizesBy(6);
        this.constraintVerifier.verifyThat(NurseRosteringConstraintProvider::identicalShiftTypesDuringWeekend).given(new Object[]{contract.getContractLineList().get(0), employee, shift1Day, shift1Day.getShiftDate()}).penalizesBy(0);
        this.constraintVerifier.verifyThat(NurseRosteringConstraintProvider::identicalShiftTypesDuringWeekend).given(new Object[]{contract.getContractLineList().get(0), employee, shift1Day, shift2Day, shift3Night, shift1Day.getShiftDate(), shift2Day.getShiftDate(), shift3Night.getShiftDate()}).penalizesBy(0);
        this.constraintVerifier.verifyThat(NurseRosteringConstraintProvider::identicalShiftTypesDuringWeekend).given(new Object[]{contract.getContractLineList().get(0), employee, shift1Day, shift2Night, shift3Night, shift4Day, shift1Day.getShiftDate(), shift2Night.getShiftDate(), shift3Night.getShiftDate(), shift4Day.getShiftDate()}).penalizesBy(12);
    }

    @Test
    public void dayOffRequest() {
        Employee employee = this.getEmployee();
        DayOffRequest dayOffRequest1 = this.getDayOffRequest(employee, this.getShiftDate(1), 3);
        DayOffRequest dayOffRequest2 = this.getDayOffRequest(employee, this.getShiftDate(3), 5);
        ShiftAssignment shift1Day = this.getShiftAssignment(1, employee, this.dayShiftType);
        ShiftAssignment shift1Night = this.getShiftAssignment(1, employee, this.nightShiftType);
        ShiftAssignment shift2 = this.getShiftAssignment(2, employee);
        ShiftAssignment shift3 = this.getShiftAssignment(3, employee);
        this.constraintVerifier.verifyThat(NurseRosteringConstraintProvider::dayOffRequest).given(new Object[]{dayOffRequest1, dayOffRequest2, shift1Day, shift2}).penalizesBy(3);
        this.constraintVerifier.verifyThat(NurseRosteringConstraintProvider::dayOffRequest).given(new Object[]{dayOffRequest1, dayOffRequest2, shift1Day, shift1Night}).penalizesBy(6);
        this.constraintVerifier.verifyThat(NurseRosteringConstraintProvider::dayOffRequest).given(new Object[]{dayOffRequest1, dayOffRequest2, shift1Day, shift3}).penalizesBy(8);
        this.constraintVerifier.verifyThat(NurseRosteringConstraintProvider::dayOffRequest).given(new Object[]{dayOffRequest1, dayOffRequest2, shift2}).penalizesBy(0);
    }

    @Test
    public void dayOnRequest() {
        Employee employee = this.getEmployee();
        DayOnRequest dayOnRequest1 = this.getDayOnRequest(employee, this.getShiftDate(1), 3);
        DayOnRequest dayOnRequest2 = this.getDayOnRequest(employee, this.getShiftDate(3), 5);
        ShiftAssignment shift1Day = this.getShiftAssignment(1, employee, this.dayShiftType);
        ShiftAssignment shift1Night = this.getShiftAssignment(1, employee, this.nightShiftType);
        ShiftAssignment shift2 = this.getShiftAssignment(2, employee);
        ShiftAssignment shift3 = this.getShiftAssignment(3, employee);
        this.constraintVerifier.verifyThat(NurseRosteringConstraintProvider::dayOnRequest).given(new Object[]{dayOnRequest1, dayOnRequest2, shift1Day, shift2}).penalizesBy(5);
        this.constraintVerifier.verifyThat(NurseRosteringConstraintProvider::dayOnRequest).given(new Object[]{dayOnRequest1, dayOnRequest2, shift1Day, shift1Night}).penalizesBy(5);
        this.constraintVerifier.verifyThat(NurseRosteringConstraintProvider::dayOnRequest).given(new Object[]{dayOnRequest1, dayOnRequest2, shift1Day, shift3}).penalizesBy(0);
        this.constraintVerifier.verifyThat(NurseRosteringConstraintProvider::dayOnRequest).given(new Object[]{dayOnRequest1, dayOnRequest2, shift2}).penalizesBy(8);
    }

    @Test
    public void shiftOffRequest() {
        Employee employee = this.getEmployee();
        ShiftAssignment shift1Day = this.getShiftAssignment(1, employee, this.dayShiftType);
        ShiftAssignment shift1Night = this.getShiftAssignment(1, employee, this.nightShiftType);
        ShiftAssignment shift2 = this.getShiftAssignment(2, employee);
        ShiftAssignment shift3 = this.getShiftAssignment(3, employee);
        ShiftOffRequest shiftOffRequest1 = this.getShiftOffRequest(employee, shift1Day.getShift(), 3);
        ShiftOffRequest shiftOffRequest2 = this.getShiftOffRequest(employee, shift3.getShift(), 5);
        this.constraintVerifier.verifyThat(NurseRosteringConstraintProvider::shiftOffRequest).given(new Object[]{shiftOffRequest1, shiftOffRequest2, shift1Day, shift2}).penalizesBy(3);
        this.constraintVerifier.verifyThat(NurseRosteringConstraintProvider::shiftOffRequest).given(new Object[]{shiftOffRequest1, shiftOffRequest2, shift1Day, shift1Night}).penalizesBy(3);
        this.constraintVerifier.verifyThat(NurseRosteringConstraintProvider::shiftOffRequest).given(new Object[]{shiftOffRequest1, shiftOffRequest2, shift1Night}).penalizesBy(0);
        this.constraintVerifier.verifyThat(NurseRosteringConstraintProvider::shiftOffRequest).given(new Object[]{shiftOffRequest1, shiftOffRequest2, shift1Day, shift3}).penalizesBy(8);
        this.constraintVerifier.verifyThat(NurseRosteringConstraintProvider::shiftOffRequest).given(new Object[]{shiftOffRequest1, shiftOffRequest2, shift2}).penalizesBy(0);
    }

    @Test
    public void shiftOnRequest() {
        Employee employee = this.getEmployee();
        ShiftAssignment shift1Day = this.getShiftAssignment(1, employee, this.dayShiftType);
        ShiftAssignment shift1Night = this.getShiftAssignment(1, employee, this.nightShiftType);
        ShiftAssignment shift2 = this.getShiftAssignment(2, employee);
        ShiftAssignment shift3 = this.getShiftAssignment(3, employee);
        ShiftOnRequest shiftOffRequest1 = this.getShiftOnRequest(employee, shift1Day.getShift(), 3);
        ShiftOnRequest shiftOffRequest2 = this.getShiftOnRequest(employee, shift3.getShift(), 5);
        this.constraintVerifier.verifyThat(NurseRosteringConstraintProvider::shiftOnRequest).given(new Object[]{shiftOffRequest1, shiftOffRequest2, shift1Day, shift2}).penalizesBy(5);
        this.constraintVerifier.verifyThat(NurseRosteringConstraintProvider::shiftOnRequest).given(new Object[]{shiftOffRequest1, shiftOffRequest2, shift1Day, shift1Night}).penalizesBy(5);
        this.constraintVerifier.verifyThat(NurseRosteringConstraintProvider::shiftOnRequest).given(new Object[]{shiftOffRequest1, shiftOffRequest2, shift1Night}).penalizesBy(8);
        this.constraintVerifier.verifyThat(NurseRosteringConstraintProvider::shiftOnRequest).given(new Object[]{shiftOffRequest1, shiftOffRequest2, shift1Day, shift3}).penalizesBy(0);
        this.constraintVerifier.verifyThat(NurseRosteringConstraintProvider::shiftOnRequest).given(new Object[]{shiftOffRequest1, shiftOffRequest2, shift2}).penalizesBy(8);
    }

    @Test
    public void alternativeSkill() {
        Contract contract = new BooleanContractBuilder(ContractLineType.ALTERNATIVE_SKILL_CATEGORY).withWeight(3).build();
        Employee employee = this.getEmployee(contract);
        Skill skill = this.getSkill("daySkill");
        SkillProficiency skillProficiency = this.getSkillProficiency(employee, skill);
        ShiftTypeSkillRequirement shiftTypeSkillRequirement = this.getSkillRequirement(this.dayShiftType, skill);
        ShiftAssignment dayShift1 = this.getShiftAssignment(1, employee, this.dayShiftType);
        ShiftAssignment dayShift2 = this.getShiftAssignment(2, employee, this.dayShiftType);
        ShiftAssignment nightShift = this.getShiftAssignment(3, employee, this.nightShiftType);
        this.constraintVerifier.verifyThat(NurseRosteringConstraintProvider::alternativeSkill).given(new Object[]{contract.getContractLineList().get(0), shiftTypeSkillRequirement, skillProficiency, dayShift1}).penalizesBy(0);
        this.constraintVerifier.verifyThat(NurseRosteringConstraintProvider::alternativeSkill).given(new Object[]{contract.getContractLineList().get(0), shiftTypeSkillRequirement, dayShift1}).penalizesBy(3);
        this.constraintVerifier.verifyThat(NurseRosteringConstraintProvider::alternativeSkill).given(new Object[]{contract.getContractLineList().get(0), shiftTypeSkillRequirement, dayShift1, nightShift}).penalizesBy(3);
        this.constraintVerifier.verifyThat(NurseRosteringConstraintProvider::alternativeSkill).given(new Object[]{contract.getContractLineList().get(0), shiftTypeSkillRequirement, dayShift1, dayShift2}).penalizesBy(6);
    }

    @Test
    public void unwantedPatternFreeBefore2DaysWithAWorkDayPattern() {
        ImmutablePair<PatternContractLine, Contract> patternContractPair = new PatternContractBuilder().freeBefore2DaysWithAWorkDay(DayOfWeek.WEDNESDAY).build();
        PatternContractLine patternContractLine = (PatternContractLine)patternContractPair.getLeft();
        Contract contract = (Contract)patternContractPair.getRight();
        Employee employee = this.getEmployee(contract);
        ShiftAssignment freeShift = this.getShiftAssignment(4, employee);
        ShiftAssignment afterFreeShift1 = this.getShiftAssignment(5, employee);
        ShiftAssignment afterFreeShift2 = this.getShiftAssignment(6, employee);
        ShiftAssignment afterFreeShift3 = this.getShiftAssignment(7, employee);
        ShiftAssignment beforeFreeShift1 = this.getShiftAssignment(3, employee);
        this.constraintVerifier.verifyThat(NurseRosteringConstraintProvider::unwantedPatternFreeBefore2DaysWithAWorkDayPattern).given(new Object[]{patternContractLine, employee, freeShift.getShiftDate(), afterFreeShift2}).penalizesBy(1);
        this.constraintVerifier.verifyThat(NurseRosteringConstraintProvider::unwantedPatternFreeBefore2DaysWithAWorkDayPattern).given(new Object[]{patternContractLine, employee, freeShift.getShiftDate(), afterFreeShift1, afterFreeShift2}).penalizesBy(1);
        this.constraintVerifier.verifyThat(NurseRosteringConstraintProvider::unwantedPatternFreeBefore2DaysWithAWorkDayPattern).given(new Object[]{patternContractLine, employee, freeShift.getShiftDate(), afterFreeShift1}).penalizesBy(1);
        this.constraintVerifier.verifyThat(NurseRosteringConstraintProvider::unwantedPatternFreeBefore2DaysWithAWorkDayPattern).given(new Object[]{patternContractLine, employee, freeShift.getShiftDate(), afterFreeShift3}).penalizesBy(0);
        this.constraintVerifier.verifyThat(NurseRosteringConstraintProvider::unwantedPatternFreeBefore2DaysWithAWorkDayPattern).given(new Object[]{patternContractLine, employee, freeShift.getShiftDate(), beforeFreeShift1}).penalizesBy(0);
        this.constraintVerifier.verifyThat(NurseRosteringConstraintProvider::unwantedPatternFreeBefore2DaysWithAWorkDayPattern).given(new Object[]{patternContractLine, employee, freeShift.getShiftDate(), afterFreeShift1, afterFreeShift2, freeShift}).penalizesBy(0);
    }

    @Test
    public void unwantedPatternShiftType2DaysPattern() {
        ImmutablePair<PatternContractLine, Contract> patternContractPair = new PatternContractBuilder().shiftType2DaysPattern(this.dayShiftType, this.nightShiftType).build();
        PatternContractLine patternContractLine = (PatternContractLine)patternContractPair.getLeft();
        Contract contract = (Contract)patternContractPair.getRight();
        Employee employee = this.getEmployee(contract);
        ShiftAssignment shift1Day = this.getShiftAssignment(0, employee, this.dayShiftType);
        ShiftAssignment shift2Day = this.getShiftAssignment(1, employee, this.dayShiftType);
        ShiftAssignment shift3Day = this.getShiftAssignment(2, employee, this.dayShiftType);
        ShiftAssignment shift1Night = this.getShiftAssignment(0, employee, this.nightShiftType);
        ShiftAssignment shift2Night = this.getShiftAssignment(1, employee, this.nightShiftType);
        ShiftAssignment shift3Night = this.getShiftAssignment(2, employee, this.nightShiftType);
        ShiftAssignment shift4Night = this.getShiftAssignment(3, employee, this.nightShiftType);
        this.constraintVerifier.verifyThat(NurseRosteringConstraintProvider::unwantedPatternShiftType2DaysPattern).given(new Object[]{patternContractLine, employee, shift1Day, shift2Night}).penalizesBy(1);
        this.constraintVerifier.verifyThat(NurseRosteringConstraintProvider::unwantedPatternShiftType2DaysPattern).given(new Object[]{patternContractLine, employee, shift1Day, shift2Day}).penalizesBy(0);
        this.constraintVerifier.verifyThat(NurseRosteringConstraintProvider::unwantedPatternShiftType2DaysPattern).given(new Object[]{patternContractLine, employee, shift1Night, shift2Day}).penalizesBy(0);
        this.constraintVerifier.verifyThat(NurseRosteringConstraintProvider::unwantedPatternShiftType2DaysPattern).given(new Object[]{patternContractLine, employee, shift1Day, shift2Night, shift3Day, shift4Night}).penalizesBy(2);
        this.constraintVerifier.verifyThat(NurseRosteringConstraintProvider::unwantedPatternShiftType2DaysPattern).given(new Object[]{patternContractLine, employee, shift1Day, shift3Night}).penalizesBy(0);
    }

    @Test
    public void unwantedPatternShiftType2DaysPatternNullSecondShiftType() {
        ImmutablePair<PatternContractLine, Contract> patternContractPair = new PatternContractBuilder().shiftType2DaysPattern(this.dayShiftType, null).build();
        PatternContractLine patternContractLine = (PatternContractLine)patternContractPair.getLeft();
        Contract contract = (Contract)patternContractPair.getRight();
        Employee employee = this.getEmployee(contract);
        ShiftAssignment shift1Day = this.getShiftAssignment(0, employee, this.dayShiftType);
        ShiftAssignment shift2Day = this.getShiftAssignment(1, employee, this.dayShiftType);
        ShiftAssignment shift3Day = this.getShiftAssignment(2, employee, this.dayShiftType);
        ShiftAssignment shift4Day = this.getShiftAssignment(3, employee, this.dayShiftType);
        ShiftAssignment shift1Night = this.getShiftAssignment(0, employee, this.nightShiftType);
        ShiftAssignment shift2Night = this.getShiftAssignment(1, employee, this.nightShiftType);
        ShiftAssignment shift3Night = this.getShiftAssignment(2, employee, this.nightShiftType);
        this.constraintVerifier.verifyThat(NurseRosteringConstraintProvider::unwantedPatternShiftType2DaysPattern).given(new Object[]{patternContractLine, employee, shift1Day, shift2Night}).penalizesBy(1);
        this.constraintVerifier.verifyThat(NurseRosteringConstraintProvider::unwantedPatternShiftType2DaysPattern).given(new Object[]{patternContractLine, employee, shift1Day, shift2Day}).penalizesBy(1);
        this.constraintVerifier.verifyThat(NurseRosteringConstraintProvider::unwantedPatternShiftType2DaysPattern).given(new Object[]{patternContractLine, employee, shift1Night, shift2Day}).penalizesBy(0);
        this.constraintVerifier.verifyThat(NurseRosteringConstraintProvider::unwantedPatternShiftType2DaysPattern).given(new Object[]{patternContractLine, employee, shift1Day, shift2Night, shift3Day, shift4Day}).penalizesBy(2);
        this.constraintVerifier.verifyThat(NurseRosteringConstraintProvider::unwantedPatternShiftType2DaysPattern).given(new Object[]{patternContractLine, employee, shift1Day, shift3Night}).penalizesBy(0);
    }

    @Test
    public void unwantedPatternShiftType3DaysPattern() {
        ImmutablePair<PatternContractLine, Contract> patternContractPair = new PatternContractBuilder().shiftType3DaysPattern(this.dayShiftType, this.nightShiftType, this.nightShiftType).build();
        PatternContractLine patternContractLine = (PatternContractLine)patternContractPair.getLeft();
        Contract contract = (Contract)patternContractPair.getRight();
        Employee employee = this.getEmployee(contract);
        ShiftAssignment shift1Day = this.getShiftAssignment(0, employee, this.dayShiftType);
        ShiftAssignment shift3Day = this.getShiftAssignment(2, employee, this.dayShiftType);
        ShiftAssignment shift4Day = this.getShiftAssignment(3, employee, this.dayShiftType);
        ShiftAssignment shift1Night = this.getShiftAssignment(0, employee, this.nightShiftType);
        ShiftAssignment shift2Night = this.getShiftAssignment(1, employee, this.nightShiftType);
        ShiftAssignment shift3Night = this.getShiftAssignment(2, employee, this.nightShiftType);
        ShiftAssignment shift4Night = this.getShiftAssignment(3, employee, this.nightShiftType);
        ShiftAssignment shift5Night = this.getShiftAssignment(4, employee, this.nightShiftType);
        ShiftAssignment shift6Night = this.getShiftAssignment(5, employee, this.nightShiftType);
        this.constraintVerifier.verifyThat(NurseRosteringConstraintProvider::unwantedPatternShiftType3DaysPattern).given(new Object[]{patternContractLine, employee, shift1Day, shift2Night, shift3Night}).penalizesBy(1);
        this.constraintVerifier.verifyThat(NurseRosteringConstraintProvider::unwantedPatternShiftType3DaysPattern).given(new Object[]{patternContractLine, employee, shift1Day, shift2Night, shift3Day}).penalizesBy(0);
        this.constraintVerifier.verifyThat(NurseRosteringConstraintProvider::unwantedPatternShiftType3DaysPattern).given(new Object[]{patternContractLine, employee, shift1Night, shift2Night, shift3Day}).penalizesBy(0);
        this.constraintVerifier.verifyThat(NurseRosteringConstraintProvider::unwantedPatternShiftType3DaysPattern).given(new Object[]{patternContractLine, employee, shift1Day, shift2Night, shift3Night, shift4Day, shift5Night, shift6Night}).penalizesBy(2);
        this.constraintVerifier.verifyThat(NurseRosteringConstraintProvider::unwantedPatternShiftType3DaysPattern).given(new Object[]{patternContractLine, employee, shift1Day, shift2Night, shift4Night}).penalizesBy(0);
    }

    private class PatternContractBuilder {
        FreeBefore2DaysWithAWorkDayPattern freeBefore2DaysWithAWorkDayPattern;
        ShiftType2DaysPattern shiftType2DaysPattern;
        ShiftType3DaysPattern shiftType3DaysPattern;
        private WeekendDefinition weekendDefinition = WeekendDefinition.SATURDAY_SUNDAY;
        int weight = 1;

        private PatternContractBuilder() {
        }

        public PatternContractBuilder freeBefore2DaysWithAWorkDay(DayOfWeek workDay) {
            this.freeBefore2DaysWithAWorkDayPattern = new FreeBefore2DaysWithAWorkDayPattern();
            this.freeBefore2DaysWithAWorkDayPattern.setFreeDayOfWeek(workDay);
            this.freeBefore2DaysWithAWorkDayPattern.setId(Long.valueOf(NurseRosteringConstraintProviderTest.this.idSupplier.incrementAndGet()));
            this.freeBefore2DaysWithAWorkDayPattern.setCode("Free Before 2 Days - " + workDay);
            return this;
        }

        public PatternContractBuilder shiftType2DaysPattern(ShiftType day0ShiftType, ShiftType day1ShiftType) {
            this.shiftType2DaysPattern = new ShiftType2DaysPattern();
            this.shiftType2DaysPattern.setId(Long.valueOf(NurseRosteringConstraintProviderTest.this.idSupplier.incrementAndGet()));
            this.shiftType2DaysPattern.setCode("Shift Type 2 Day Pattern - " + day0ShiftType + ", " + day1ShiftType);
            this.shiftType2DaysPattern.setDayIndex0ShiftType(day0ShiftType);
            this.shiftType2DaysPattern.setDayIndex1ShiftType(day1ShiftType);
            return this;
        }

        public PatternContractBuilder shiftType3DaysPattern(ShiftType day0ShiftType, ShiftType day1ShiftType, ShiftType day2ShiftType) {
            this.shiftType3DaysPattern = new ShiftType3DaysPattern();
            this.shiftType3DaysPattern.setId(Long.valueOf(NurseRosteringConstraintProviderTest.this.idSupplier.incrementAndGet()));
            this.shiftType3DaysPattern.setCode("Shift Type 3 Day Pattern - " + day0ShiftType + ", " + day1ShiftType + ", " + day2ShiftType);
            this.shiftType3DaysPattern.setDayIndex0ShiftType(day0ShiftType);
            this.shiftType3DaysPattern.setDayIndex1ShiftType(day1ShiftType);
            this.shiftType3DaysPattern.setDayIndex2ShiftType(day2ShiftType);
            return this;
        }

        public ImmutablePair<PatternContractLine, Contract> build() {
            PatternContractLine patternContractLine = new PatternContractLine();
            if (this.freeBefore2DaysWithAWorkDayPattern != null) {
                patternContractLine.setPattern((Pattern)this.freeBefore2DaysWithAWorkDayPattern);
            }
            if (this.shiftType2DaysPattern != null) {
                if (patternContractLine.getPattern() != null) {
                    throw new IllegalStateException("Multiple patterns are set on the builder");
                }
                patternContractLine.setPattern((Pattern)this.shiftType2DaysPattern);
            }
            if (this.shiftType3DaysPattern != null) {
                if (patternContractLine.getPattern() != null) {
                    throw new IllegalStateException("Multiple patterns are set on the builder");
                }
                patternContractLine.setPattern((Pattern)this.shiftType3DaysPattern);
            }
            if (patternContractLine.getPattern() == null) {
                throw new IllegalStateException("No patterns are set on the builder");
            }
            patternContractLine.setId(Long.valueOf(NurseRosteringConstraintProviderTest.this.idSupplier.incrementAndGet()));
            patternContractLine.getPattern().setWeight(this.weight);
            Contract out = new Contract();
            out.setId(Long.valueOf(NurseRosteringConstraintProviderTest.this.idSupplier.incrementAndGet()));
            out.setContractLineList(Collections.emptyList());
            patternContractLine.setContract(out);
            out.setCode("Contract - " + out.getId());
            out.setDescription("Pattern " + patternContractLine + " Contract");
            out.setWeekendDefinition(this.weekendDefinition);
            return ImmutablePair.of((Object)patternContractLine, (Object)out);
        }
    }

    private class BooleanContractBuilder {
        private ContractLineType contractLineType;
        private WeekendDefinition weekendDefinition;
        int weight;
        boolean enabled;

        public BooleanContractBuilder(ContractLineType contractLineType) {
            this.contractLineType = contractLineType;
            this.weekendDefinition = WeekendDefinition.SATURDAY_SUNDAY;
            this.weight = 1;
            this.enabled = true;
        }

        public BooleanContractBuilder withWeight(int weight) {
            this.weight = weight;
            return this;
        }

        public BooleanContractBuilder withEnabled(boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public Contract build() {
            BooleanContractLine contractLine = new BooleanContractLine();
            contractLine.setId(Long.valueOf(NurseRosteringConstraintProviderTest.this.idSupplier.incrementAndGet()));
            contractLine.setContractLineType(this.contractLineType);
            contractLine.setWeight(this.weight);
            contractLine.setEnabled(this.enabled);
            Contract out = new Contract();
            out.setId(Long.valueOf(NurseRosteringConstraintProviderTest.this.idSupplier.incrementAndGet()));
            out.setContractLineList(Collections.singletonList(contractLine));
            contractLine.setContract(out);
            out.setCode("Contract - " + out.getId());
            out.setDescription("Boolean " + this.contractLineType + " Contract");
            out.setWeekendDefinition(this.weekendDefinition);
            return out;
        }
    }

    private class MinMaxContractBuilder {
        private Integer minimumValue;
        private Integer maximumValue;
        private Integer minimumWeight;
        private Integer maximumWeight;
        private ContractLineType contractLineType;
        private WeekendDefinition weekendDefinition;

        public MinMaxContractBuilder(ContractLineType contractLineType) {
            this.contractLineType = contractLineType;
            this.weekendDefinition = WeekendDefinition.SATURDAY_SUNDAY;
            this.minimumWeight = 1;
            this.maximumWeight = 1;
        }

        public MinMaxContractBuilder withMinimum(Integer minimum) {
            this.minimumValue = minimum;
            return this;
        }

        public MinMaxContractBuilder withMaximum(Integer maximum) {
            this.maximumValue = maximum;
            return this;
        }

        public MinMaxContractBuilder withMinimumWeight(Integer weight) {
            this.minimumWeight = weight;
            return this;
        }

        public MinMaxContractBuilder withMaximumWeight(Integer weight) {
            this.maximumWeight = weight;
            return this;
        }

        public MinMaxContractBuilder withWeekendDefinition(WeekendDefinition weekendDefinition) {
            this.weekendDefinition = weekendDefinition;
            return this;
        }

        public Contract build() {
            MinMaxContractLine contractLine = new MinMaxContractLine();
            contractLine.setId(Long.valueOf(NurseRosteringConstraintProviderTest.this.idSupplier.incrementAndGet()));
            contractLine.setContractLineType(this.contractLineType);
            if (this.minimumValue != null) {
                contractLine.setMinimumValue(this.minimumValue.intValue());
                contractLine.setMinimumEnabled(true);
                contractLine.setMinimumWeight(this.minimumWeight.intValue());
            }
            if (this.maximumValue != null) {
                contractLine.setMaximumValue(this.maximumValue.intValue());
                contractLine.setMaximumEnabled(true);
                contractLine.setMaximumWeight(this.maximumWeight.intValue());
            }
            Contract out = new Contract();
            out.setId(Long.valueOf(NurseRosteringConstraintProviderTest.this.idSupplier.incrementAndGet()));
            out.setContractLineList(Collections.singletonList(contractLine));
            contractLine.setContract(out);
            out.setCode("Contract - " + out.getId());
            out.setDescription("Minimum/Maximum " + this.contractLineType + " Contract");
            out.setWeekendDefinition(this.weekendDefinition);
            return out;
        }
    }
}

