/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.taskassigning.swingui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JViewport;
import javax.swing.Scrollable;
import org.optaplanner.examples.common.swingui.SolutionPanel;
import org.optaplanner.examples.common.swingui.components.LabeledComboBoxRenderer;
import org.optaplanner.examples.taskassigning.domain.Employee;
import org.optaplanner.examples.taskassigning.domain.Skill;
import org.optaplanner.examples.taskassigning.domain.Task;
import org.optaplanner.examples.taskassigning.domain.TaskAssigningSolution;
import org.optaplanner.examples.taskassigning.domain.TaskOrEmployee;
import org.optaplanner.examples.taskassigning.swingui.TaskAssigningPanel;
import org.optaplanner.swing.impl.SwingUtils;
import org.optaplanner.swing.impl.TangoColorFactory;

public class TaskOverviewPanel
extends JPanel
implements Scrollable {
    public static final int HEADER_ROW_HEIGHT = 50;
    public static final int HEADER_COLUMN_WIDTH = 150;
    public static final int ROW_HEIGHT = 50;
    public static final int TIME_COLUMN_WIDTH = 60;
    private final TaskAssigningPanel taskAssigningPanel;
    private final ImageIcon[] affinityIcons;
    private final ImageIcon[] priorityIcons;
    private TangoColorFactory skillColorFactory;
    private int consumedDuration = 0;

    public TaskOverviewPanel(TaskAssigningPanel taskAssigningPanel) {
        this.taskAssigningPanel = taskAssigningPanel;
        this.affinityIcons = new ImageIcon[]{new ImageIcon(this.getClass().getResource("affinityNone.png")), new ImageIcon(this.getClass().getResource("affinityLow.png")), new ImageIcon(this.getClass().getResource("affinityMedium.png")), new ImageIcon(this.getClass().getResource("affinityHigh.png"))};
        this.priorityIcons = new ImageIcon[]{new ImageIcon(this.getClass().getResource("priorityMinor.png")), new ImageIcon(this.getClass().getResource("priorityMajor.png")), new ImageIcon(this.getClass().getResource("priorityCritical.png"))};
        this.setLayout(null);
        this.setMinimumSize(new Dimension(300, 400));
    }

    public void resetPanel(TaskAssigningSolution taskAssigningSolution) {
        this.removeAll();
        this.skillColorFactory = new TangoColorFactory();
        List<Employee> employeeList = taskAssigningSolution.getEmployeeList();
        HashMap<Employee, Integer> employeeIndexMap = new HashMap<Employee, Integer>(employeeList.size());
        int employeeIndex = 0;
        for (Employee employee : employeeList) {
            JLabel employeeLabel = new JLabel(employee.getLabel(), new TaskOrEmployeeIcon(employee), 2);
            employeeLabel.setOpaque(true);
            employeeLabel.setToolTipText(employee.getToolText());
            employeeLabel.setLocation(0, 50 + employeeIndex * 50);
            employeeLabel.setSize(150, 50);
            employeeLabel.setBorder(BorderFactory.createLineBorder(Color.BLACK, 1));
            this.add(employeeLabel);
            employeeIndexMap.put(employee, employeeIndex);
            ++employeeIndex;
        }
        int panelWidth = 150;
        int unassignedIndex = employeeList.size();
        for (Task task : taskAssigningSolution.getTaskList()) {
            int y;
            int x;
            JButton taskButton = this.createTaskButton(task);
            if (task.getEmployee() != null) {
                x = 150 + task.getStartTime();
                y = 50 + (Integer)employeeIndexMap.get(task.getEmployee()) * 50;
            } else {
                x = 150 + task.getReadyTime();
                y = 50 + unassignedIndex * 50;
                ++unassignedIndex;
            }
            if (x + taskButton.getWidth() > panelWidth) {
                panelWidth = x + taskButton.getWidth();
            }
            taskButton.setLocation(x, y);
            this.add(taskButton);
        }
        for (int x = 150; x < panelWidth; x += 60) {
            int minutes = (x - 150) % 600;
            int hours = 8 + minutes / 60;
            JLabel timeLabel = new JLabel((hours < 10 ? "0" : "") + hours + ":" + ((minutes %= 60) < 10 ? "0" : "") + minutes);
            timeLabel.setBorder(BorderFactory.createLineBorder(Color.BLACK, 1));
            timeLabel.setLocation(x, 0);
            timeLabel.setSize(60, 50);
            this.add(timeLabel);
        }
        if ((panelWidth - 150) % 60 != 0) {
            panelWidth = panelWidth - (panelWidth - 150) % 60 + 60;
        }
        Dimension size = new Dimension(panelWidth, 50 + unassignedIndex * 50);
        this.setSize(size);
        this.setPreferredSize(size);
        this.repaint();
    }

    public void setConsumedDuration(int consumedDuration) {
        this.consumedDuration = consumedDuration;
        this.repaint();
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        g.setColor(TangoColorFactory.ALUMINIUM_2);
        int lineX = 150 + this.consumedDuration;
        g.fillRect(150, 0, lineX, this.getHeight());
        g.setColor(Color.WHITE);
        g.fillRect(lineX, 0, this.getWidth(), this.getHeight());
    }

    private JButton createTaskButton(Task task) {
        JButton taskButton = SwingUtils.makeSmallButton((JButton)new JButton(new TaskAction(task)));
        taskButton.setBackground(task.isPinned() ? TangoColorFactory.ALUMINIUM_3 : TangoColorFactory.ALUMINIUM_1);
        taskButton.setHorizontalTextPosition(0);
        taskButton.setVerticalTextPosition(1);
        taskButton.setSize(task.getDuration(), 50);
        return taskButton;
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return SolutionPanel.PREFERRED_SCROLLABLE_VIEWPORT_SIZE;
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        return 20;
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        return 20;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        if (this.getParent() instanceof JViewport) {
            return this.getParent().getWidth() > this.getPreferredSize().width;
        }
        return false;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        if (this.getParent() instanceof JViewport) {
            return this.getParent().getHeight() > this.getPreferredSize().height;
        }
        return false;
    }

    private class TaskOrEmployeeIcon
    implements Icon {
        private static final int SKILL_ICON_WIDTH = 8;
        private static final int SKILL_ICON_HEIGHT = 16;
        private final ImageIcon priorityIcon;
        private final List<Color> skillColorList;
        private final ImageIcon affinityIcon;

        private TaskOrEmployeeIcon(Task task) {
            this.priorityIcon = TaskOverviewPanel.this.priorityIcons[task.getPriority().ordinal()];
            List<Skill> skillList = task.getTaskType().getRequiredSkillList();
            this.skillColorList = new ArrayList<Color>(skillList.size());
            for (Skill skill : skillList) {
                this.skillColorList.add(TaskOverviewPanel.this.skillColorFactory.pickColor((Object)skill));
            }
            this.affinityIcon = TaskOverviewPanel.this.affinityIcons[task.getAffinity().ordinal()];
        }

        private TaskOrEmployeeIcon(Employee employee) {
            this.priorityIcon = null;
            Set<Skill> skillSet = employee.getSkillSet();
            this.skillColorList = new ArrayList<Color>(skillSet.size());
            for (Skill skill : skillSet) {
                this.skillColorList.add(TaskOverviewPanel.this.skillColorFactory.pickColor((Object)skill));
            }
            this.affinityIcon = null;
        }

        @Override
        public int getIconWidth() {
            int width = 0;
            if (this.priorityIcon != null) {
                width += this.priorityIcon.getIconWidth();
            }
            width += this.skillColorList.size() * 8;
            if (this.affinityIcon != null) {
                width += this.affinityIcon.getIconWidth();
            }
            return width;
        }

        @Override
        public int getIconHeight() {
            int height = 16;
            if (this.priorityIcon != null && this.priorityIcon.getIconHeight() > height) {
                height = this.priorityIcon.getIconHeight();
            }
            if (this.affinityIcon != null && this.affinityIcon.getIconHeight() > height) {
                height = this.affinityIcon.getIconHeight();
            }
            return height;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            int innerX = x;
            if (this.priorityIcon != null) {
                this.priorityIcon.paintIcon(c, g, innerX, y);
                innerX += this.priorityIcon.getIconWidth();
            }
            for (Color skillColor : this.skillColorList) {
                g.setColor(skillColor);
                g.fillRect(innerX + 1, y + 1, 6, 14);
                g.setColor(TangoColorFactory.ALUMINIUM_5);
                g.drawRect(innerX + 1, y + 1, 6, 14);
                innerX += 8;
            }
            if (this.affinityIcon != null) {
                this.affinityIcon.paintIcon(c, g, innerX, y);
                innerX += this.affinityIcon.getIconWidth();
            }
        }
    }

    private class TaskAction
    extends AbstractAction {
        private final Task task;

        public TaskAction(Task task) {
            super(task.getCode(), new TaskOrEmployeeIcon(task));
            this.task = task;
            this.putValue("ShortDescription", task.getToolText());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JPanel listFieldsPanel = new JPanel(new GridLayout(2, 1));
            ArrayList<TaskOrEmployee> taskOrEmployeeList = new ArrayList<TaskOrEmployee>();
            taskOrEmployeeList.addAll(((TaskAssigningSolution)TaskOverviewPanel.this.taskAssigningPanel.getSolution()).getEmployeeList());
            taskOrEmployeeList.addAll(((TaskAssigningSolution)TaskOverviewPanel.this.taskAssigningPanel.getSolution()).getTaskList());
            JComboBox<Object> TaskOrEmployeeListField = new JComboBox<Object>(taskOrEmployeeList.toArray(new Object[taskOrEmployeeList.size() + 1]));
            LabeledComboBoxRenderer.applyToComboBox(TaskOrEmployeeListField);
            TaskOrEmployeeListField.setSelectedItem(this.task.getPreviousTaskOrEmployee());
            listFieldsPanel.add(TaskOrEmployeeListField);
            int result = JOptionPane.showConfirmDialog(TaskOverviewPanel.this.getRootPane(), listFieldsPanel, "Select previous task or employee for " + this.task.getLabel(), 2);
            if (result == 0) {
                TaskOrEmployee toTaskOrEmployee = (TaskOrEmployee)TaskOrEmployeeListField.getSelectedItem();
                TaskOverviewPanel.this.taskAssigningPanel.getSolutionBusiness().doChangeMove(this.task, "previousTaskOrEmployee", toTaskOrEmployee);
                TaskOverviewPanel.this.taskAssigningPanel.getSolverAndPersistenceFrame().resetScreen();
            }
        }
    }
}

