/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.pas.domain;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import org.optaplanner.core.api.domain.entity.PlanningEntity;
import org.optaplanner.core.api.domain.variable.PlanningVariable;
import org.optaplanner.examples.common.domain.AbstractPersistable;
import org.optaplanner.examples.pas.domain.AdmissionPart;
import org.optaplanner.examples.pas.domain.Bed;
import org.optaplanner.examples.pas.domain.Department;
import org.optaplanner.examples.pas.domain.Gender;
import org.optaplanner.examples.pas.domain.GenderLimitation;
import org.optaplanner.examples.pas.domain.Patient;
import org.optaplanner.examples.pas.domain.Room;
import org.optaplanner.examples.pas.domain.Specialism;
import org.optaplanner.examples.pas.domain.solver.BedDesignationDifficultyWeightFactory;
import org.optaplanner.examples.pas.domain.solver.BedStrengthComparator;

@PlanningEntity(difficultyWeightFactoryClass=BedDesignationDifficultyWeightFactory.class)
@XStreamAlias(value="BedDesignation")
public class BedDesignation
extends AbstractPersistable {
    private AdmissionPart admissionPart;
    private Bed bed;

    public BedDesignation() {
    }

    public BedDesignation(long id, AdmissionPart admissionPart, Bed bed) {
        super(id);
        this.admissionPart = admissionPart;
        this.bed = bed;
    }

    public AdmissionPart getAdmissionPart() {
        return this.admissionPart;
    }

    public void setAdmissionPart(AdmissionPart admissionPart) {
        this.admissionPart = admissionPart;
    }

    @PlanningVariable(nullable=true, valueRangeProviderRefs={"bedRange"}, strengthComparatorClass=BedStrengthComparator.class)
    public Bed getBed() {
        return this.bed;
    }

    public void setBed(Bed bed) {
        this.bed = bed;
    }

    public Patient getPatient() {
        return this.admissionPart.getPatient();
    }

    public Gender getPatientGender() {
        return this.admissionPart.getPatient().getGender();
    }

    public int getPatientAge() {
        return this.admissionPart.getPatient().getAge();
    }

    public Integer getPatientPreferredMaximumRoomCapacity() {
        return this.admissionPart.getPatient().getPreferredMaximumRoomCapacity();
    }

    public Specialism getAdmissionPartSpecialism() {
        return this.admissionPart.getSpecialism();
    }

    public int getFirstNightIndex() {
        return this.admissionPart.getFirstNight().getIndex();
    }

    public int getLastNightIndex() {
        return this.admissionPart.getLastNight().getIndex();
    }

    public int getAdmissionPartNightCount() {
        return this.admissionPart.getNightCount();
    }

    public Room getRoom() {
        if (this.bed == null) {
            return null;
        }
        return this.bed.getRoom();
    }

    public int getRoomCapacity() {
        if (this.bed == null) {
            return Integer.MIN_VALUE;
        }
        return this.bed.getRoom().getCapacity();
    }

    public Department getDepartment() {
        if (this.bed == null) {
            return null;
        }
        return this.bed.getRoom().getDepartment();
    }

    public GenderLimitation getRoomGenderLimitation() {
        if (this.bed == null) {
            return null;
        }
        return this.bed.getRoom().getGenderLimitation();
    }

    @Override
    public String toString() {
        return this.admissionPart.toString();
    }
}

