/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.common.experimental.impl;

import java.util.NavigableSet;
import java.util.Objects;
import java.util.stream.Collectors;
import org.optaplanner.examples.common.experimental.api.Break;
import org.optaplanner.examples.common.experimental.api.Sequence;
import org.optaplanner.examples.common.experimental.impl.ConsecutiveSetTree;

final class SequenceImpl<Value_, Difference_ extends Comparable<Difference_>>
implements Sequence<Value_, Difference_> {
    private final ConsecutiveSetTree<Value_, ?, Difference_> sourceTree;
    private Value_ firstItem;
    private Value_ lastItem;
    private Difference_ length;
    private NavigableSet<Value_> items;

    SequenceImpl(ConsecutiveSetTree<Value_, ?, Difference_> sourceTree, Value_ item) {
        this(sourceTree, item, item);
    }

    SequenceImpl(ConsecutiveSetTree<Value_, ?, Difference_> sourceTree, Value_ firstItem, Value_ lastItem) {
        this.sourceTree = sourceTree;
        this.firstItem = firstItem;
        this.lastItem = lastItem;
        this.length = null;
        this.items = null;
    }

    @Override
    public Value_ getFirstItem() {
        return this.firstItem;
    }

    @Override
    public Value_ getLastItem() {
        return this.lastItem;
    }

    @Override
    public Break<Value_, Difference_> getPreviousBreak() {
        return this.sourceTree.getBreakBefore(this.firstItem);
    }

    @Override
    public Break<Value_, Difference_> getNextBreak() {
        return this.sourceTree.getBreakAfter(this.lastItem);
    }

    @Override
    public boolean isFirst() {
        return this.firstItem == this.sourceTree.getItemSet().first();
    }

    @Override
    public boolean isLast() {
        return this.lastItem == this.sourceTree.getItemSet().last();
    }

    @Override
    public NavigableSet<Value_> getItems() {
        if (this.items == null) {
            this.items = this.sourceTree.getItemSet().subSet(this.firstItem, true, this.lastItem, true);
            return this.items;
        }
        return this.items;
    }

    @Override
    public int getCount() {
        return this.getItems().size();
    }

    @Override
    public Difference_ getLength() {
        if (this.length == null) {
            this.length = this.sourceTree.getSequenceLength(this);
            return this.length;
        }
        return this.length;
    }

    void setStart(Value_ item) {
        this.firstItem = item;
        this.invalidate();
    }

    void setEnd(Value_ item) {
        this.lastItem = item;
        this.invalidate();
    }

    void invalidate() {
        this.length = null;
        this.items = null;
    }

    SequenceImpl<Value_, Difference_> split(Value_ fromElement) {
        Iterable itemSet = this.getItems();
        Value_ newSequenceStart = itemSet.higher(fromElement);
        Value_ newSequenceEnd = this.lastItem;
        this.setEnd(itemSet.lower(fromElement));
        return new SequenceImpl<Value_, Difference_>(this.sourceTree, newSequenceStart, newSequenceEnd);
    }

    void merge(SequenceImpl<Value_, Difference_> other) {
        this.lastItem = other.lastItem;
        this.invalidate();
    }

    public String toString() {
        return this.getItems().stream().map(Objects::toString).collect(Collectors.joining(", ", "Sequence [", "]"));
    }
}

