/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.common.app;

import java.io.File;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.assertj.core.api.AbstractComparableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.DynamicTest;
import org.junit.jupiter.api.TestFactory;
import org.junit.jupiter.api.Timeout;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.ScoreExplanation;
import org.optaplanner.core.api.score.ScoreManager;
import org.optaplanner.core.api.score.constraint.ConstraintMatchTotal;
import org.optaplanner.core.api.solver.Solver;
import org.optaplanner.core.api.solver.SolverFactory;
import org.optaplanner.core.config.solver.EnvironmentMode;
import org.optaplanner.core.config.solver.SolverConfig;
import org.optaplanner.core.config.solver.termination.TerminationConfig;
import org.optaplanner.examples.common.app.CommonApp;
import org.optaplanner.examples.common.app.LoggingTest;
import org.optaplanner.persistence.common.api.domain.solution.SolutionFileIO;

public abstract class SolverPerformanceTest<Solution_, Score_ extends Score<Score_>>
extends LoggingTest {
    private static final String MOVE_THREAD_COUNTS_STRING = System.getProperty("moveThreadCounts");
    protected SolutionFileIO<Solution_> solutionFileIO;
    protected String solverConfigResource;

    private static Stream<String> moveThreadCounts() {
        return Optional.ofNullable(MOVE_THREAD_COUNTS_STRING).map(s -> Arrays.stream(s.split(","))).orElse(Stream.of("NONE"));
    }

    protected TestData<Score_> testData(String unsolvedDataFile, Score_ bestScoreLimit, EnvironmentMode environmentMode) {
        return new TestData<Score_>(unsolvedDataFile, bestScoreLimit, environmentMode);
    }

    @TestFactory
    @Timeout(value=600L)
    Stream<DynamicTest> runSpeedTest() {
        return SolverPerformanceTest.moveThreadCounts().flatMap(moveThreadCount -> this.testData().map(testData -> DynamicTest.dynamicTest((String)(testData.unsolvedDataFile.replaceFirst(".*/", "") + ", " + testData.environmentMode + ", threads: " + moveThreadCount), () -> this.runSpeedTest(new File(testData.unsolvedDataFile), testData.bestScoreLimit, testData.environmentMode, (String)moveThreadCount))));
    }

    @BeforeEach
    public void setUp() {
        CommonApp<Solution_> commonApp = this.createCommonApp();
        this.solutionFileIO = commonApp.createSolutionFileIO();
        this.solverConfigResource = commonApp.getSolverConfigResource();
    }

    protected abstract CommonApp<Solution_> createCommonApp();

    protected abstract Stream<TestData<Score_>> testData();

    private void runSpeedTest(File unsolvedDataFile, Score_ bestScoreLimit, EnvironmentMode environmentMode, String moveThreadCount) {
        SolverFactory<Solution_> solverFactory = this.buildSolverFactory(bestScoreLimit, environmentMode, moveThreadCount);
        Object problem = this.solutionFileIO.read(unsolvedDataFile);
        this.logger.info("Opened: {}", (Object)unsolvedDataFile);
        Solver solver = solverFactory.buildSolver();
        Object bestSolution = solver.solve(problem);
        this.assertScoreAndConstraintMatches(solverFactory, bestSolution, bestScoreLimit);
    }

    private SolverFactory<Solution_> buildSolverFactory(Score_ bestScoreLimit, EnvironmentMode environmentMode, String moveThreadCount) {
        SolverConfig solverConfig = SolverConfig.createFromXmlResource((String)this.solverConfigResource);
        solverConfig.withEnvironmentMode(environmentMode).withTerminationConfig(new TerminationConfig().withBestScoreLimit(bestScoreLimit.toString())).withMoveThreadCount(moveThreadCount);
        return SolverFactory.create((SolverConfig)solverConfig);
    }

    private void assertScoreAndConstraintMatches(SolverFactory<Solution_> solverFactory, Solution_ bestSolution, Score_ bestScoreLimit) {
        Assertions.assertThat(bestSolution).isNotNull();
        ScoreManager scoreManager = ScoreManager.create(solverFactory);
        Score bestScore = scoreManager.updateScore(bestSolution);
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)bestScore).as("The bestScore (" + bestScore + ") must be at least the bestScoreLimit (" + bestScoreLimit + ").", new Object[0])).isGreaterThanOrEqualTo(bestScoreLimit);
        ScoreExplanation scoreExplanation = scoreManager.explainScore(bestSolution);
        Map constraintMatchTotals = scoreExplanation.getConstraintMatchTotalMap();
        Assertions.assertThat((Map)constraintMatchTotals).isNotNull();
        Assertions.assertThat((Comparable)constraintMatchTotals.values().stream().map(ConstraintMatchTotal::getScore).reduce(Score::add).orElse(bestScore.zero())).isEqualTo((Object)scoreExplanation.getScore());
        Assertions.assertThat((Map)scoreExplanation.getIndictmentMap()).isNotNull();
    }

    protected static class TestData<Score_ extends Score<Score_>> {
        private final String unsolvedDataFile;
        private final Score_ bestScoreLimit;
        private final EnvironmentMode environmentMode;

        private TestData(String unsolvedDataFile, Score_ bestScoreLimit, EnvironmentMode environmentMode) {
            this.unsolvedDataFile = unsolvedDataFile;
            this.bestScoreLimit = bestScoreLimit;
            this.environmentMode = environmentMode;
        }
    }
}

