/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.common.experimental.impl;

import java.time.Duration;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.IterableAssert;
import org.junit.jupiter.api.Test;
import org.optaplanner.examples.common.experimental.api.Break;
import org.optaplanner.examples.common.experimental.api.ConsecutiveInfo;
import org.optaplanner.examples.common.experimental.api.Sequence;
import org.optaplanner.examples.common.experimental.impl.BreakImpl;
import org.optaplanner.examples.common.experimental.impl.ConsecutiveSetTree;
import org.optaplanner.examples.common.experimental.impl.IterableList;

public class ConsecutiveSetTreeTest {
    private ConsecutiveSetTree<Integer, Integer, Integer> getIntegerConsecutiveSetTree() {
        return new ConsecutiveSetTree(i -> i, (a, b) -> b - a, Integer::sum, (Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(0));
    }

    private <ValueType_, DifferenceType_ extends Comparable<DifferenceType_>> Break<ValueType_, DifferenceType_> getBreak(ConsecutiveInfo<ValueType_, DifferenceType_> consecutiveData, ValueType_ start, ValueType_ end, DifferenceType_ length) {
        Sequence previousSequence = null;
        Sequence nextSequence = null;
        for (Sequence sequence : consecutiveData.getConsecutiveSequences()) {
            if (sequence.getLastItem().equals(start)) {
                previousSequence = sequence;
            }
            if (!sequence.getFirstItem().equals(end)) continue;
            nextSequence = sequence;
        }
        if (previousSequence == null || nextSequence == null) {
            throw new IllegalStateException("Unable to find sequence with provided start/end points in (" + consecutiveData.getConsecutiveSequences() + ")");
        }
        return new BreakImpl(previousSequence, nextSequence, length);
    }

    @Test
    public void testNonconsecutiveNumbers() {
        ConsecutiveSetTree<Integer, Integer, Integer> tree = this.getIntegerConsecutiveSetTree();
        tree.add((Object)1);
        tree.add((Object)3);
        tree.add((Object)7);
        IterableList sequenceList = new IterableList(tree.getConsecutiveSequences());
        Assertions.assertThat(sequenceList).hasSize(3);
        IterableList breakList = new IterableList(tree.getBreaks());
        Assertions.assertThat(breakList).hasSize(2);
        Assertions.assertThat((Iterable)tree.getConsecutiveSequences()).allMatch(seq -> seq.getCount() == 1);
        Assertions.assertThat((Object)((Break)breakList.get(0))).usingRecursiveComparison().isEqualTo(this.getBreak((ConsecutiveInfo)tree, 1, 3, 2));
        Assertions.assertThat((Object)((Break)breakList.get(1))).usingRecursiveComparison().isEqualTo(this.getBreak((ConsecutiveInfo)tree, 3, 7, 4));
    }

    @Test
    public void testConsecutiveNumbers() {
        ConsecutiveSetTree<Integer, Integer, Integer> tree = this.getIntegerConsecutiveSetTree();
        tree.add((Object)1);
        tree.add((Object)2);
        tree.add((Object)3);
        tree.add((Object)5);
        tree.add((Object)6);
        tree.add((Object)7);
        tree.add((Object)8);
        IterableList sequenceList = new IterableList(tree.getConsecutiveSequences());
        Assertions.assertThat(sequenceList).hasSize(2);
        IterableList breakList = new IterableList(tree.getBreaks());
        Assertions.assertThat(breakList).hasSize(1);
        Assertions.assertThat((int)((Sequence)sequenceList.get(0)).getCount()).isEqualTo(3);
        Assertions.assertThat((int)((Sequence)sequenceList.get(1)).getCount()).isEqualTo(4);
        Assertions.assertThat((Object)((Break)breakList.get(0))).usingRecursiveComparison().isEqualTo(this.getBreak((ConsecutiveInfo)tree, 3, 5, 2));
    }

    @Test
    public void testDuplicateNumbers() {
        ConsecutiveSetTree<Integer, Integer, Integer> tree = this.getIntegerConsecutiveSetTree();
        tree.add((Object)1);
        tree.add((Object)2);
        tree.add((Object)3);
        tree.add((Object)3);
        tree.add((Object)3);
        IterableList sequenceList = new IterableList(tree.getConsecutiveSequences());
        Assertions.assertThat(sequenceList).hasSize(1);
        IterableList breakList = new IterableList(tree.getBreaks());
        Assertions.assertThat(breakList).hasSize(0);
        Assertions.assertThat((int)((Sequence)sequenceList.get(0)).getCount()).isEqualTo(3);
        Assertions.assertThat((Iterable)tree.getBreaks()).hasSize(0);
        tree.remove((Object)3);
        Assertions.assertThat(sequenceList).hasSize(1);
        Assertions.assertThat((int)((Sequence)sequenceList.get(0)).getCount()).isEqualTo(3);
        Assertions.assertThat(breakList).hasSize(0);
        tree.remove((Object)3);
        Assertions.assertThat(sequenceList).hasSize(1);
        Assertions.assertThat((int)((Sequence)sequenceList.get(0)).getCount()).isEqualTo(3);
        Assertions.assertThat(breakList).hasSize(0);
        tree.remove((Object)3);
        Assertions.assertThat(sequenceList).hasSize(1);
        Assertions.assertThat((int)((Sequence)sequenceList.get(0)).getCount()).isEqualTo(2);
        Assertions.assertThat((Iterable)tree.getBreaks()).hasSize(0);
    }

    @Test
    public void testConsecutiveReverseNumbers() {
        ConsecutiveSetTree<Integer, Integer, Integer> tree = this.getIntegerConsecutiveSetTree();
        tree.add((Object)3);
        tree.add((Object)2);
        tree.add((Object)1);
        tree.add((Object)8);
        tree.add((Object)7);
        tree.add((Object)6);
        tree.add((Object)5);
        IterableList sequenceList = new IterableList(tree.getConsecutiveSequences());
        Assertions.assertThat(sequenceList).hasSize(2);
        IterableList breakList = new IterableList(tree.getBreaks());
        Assertions.assertThat(breakList).hasSize(1);
        Assertions.assertThat((int)((Sequence)sequenceList.get(0)).getCount()).isEqualTo(3);
        Assertions.assertThat((int)((Sequence)sequenceList.get(1)).getCount()).isEqualTo(4);
        Assertions.assertThat((Object)((Break)breakList.get(0))).usingRecursiveComparison().isEqualTo(this.getBreak((ConsecutiveInfo)tree, 3, 5, 2));
    }

    @Test
    public void testJoinOfTwoChains() {
        ConsecutiveSetTree<Integer, Integer, Integer> tree = this.getIntegerConsecutiveSetTree();
        tree.add((Object)1);
        tree.add((Object)2);
        tree.add((Object)3);
        tree.add((Object)5);
        tree.add((Object)6);
        tree.add((Object)7);
        tree.add((Object)8);
        tree.add((Object)4);
        IterableList sequenceList = new IterableList(tree.getConsecutiveSequences());
        Assertions.assertThat(sequenceList).hasSize(1);
        Assertions.assertThat((int)((Sequence)sequenceList.get(0)).getCount()).isEqualTo(8);
        Assertions.assertThat((Iterable)tree.getBreaks()).hasSize(0);
    }

    @Test
    public void testBreakOfChain() {
        ConsecutiveSetTree<Integer, Integer, Integer> tree = this.getIntegerConsecutiveSetTree();
        tree.add((Object)1);
        tree.add((Object)2);
        tree.add((Object)3);
        tree.add((Object)4);
        tree.add((Object)5);
        tree.add((Object)6);
        tree.add((Object)7);
        tree.remove((Object)4);
        IterableList sequenceList = new IterableList(tree.getConsecutiveSequences());
        Assertions.assertThat(sequenceList).hasSize(2);
        IterableList breakList = new IterableList(tree.getBreaks());
        Assertions.assertThat(breakList).hasSize(1);
        Assertions.assertThat(sequenceList).hasSize(2);
        Assertions.assertThat((int)((Sequence)sequenceList.get(0)).getCount()).isEqualTo(3);
        Assertions.assertThat((int)((Sequence)sequenceList.get(1)).getCount()).isEqualTo(3);
        Assertions.assertThat(breakList).hasSize(1);
        Assertions.assertThat((Object)((Break)breakList.get(0))).usingRecursiveComparison().isEqualTo(this.getBreak((ConsecutiveInfo)tree, 3, 5, 2));
    }

    @Test
    public void testChainRemoval() {
        ConsecutiveSetTree<Integer, Integer, Integer> tree = this.getIntegerConsecutiveSetTree();
        tree.add((Object)1);
        tree.add((Object)2);
        tree.add((Object)3);
        tree.add((Object)5);
        tree.add((Object)6);
        tree.add((Object)7);
        tree.remove((Object)2);
        tree.remove((Object)1);
        tree.remove((Object)3);
        IterableList sequenceList = new IterableList(tree.getConsecutiveSequences());
        Assertions.assertThat(sequenceList).hasSize(1);
        Assertions.assertThat((int)((Sequence)sequenceList.get(0)).getCount()).isEqualTo(3);
        Assertions.assertThat((Iterable)tree.getBreaks()).hasSize(0);
    }

    @Test
    public void testShorteningOfChain() {
        ConsecutiveSetTree<Integer, Integer, Integer> tree = this.getIntegerConsecutiveSetTree();
        tree.add((Object)1);
        tree.add((Object)2);
        tree.add((Object)3);
        tree.add((Object)4);
        tree.add((Object)5);
        tree.add((Object)6);
        tree.add((Object)7);
        tree.remove((Object)7);
        IterableList sequenceList = new IterableList(tree.getConsecutiveSequences());
        Assertions.assertThat(sequenceList).hasSize(1);
        Assertions.assertThat((int)((Sequence)sequenceList.get(0)).getCount()).isEqualTo(6);
        Assertions.assertThat((Iterable)tree.getBreaks()).hasSize(0);
        tree.remove((Object)1);
        Assertions.assertThat(sequenceList).hasSize(1);
        Assertions.assertThat((int)((Sequence)sequenceList.get(0)).getCount()).isEqualTo(5);
        Assertions.assertThat((Iterable)tree.getBreaks()).hasSize(0);
    }

    @Test
    public void testRandomSequences() {
        Random random = new Random(1L);
        TreeMap<Integer, Integer> valueToCountMap = new TreeMap<Integer, Integer>();
        ConsecutiveSetTree tree = new ConsecutiveSetTree(i -> i, (a, b) -> b - a, Integer::sum, (Comparable)Integer.valueOf(2), (Comparable)Integer.valueOf(0));
        for (int i2 = 0; i2 < 1000; ++i2) {
            String op;
            int value = random.nextInt(64);
            if (valueToCountMap.containsKey(value) && random.nextDouble() < 0.75) {
                op = valueToCountMap.keySet().stream().map(Object::toString).collect(Collectors.joining(", ", "Removing " + value + " from [", "]"));
                valueToCountMap.computeIfPresent(value, (key, count) -> count == 1 ? null : Integer.valueOf(count - 1));
                tree.remove((Object)value);
            } else {
                op = valueToCountMap.keySet().stream().map(Object::toString).collect(Collectors.joining(", ", "Adding " + value + " to [", "]"));
                valueToCountMap.merge(value, 1, Integer::sum);
                tree.add((Object)value);
            }
            ConsecutiveSetTree freshTree = new ConsecutiveSetTree(val -> val, (a, b) -> b - a, Integer::sum, (Comparable)Integer.valueOf(2), (Comparable)Integer.valueOf(0));
            for (Map.Entry entry : valueToCountMap.entrySet()) {
                IntStream.range(0, (Integer)entry.getValue()).map(index -> (Integer)entry.getKey()).forEach(arg_0 -> ((ConsecutiveSetTree)freshTree).add(arg_0));
            }
            ((IterableAssert)Assertions.assertThat((Iterable)tree.getConsecutiveSequences()).as("Mismatched Sequence: " + op, new Object[0])).usingRecursiveComparison().ignoringFields(new String[]{"sourceTree"}).isEqualTo((Object)freshTree.getConsecutiveSequences());
            ((IterableAssert)Assertions.assertThat((Iterable)tree.getBreaks()).as("Mismatched Break: " + op, new Object[0])).usingRecursiveComparison().isEqualTo((Object)freshTree.getBreaks());
        }
    }

    @Test
    public void testRandomSequencesWithDuplicates() {
        Random random = new Random(1L);
        TreeMap<Integer, Integer> valueToCountMap = new TreeMap<Integer, Integer>(Comparator.comparing(Math::abs).thenComparing(System::identityHashCode));
        ConsecutiveSetTree tree = new ConsecutiveSetTree(Math::abs, (a, b) -> b - a, Integer::sum, (Comparable)Integer.valueOf(2), (Comparable)Integer.valueOf(0));
        for (int i = 0; i < 1000; ++i) {
            String op;
            int value = random.nextInt(64) - 32;
            if (valueToCountMap.containsKey(value) && random.nextDouble() < 0.75) {
                op = valueToCountMap.keySet().stream().map(Object::toString).collect(Collectors.joining(", ", "Removing " + value + " from [", "]"));
                valueToCountMap.computeIfPresent(value, (key, count) -> count == 1 ? null : Integer.valueOf(count - 1));
                tree.remove((Object)value);
            } else {
                op = valueToCountMap.keySet().stream().map(Object::toString).collect(Collectors.joining(", ", "Adding " + value + " to [", "]"));
                valueToCountMap.merge(value, 1, Integer::sum);
                tree.add((Object)value);
            }
            ConsecutiveSetTree freshTree = new ConsecutiveSetTree(Math::abs, (a, b) -> b - a, Integer::sum, (Comparable)Integer.valueOf(2), (Comparable)Integer.valueOf(0));
            for (Map.Entry entry : valueToCountMap.entrySet()) {
                IntStream.range(0, (Integer)entry.getValue()).map(index -> (Integer)entry.getKey()).forEach(arg_0 -> ((ConsecutiveSetTree)freshTree).add(arg_0));
            }
            ((IterableAssert)Assertions.assertThat((Iterable)tree.getConsecutiveSequences()).as("Mismatched Sequence: " + op, new Object[0])).usingRecursiveComparison().ignoringFields(new String[]{"sourceTree"}).isEqualTo((Object)freshTree.getConsecutiveSequences());
            ((IterableAssert)Assertions.assertThat((Iterable)tree.getBreaks()).as("Mismatched Break: " + op, new Object[0])).usingRecursiveComparison().isEqualTo((Object)freshTree.getBreaks());
        }
    }

    @Test
    public void testTimeslotConsecutive() {
        ConsecutiveSetTree tree = new ConsecutiveSetTree(ts -> ts.from, Duration::between, Duration::plus, (Comparable)Duration.ofDays(1L), (Comparable)Duration.ZERO);
        Timeslot t1 = new Timeslot(0, 1);
        Timeslot t2 = new Timeslot(1, 2);
        Timeslot t3 = new Timeslot(3, 4);
        Timeslot t4 = new Timeslot(4, 5);
        Timeslot t5 = new Timeslot(5, 6);
        tree.add((Object)t4);
        tree.add((Object)t2);
        tree.add((Object)t4);
        tree.add((Object)t3);
        tree.add((Object)t1);
        tree.add((Object)t5);
        Iterable sequenceList = tree.getConsecutiveSequences();
        Assertions.assertThat((Iterable)sequenceList).hasSize(2);
        Iterator sequenceIterator = sequenceList.iterator();
        Iterable breakList = tree.getBreaks();
        Iterator breakIterator = breakList.iterator();
        Assertions.assertThat((Iterable)breakList).hasSize(1);
        Assertions.assertThat((Iterable)sequenceList).hasSize(2);
        Assertions.assertThat((Iterable)((Sequence)sequenceIterator.next()).getItems()).containsExactly((Object[])new Timeslot[]{t1, t2});
        Assertions.assertThat((Iterable)((Sequence)sequenceIterator.next()).getItems()).containsExactly((Object[])new Timeslot[]{t3, t4, t5});
        Assertions.assertThat((Iterable)breakList).hasSize(1);
        Assertions.assertThat((Object)((Break)breakIterator.next())).usingRecursiveComparison().isEqualTo(this.getBreak((ConsecutiveInfo)tree, (Object)t2, (Object)t3, (Comparable)Duration.ofDays(2L)));
    }

    private static class Timeslot {
        OffsetDateTime from;
        OffsetDateTime to;

        public Timeslot(int fromIndex, int toIndex) {
            this.from = OffsetDateTime.of(2000, 1, fromIndex + 1, 0, 0, 0, 0, ZoneOffset.UTC);
            this.to = OffsetDateTime.of(2000, 1, toIndex + 1, 0, 0, 0, 0, ZoneOffset.UTC);
        }
    }
}

