/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.cheaptime.score;

import java.util.function.Function;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.buildin.hardmediumsoftlong.HardMediumSoftLongScore;
import org.optaplanner.core.api.score.stream.Constraint;
import org.optaplanner.core.api.score.stream.ConstraintCollectors;
import org.optaplanner.core.api.score.stream.ConstraintFactory;
import org.optaplanner.core.api.score.stream.ConstraintProvider;
import org.optaplanner.core.api.score.stream.Joiners;
import org.optaplanner.examples.cheaptime.domain.Machine;
import org.optaplanner.examples.cheaptime.domain.Period;
import org.optaplanner.examples.cheaptime.domain.Resource;
import org.optaplanner.examples.cheaptime.domain.TaskAssignment;
import org.optaplanner.examples.cheaptime.score.CheapTimeCostCalculator;
import org.optaplanner.examples.common.experimental.ExperimentalConstraintCollectors;
import org.optaplanner.examples.common.experimental.api.ConsecutiveIntervalInfo;

public class CheapTimeConstraintProvider
implements ConstraintProvider {
    public Constraint[] defineConstraints(ConstraintFactory constraintFactory) {
        return new Constraint[]{this.startTimeLimitsFrom(constraintFactory), this.startTimeLimitsTo(constraintFactory), this.maximumCapacity(constraintFactory), this.activeMachinePowerCost(constraintFactory), this.activeMachineSpinUpAndDownCost(constraintFactory), this.idleCosts(constraintFactory), this.taskPowerCost(constraintFactory), this.startEarly(constraintFactory)};
    }

    protected Constraint startTimeLimitsFrom(ConstraintFactory constraintFactory) {
        return constraintFactory.forEach(TaskAssignment.class).filter(taskAssignment -> taskAssignment.getStartPeriod() < taskAssignment.getTask().getStartPeriodRangeFrom()).penalizeLong("Task starts too early", (Score)HardMediumSoftLongScore.ONE_HARD, taskAssignment -> taskAssignment.getTask().getStartPeriodRangeFrom() - taskAssignment.getStartPeriod());
    }

    protected Constraint startTimeLimitsTo(ConstraintFactory constraintFactory) {
        return constraintFactory.forEach(TaskAssignment.class).filter(taskAssignment -> taskAssignment.getStartPeriod() >= taskAssignment.getTask().getStartPeriodRangeTo()).penalizeLong("Task starts too late", (Score)HardMediumSoftLongScore.ONE_HARD, taskAssignment -> taskAssignment.getStartPeriod() - taskAssignment.getTask().getStartPeriodRangeTo());
    }

    protected Constraint maximumCapacity(ConstraintFactory constraintFactory) {
        return constraintFactory.forEach(TaskAssignment.class).join(Resource.class, Joiners.filtering((taskAssignment, resource) -> taskAssignment.getTask().getUsage((Resource)resource) > 0)).join(Period.class, Joiners.lessThanOrEqual((taskAssignment, resource) -> taskAssignment.getStartPeriod(), Period::getIndex), Joiners.greaterThan((taskAssignment, resource) -> taskAssignment.getEndPeriod(), Period::getIndex)).groupBy((taskAssignment, resource, period) -> period, (taskAssignment, resource, period) -> resource, (taskAssignment, resource, period) -> taskAssignment.getMachine(), ConstraintCollectors.sum((taskAssignment, resource, period) -> taskAssignment.getTask().getUsage((Resource)resource))).filter((period, resource, machine, usage) -> machine.getCapacity((Resource)resource) < usage).penalizeLong("Maximum resource capacity", (Score)HardMediumSoftLongScore.ONE_HARD, (period, resource, machine, usage) -> usage - machine.getCapacity((Resource)resource));
    }

    protected Constraint activeMachinePowerCost(ConstraintFactory constraintFactory) {
        return constraintFactory.forEach(Period.class).join(Machine.class).ifExists(TaskAssignment.class, Joiners.equal((period, machine) -> machine, TaskAssignment::getMachine), Joiners.greaterThanOrEqual((period, machine) -> period.getIndex(), TaskAssignment::getStartPeriod), Joiners.lessThan((period, machine) -> period.getIndex(), TaskAssignment::getEndPeriod)).penalizeLong("Active machine power cost", (Score)HardMediumSoftLongScore.ONE_MEDIUM, (period, machine) -> CheapTimeCostCalculator.multiplyTwoMicros(machine.getPowerConsumptionMicros(), period.getPowerPriceMicros()));
    }

    protected Constraint activeMachineSpinUpAndDownCost(ConstraintFactory constraintFactory) {
        return constraintFactory.forEach(Machine.class).ifExists(TaskAssignment.class, Joiners.equal(Function.identity(), TaskAssignment::getMachine)).penalizeLong("Active machine spin up and down cost", (Score)HardMediumSoftLongScore.ONE_MEDIUM, Machine::getSpinUpDownCostMicros);
    }

    protected Constraint idleCosts(ConstraintFactory constraintFactory) {
        return constraintFactory.forEach(TaskAssignment.class).groupBy(TaskAssignment::getMachine, ExperimentalConstraintCollectors.consecutiveIntervals(TaskAssignment::getStartPeriod, TaskAssignment::getEndPeriod, (a, b) -> b - a)).flattenLast(ConsecutiveIntervalInfo::getBreaks).join(Period.class, Joiners.lessThanOrEqual((machine, brk) -> (Integer)brk.getPreviousIntervalClusterEnd(), Period::getIndex), Joiners.greaterThan((machine, brk) -> (Integer)brk.getNextIntervalClusterStart(), Period::getIndex)).groupBy((machine, brk, idlePeriod) -> machine, (machine, brk, idlePeriod) -> brk, ConstraintCollectors.sumLong((machine, brk, idlePeriod) -> idlePeriod.getPowerPriceMicros())).penalizeLong("Machine idle costs", (Score)HardMediumSoftLongScore.ONE_MEDIUM, (machine, brk, powerCost) -> {
            long idleCost = CheapTimeCostCalculator.multiplyTwoMicros(machine.getPowerConsumptionMicros(), powerCost);
            return Math.min(idleCost, machine.getSpinUpDownCostMicros());
        });
    }

    protected Constraint taskPowerCost(ConstraintFactory constraintFactory) {
        return constraintFactory.forEach(TaskAssignment.class).join(Period.class, Joiners.lessThanOrEqual(TaskAssignment::getStartPeriod, Period::getIndex), Joiners.greaterThan(TaskAssignment::getEndPeriod, Period::getIndex)).penalizeLong("Task power cost", (Score)HardMediumSoftLongScore.ONE_MEDIUM, (taskAssignment, period) -> CheapTimeCostCalculator.multiplyTwoMicros(taskAssignment.getTask().getPowerConsumptionMicros(), period.getPowerPriceMicros()));
    }

    protected Constraint startEarly(ConstraintFactory constraintFactory) {
        return constraintFactory.forEach(TaskAssignment.class).penalize("Prefer early task start", (Score)HardMediumSoftLongScore.ONE_SOFT, TaskAssignment::getStartPeriod);
    }
}

