/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.common.business;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.SwingUtilities;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.ScoreManager;
import org.optaplanner.core.api.score.constraint.ConstraintMatchTotal;
import org.optaplanner.core.api.score.constraint.Indictment;
import org.optaplanner.core.api.solver.Solver;
import org.optaplanner.core.api.solver.SolverFactory;
import org.optaplanner.core.api.solver.change.ProblemChange;
import org.optaplanner.core.api.solver.change.ProblemChangeDirector;
import org.optaplanner.core.impl.domain.variable.descriptor.GenuineVariableDescriptor;
import org.optaplanner.core.impl.domain.variable.inverserelation.SingletonInverseVariableDemand;
import org.optaplanner.core.impl.domain.variable.inverserelation.SingletonInverseVariableSupply;
import org.optaplanner.core.impl.domain.variable.supply.Demand;
import org.optaplanner.core.impl.domain.variable.supply.SupplyManager;
import org.optaplanner.core.impl.heuristic.move.Move;
import org.optaplanner.core.impl.heuristic.selector.move.generic.ChangeMove;
import org.optaplanner.core.impl.heuristic.selector.move.generic.chained.ChainedChangeMove;
import org.optaplanner.core.impl.score.constraint.DefaultConstraintMatchTotal;
import org.optaplanner.core.impl.score.director.InnerScoreDirector;
import org.optaplanner.core.impl.solver.DefaultSolverFactory;
import org.optaplanner.core.impl.solver.change.DefaultProblemChangeDirector;
import org.optaplanner.examples.common.app.CommonApp;
import org.optaplanner.examples.common.business.ProblemFileComparator;
import org.optaplanner.examples.common.persistence.AbstractSolutionExporter;
import org.optaplanner.examples.common.persistence.AbstractSolutionImporter;
import org.optaplanner.examples.common.swingui.SolverAndPersistenceFrame;
import org.optaplanner.persistence.common.api.domain.solution.SolutionFileIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolutionBusiness<Solution_, Score_ extends Score<Score_>> {
    private static final ProblemFileComparator FILE_COMPARATOR = new ProblemFileComparator();
    private static final Logger LOGGER = LoggerFactory.getLogger(SolutionBusiness.class);
    private final CommonApp<Solution_> app;
    private File dataDir;
    private SolutionFileIO<Solution_> solutionFileIO;
    private Set<AbstractSolutionImporter<Solution_>> importers;
    private Set<AbstractSolutionExporter<Solution_>> exporters;
    private File importDataDir;
    private File unsolvedDataDir;
    private File solvedDataDir;
    private File exportDataDir;
    private volatile Solver<Solution_> solver;
    private String solutionFileName = null;
    private InnerScoreDirector<Solution_, Score_> guiScoreDirector;
    private ProblemChangeDirector problemChangeDirector;
    private ScoreManager<Solution_, Score_> scoreManager;
    private final AtomicReference<Solution_> skipToBestSolutionRef = new AtomicReference();

    public static String getBaseFileName(File file) {
        return SolutionBusiness.getBaseFileName(file.getName());
    }

    public static String getBaseFileName(String name) {
        int indexOfLastDot = name.lastIndexOf(46);
        if (indexOfLastDot > 0) {
            return name.substring(0, indexOfLastDot);
        }
        return name;
    }

    public SolutionBusiness(CommonApp<Solution_> app) {
        this.app = app;
    }

    public String getAppName() {
        return this.app.getName();
    }

    public String getAppDescription() {
        return this.app.getDescription();
    }

    public String getAppIconResource() {
        return this.app.getIconResource();
    }

    public File getDataDir() {
        return this.dataDir;
    }

    public void setDataDir(File dataDir) {
        this.dataDir = dataDir;
    }

    public SolutionFileIO<Solution_> getSolutionFileIO() {
        return this.solutionFileIO;
    }

    public void setSolutionFileIO(SolutionFileIO<Solution_> solutionFileIO) {
        this.solutionFileIO = solutionFileIO;
    }

    public Set<AbstractSolutionImporter<Solution_>> getImporters() {
        return this.importers;
    }

    public void setImporters(Set<AbstractSolutionImporter<Solution_>> importers) {
        this.importers = importers;
    }

    public void setExporters(Set<AbstractSolutionExporter<Solution_>> exporters) {
        if (exporters == null) {
            throw new IllegalArgumentException("Passed exporters must not be null");
        }
        this.exporters = exporters;
    }

    public void addExporter(AbstractSolutionExporter<Solution_> exporter) {
        this.exporters.add(exporter);
    }

    public Set<AbstractSolutionExporter<Solution_>> getExporters() {
        return this.exporters;
    }

    public boolean hasImporter() {
        return !this.importers.isEmpty();
    }

    public boolean hasExporter() {
        return this.exporters != null && this.exporters.size() > 0;
    }

    public void updateDataDirs() {
        if (this.hasImporter()) {
            this.importDataDir = new File(this.dataDir, "import");
            if (!this.importDataDir.exists()) {
                throw new IllegalStateException("The directory importDataDir (" + this.importDataDir.getAbsolutePath() + ") does not exist.");
            }
        }
        this.unsolvedDataDir = new File(this.dataDir, "unsolved");
        if (!this.unsolvedDataDir.exists()) {
            throw new IllegalStateException("The directory unsolvedDataDir (" + this.unsolvedDataDir.getAbsolutePath() + ") does not exist.");
        }
        this.solvedDataDir = new File(this.dataDir, "solved");
        if (!this.solvedDataDir.exists() && !this.solvedDataDir.mkdir()) {
            throw new IllegalStateException("The directory solvedDataDir (" + this.solvedDataDir.getAbsolutePath() + ") does not exist and could not be created.");
        }
        if (this.hasExporter()) {
            this.exportDataDir = new File(this.dataDir, "export");
            if (!this.exportDataDir.exists() && !this.exportDataDir.mkdir()) {
                throw new IllegalStateException("The directory exportDataDir (" + this.exportDataDir.getAbsolutePath() + ") does not exist and could not be created.");
            }
        }
    }

    public File getImportDataDir() {
        return this.importDataDir;
    }

    public File getUnsolvedDataDir() {
        return this.unsolvedDataDir;
    }

    public File getSolvedDataDir() {
        return this.solvedDataDir;
    }

    public File getExportDataDir() {
        return this.exportDataDir;
    }

    public void setSolver(SolverFactory<Solution_> solverFactory) {
        this.solver = solverFactory.buildSolver();
        this.scoreManager = ScoreManager.create(solverFactory);
        this.guiScoreDirector = ((DefaultSolverFactory)solverFactory).getScoreDirectorFactory().buildScoreDirector();
        this.problemChangeDirector = new DefaultProblemChangeDirector(this.guiScoreDirector);
    }

    public List<File> getUnsolvedFileList() {
        return this.getFileList(this.unsolvedDataDir, this.solutionFileIO.getInputFileExtension());
    }

    private List<File> getFileList(File dataDir, String extension) {
        List<File> list;
        block8: {
            Stream<Path> paths = Files.walk(dataDir.toPath(), FileVisitOption.FOLLOW_LINKS);
            try {
                list = paths.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(path -> path.toString().endsWith("." + extension)).map(Path::toFile).sorted(FILE_COMPARATOR).collect(Collectors.toList());
                if (paths == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (paths != null) {
                        try {
                            paths.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new IllegalStateException("Error while crawling data directory (" + dataDir + ").", e);
                }
            }
            paths.close();
        }
        return list;
    }

    public List<File> getSolvedFileList() {
        return this.getFileList(this.solvedDataDir, this.solutionFileIO.getOutputFileExtension());
    }

    public Solution_ getSolution() {
        return (Solution_)this.guiScoreDirector.getWorkingSolution();
    }

    public void setSolution(Solution_ solution) {
        this.guiScoreDirector.setWorkingSolution(solution);
    }

    public String getSolutionFileName() {
        return this.solutionFileName;
    }

    public void setSolutionFileName(String solutionFileName) {
        this.solutionFileName = solutionFileName;
    }

    public Score_ getScore() {
        return (Score_)this.scoreManager.updateScore(this.getSolution());
    }

    public boolean isSolving() {
        return this.solver.isSolving();
    }

    public void registerForBestSolutionChanges(SolverAndPersistenceFrame<Solution_> solverAndPersistenceFrame) {
        this.solver.addEventListener(event -> {
            if (this.solver.isEveryProblemChangeProcessed()) {
                Object newBestSolution = event.getNewBestSolution();
                this.skipToBestSolutionRef.set(newBestSolution);
                SwingUtilities.invokeLater(() -> {
                    Solution_ skipToBestSolution = this.skipToBestSolutionRef.get();
                    if (newBestSolution != skipToBestSolution) {
                        return;
                    }
                    this.guiScoreDirector.setWorkingSolution(newBestSolution);
                    solverAndPersistenceFrame.bestSolutionChanged();
                });
            }
        });
    }

    public boolean isConstraintMatchEnabled() {
        return this.guiScoreDirector.isConstraintMatchEnabled();
    }

    public List<ConstraintMatchTotal<Score_>> getConstraintMatchTotalList() {
        return this.scoreManager.explainScore(this.getSolution()).getConstraintMatchTotalMap().values().stream().map(constraintMatchTotal -> (DefaultConstraintMatchTotal)constraintMatchTotal).sorted().collect(Collectors.toList());
    }

    public Map<Object, Indictment<Score_>> getIndictmentMap() {
        return this.scoreManager.explainScore(this.getSolution()).getIndictmentMap();
    }

    public void importSolution(File file) {
        AbstractSolutionImporter<Solution_> importer = this.determineImporter(file);
        Solution_ solution = importer.readSolution(file);
        this.solutionFileName = file.getName();
        this.guiScoreDirector.setWorkingSolution(solution);
    }

    private AbstractSolutionImporter<Solution_> determineImporter(File file) {
        for (AbstractSolutionImporter<Solution_> importer : this.importers) {
            if (!importer.acceptInputFile(file)) continue;
            return importer;
        }
        return (AbstractSolutionImporter)this.importers.stream().findFirst().orElseThrow();
    }

    public void openSolution(File file) {
        Object solution = this.solutionFileIO.read(file);
        LOGGER.info("Opened: {}", (Object)file);
        this.solutionFileName = file.getName();
        this.guiScoreDirector.setWorkingSolution(solution);
    }

    public void saveSolution(File file) {
        Object solution = this.guiScoreDirector.getWorkingSolution();
        this.solutionFileIO.write(solution, file);
        LOGGER.info("Saved: {}", (Object)file);
    }

    public void exportSolution(AbstractSolutionExporter<Solution_> exporter, File file) {
        Object solution = this.guiScoreDirector.getWorkingSolution();
        exporter.writeSolution(solution, file);
    }

    public void doMove(Move<Solution_> move) {
        if (this.solver.isSolving()) {
            LOGGER.error("Not doing user move ({}) because the solver is solving.", move);
            return;
        }
        if (!move.isMoveDoable(this.guiScoreDirector)) {
            LOGGER.warn("Not doing user move ({}) because it is not doable.", move);
            return;
        }
        LOGGER.info("Doing user move ({}).", move);
        move.doMoveOnly(this.guiScoreDirector);
        this.guiScoreDirector.calculateScore();
    }

    public void doProblemChange(ProblemChange<Solution_> problemChange) {
        if (this.solver.isSolving()) {
            this.solver.addProblemChange(problemChange);
        } else {
            problemChange.doChange(this.guiScoreDirector.getWorkingSolution(), this.problemChangeDirector);
            this.guiScoreDirector.calculateScore();
        }
    }

    public Solution_ solve(Solution_ problem) {
        return (Solution_)this.solver.solve(problem);
    }

    public void terminateSolvingEarly() {
        this.solver.terminateEarly();
    }

    public GenuineVariableDescriptor<Solution_> findVariableDescriptor(Object entity, String variableName) {
        return this.guiScoreDirector.getSolutionDescriptor().findGenuineVariableDescriptorOrFail(entity, variableName);
    }

    public ChangeMove<Solution_> createChangeMove(Object entity, String variableName, Object toPlanningValue) {
        GenuineVariableDescriptor<Solution_> variableDescriptor = this.findVariableDescriptor(entity, variableName);
        if (variableDescriptor.isChained()) {
            SupplyManager supplyManager = this.guiScoreDirector.getSupplyManager();
            SingletonInverseVariableSupply inverseVariableSupply = (SingletonInverseVariableSupply)supplyManager.demand((Demand)new SingletonInverseVariableDemand(variableDescriptor));
            return new ChainedChangeMove(entity, variableDescriptor, inverseVariableSupply, toPlanningValue);
        }
        return new ChangeMove(entity, variableDescriptor, toPlanningValue);
    }

    public void doChangeMove(Object entity, String variableName, Object toPlanningValue) {
        ChangeMove<Solution_> move = this.createChangeMove(entity, variableName, toPlanningValue);
        this.doMove((Move<Solution_>)move);
    }
}

