/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.pas.domain.solver;

import java.util.Collections;
import java.util.Comparator;
import org.optaplanner.examples.common.domain.AbstractPersistable;
import org.optaplanner.examples.pas.domain.Bed;
import org.optaplanner.examples.pas.domain.Department;
import org.optaplanner.examples.pas.domain.Room;

public class BedStrengthComparator
implements Comparator<Bed> {
    private static final Comparator<Integer> NULLSAFE_INTEGER_COMPARATOR = Comparator.nullsFirst(Integer::compareTo);
    private static final Comparator<Department> DEPARTMENT_COMPARATOR = Comparator.comparing(department -> department.getMinimumAge() == null).thenComparing((? super T department) -> department.getMaximumAge() == null).thenComparing(Department::getMinimumAge, Collections.reverseOrder(NULLSAFE_INTEGER_COMPARATOR)).thenComparing(Department::getMaximumAge, NULLSAFE_INTEGER_COMPARATOR);
    private static final Comparator<Room> ROOM_COMPARATOR = Comparator.comparingInt(room -> room.getRoomEquipmentList().size()).thenComparingInt(room -> room.getRoomSpecialismList().size()).thenComparingInt(room -> -room.getCapacity());
    private static final Comparator<Bed> COMPARATOR = Comparator.comparing(bed -> bed.getRoom().getDepartment(), DEPARTMENT_COMPARATOR).thenComparing(Bed::getRoom, ROOM_COMPARATOR).thenComparingLong(AbstractPersistable::getId);

    @Override
    public int compare(Bed a, Bed b) {
        if (a == null) {
            if (b == null) {
                return 0;
            }
            return -1;
        }
        if (b == null) {
            return 1;
        }
        return COMPARATOR.compare(a, b);
    }
}

