/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.tsp.swingui;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import org.optaplanner.examples.common.domain.AbstractPersistable;
import org.optaplanner.examples.common.swingui.SolutionPanel;
import org.optaplanner.examples.common.swingui.SolverAndPersistenceFrame;
import org.optaplanner.examples.tsp.domain.Domicile;
import org.optaplanner.examples.tsp.domain.Standstill;
import org.optaplanner.examples.tsp.domain.TspSolution;
import org.optaplanner.examples.tsp.domain.Visit;
import org.optaplanner.examples.tsp.domain.location.AirLocation;
import org.optaplanner.examples.tsp.domain.location.Location;
import org.optaplanner.examples.tsp.swingui.TspListPanel;
import org.optaplanner.examples.tsp.swingui.TspWorldPanel;

public class TspPanel
extends SolutionPanel<TspSolution> {
    public static final String LOGO_PATH = "/org/optaplanner/examples/tsp/swingui/tspLogo.png";
    private TspWorldPanel tspWorldPanel;
    private TspListPanel tspListPanel;
    private Long nextLocationId = null;

    public TspPanel() {
        this.setLayout(new BorderLayout());
        JTabbedPane tabbedPane = new JTabbedPane();
        this.tspWorldPanel = new TspWorldPanel(this);
        this.tspWorldPanel.setPreferredSize(PREFERRED_SCROLLABLE_VIEWPORT_SIZE);
        tabbedPane.add("World", this.tspWorldPanel);
        this.tspListPanel = new TspListPanel(this);
        JScrollPane tspListScrollPane = new JScrollPane(this.tspListPanel);
        tabbedPane.add("List", tspListScrollPane);
        this.add((Component)tabbedPane, "Center");
    }

    @Override
    public boolean isWrapInScrollPane() {
        return false;
    }

    @Override
    public void resetPanel(TspSolution tspSolution) {
        this.tspWorldPanel.resetPanel(tspSolution);
        this.tspListPanel.resetPanel(tspSolution);
        this.resetNextLocationId();
    }

    private void resetNextLocationId() {
        long highestLocationId = 0L;
        for (Location location : ((TspSolution)this.getSolution()).getLocationList()) {
            if (highestLocationId >= location.getId()) continue;
            highestLocationId = location.getId();
        }
        this.nextLocationId = highestLocationId + 1L;
    }

    @Override
    public void updatePanel(TspSolution tspSolution) {
        this.tspWorldPanel.updatePanel(tspSolution);
        this.tspListPanel.updatePanel(tspSolution);
    }

    public SolverAndPersistenceFrame getWorkflowFrame() {
        return this.solverAndPersistenceFrame;
    }

    public void insertLocationAndVisit(double longitude, double latitude) {
        AirLocation newLocation;
        switch (((TspSolution)this.getSolution()).getDistanceType()) {
            case AIR_DISTANCE: {
                newLocation = new AirLocation();
                break;
            }
            case ROAD_DISTANCE: {
                this.logger.warn("Adding locations for a road distance dataset is not supported.");
                return;
            }
            default: {
                throw new IllegalStateException("The distanceType (" + ((TspSolution)this.getSolution()).getDistanceType() + ") is not implemented.");
            }
        }
        newLocation.setId(this.nextLocationId);
        Long l = this.nextLocationId;
        Long l2 = this.nextLocationId = Long.valueOf(this.nextLocationId + 1L);
        newLocation.setLongitude(longitude);
        newLocation.setLatitude(latitude);
        this.logger.info("Scheduling insertion of newLocation ({}).", (Object)newLocation);
        this.doProblemChange((tspSolution, problemChangeDirector) -> {
            problemChangeDirector.addProblemFact((Object)newLocation, tspSolution.getLocationList()::add);
            Visit newVisit = new Visit();
            newVisit.setId(newLocation.getId());
            newVisit.setLocation(newLocation);
            problemChangeDirector.addEntity((Object)newVisit, tspSolution.getVisitList()::add);
        });
    }

    public void connectStandstills(Standstill sourceStandstill, Standstill targetStandstill) {
        if (targetStandstill instanceof Domicile) {
            TspSolution tspSolution = (TspSolution)this.getSolution();
            AbstractPersistable lastStandstill = tspSolution.getDomicile();
            Visit nextVisit = this.findNextVisit(tspSolution, (Standstill)((Object)lastStandstill));
            while (nextVisit != null) {
                lastStandstill = nextVisit;
                nextVisit = this.findNextVisit(tspSolution, (Standstill)((Object)lastStandstill));
            }
            targetStandstill = sourceStandstill;
            sourceStandstill = lastStandstill;
        }
        if (targetStandstill instanceof Visit && (sourceStandstill instanceof Domicile || ((Visit)sourceStandstill).getPreviousStandstill() != null)) {
            this.solutionBusiness.doChangeMove(targetStandstill, "previousStandstill", sourceStandstill);
        }
        this.solverAndPersistenceFrame.resetScreen();
    }

    public Standstill findNearestStandstill(AirLocation clickLocation) {
        TspSolution tspSolution = (TspSolution)this.getSolution();
        AbstractPersistable standstill = tspSolution.getDomicile();
        double minimumAirDistance = standstill.getLocation().getAirDistanceDoubleTo(clickLocation);
        for (Visit selectedVisit : tspSolution.getVisitList()) {
            double airDistance = selectedVisit.getLocation().getAirDistanceDoubleTo(clickLocation);
            if (!(airDistance < minimumAirDistance)) continue;
            standstill = selectedVisit;
            minimumAirDistance = airDistance;
        }
        return standstill;
    }

    private Visit findNextVisit(TspSolution tspSolution, Standstill standstill) {
        for (Visit visit : tspSolution.getVisitList()) {
            if (visit.getPreviousStandstill() != standstill) continue;
            return visit;
        }
        return null;
    }

    public void doMove(Visit visit, Standstill toStandstill) {
        this.solutionBusiness.doChangeMove(visit, "previousStandstill", toStandstill);
    }
}

