/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.tennis.domain;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import org.optaplanner.core.api.domain.entity.PlanningEntity;
import org.optaplanner.core.api.domain.entity.PlanningPin;
import org.optaplanner.core.api.domain.variable.PlanningVariable;
import org.optaplanner.examples.common.domain.AbstractPersistable;
import org.optaplanner.examples.tennis.domain.Day;
import org.optaplanner.examples.tennis.domain.Team;

@PlanningEntity
@XStreamAlias(value="TennisTeamAssignment")
public class TeamAssignment
extends AbstractPersistable {
    private Day day;
    private int indexInDay;
    private boolean pinned;
    private Team team;

    public TeamAssignment() {
    }

    public TeamAssignment(long id, Day day, int indexInDay) {
        super(id);
        this.day = day;
        this.indexInDay = indexInDay;
    }

    public Day getDay() {
        return this.day;
    }

    public void setDay(Day day) {
        this.day = day;
    }

    public int getIndexInDay() {
        return this.indexInDay;
    }

    public void setIndexInDay(int indexInDay) {
        this.indexInDay = indexInDay;
    }

    @PlanningPin
    public boolean isPinned() {
        return this.pinned;
    }

    public void setPinned(boolean pinned) {
        this.pinned = pinned;
    }

    @PlanningVariable(valueRangeProviderRefs={"teamRange"})
    public Team getTeam() {
        return this.team;
    }

    public void setTeam(Team team) {
        this.team = team;
    }

    @Override
    public String toString() {
        return "Day-" + this.day.getDateIndex() + "(" + this.indexInDay + ")";
    }
}

