/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.batchscheduling.optional.score;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.optaplanner.core.api.score.buildin.bendablelong.BendableLongScore;
import org.optaplanner.core.api.score.calculator.EasyScoreCalculator;
import org.optaplanner.examples.batchscheduling.domain.Allocation;
import org.optaplanner.examples.batchscheduling.domain.AllocationPath;
import org.optaplanner.examples.batchscheduling.domain.BatchSchedule;
import org.optaplanner.examples.batchscheduling.domain.RoutePath;

public class BatchSchedulingEasyScoreCalculator
implements EasyScoreCalculator<BatchSchedule, BendableLongScore> {
    public BendableLongScore calculateScore(BatchSchedule schedule) {
        long hard0Score = 0L;
        long hard1Score = 0L;
        long hard2Score = 0L;
        long soft0Score = 0L;
        HashMap<Long, Long> batchOtherPenaltyValueMap = new HashMap<Long, Long>();
        HashMap<Long, Long> batchCurrentPenaltyValueMap = new HashMap<Long, Long>();
        HashMap<Long, String> batchRoutePathMap = new HashMap<Long, String>();
        HashMap<String, Long> segmentOverlapMap = new HashMap<String, Long>();
        for (AllocationPath allocationPath : schedule.getAllocationPathList()) {
            batchOtherPenaltyValueMap.put(allocationPath.getBatch().getId(), 0L);
            batchCurrentPenaltyValueMap.put(allocationPath.getBatch().getId(), 0L);
            if (allocationPath.getRoutePath() == null) continue;
            batchRoutePathMap.put(allocationPath.getBatch().getId(), allocationPath.getRoutePath().getPath());
        }
        for (Allocation allocation : schedule.getAllocationList()) {
            if (batchRoutePathMap.get(allocation.getBatch().getId()) == null) {
                batchCurrentPenaltyValueMap.put(allocation.getBatch().getId(), (Long)batchCurrentPenaltyValueMap.get(allocation.getBatch().getId()) + 1L);
                continue;
            }
            if (!allocation.getRoutePath().getPath().equals(batchRoutePathMap.get(allocation.getBatch().getId()))) {
                if (allocation.getDelay() == null) continue;
                batchOtherPenaltyValueMap.put(allocation.getBatch().getId(), (Long)batchOtherPenaltyValueMap.get(allocation.getBatch().getId()) + 1L);
                continue;
            }
            if (allocation.getDelay() == null) {
                batchCurrentPenaltyValueMap.put(allocation.getBatch().getId(), (Long)batchCurrentPenaltyValueMap.get(allocation.getBatch().getId()) + 1L);
                continue;
            }
            this.computeOverlap(schedule.getAllocationList(), allocation, batchRoutePathMap, segmentOverlapMap);
        }
        for (Map.Entry entry : batchCurrentPenaltyValueMap.entrySet()) {
            if ((Long)entry.getValue() <= 0L && batchRoutePathMap.get(entry.getKey()) != null) continue;
            --hard0Score;
            hard1Score -= ((Long)entry.getValue()).longValue();
        }
        for (Map.Entry entry : batchOtherPenaltyValueMap.entrySet()) {
            if (batchRoutePathMap.get(entry.getKey()) == null || (Long)entry.getValue() <= 0L) continue;
            --hard0Score;
            hard1Score -= ((Long)entry.getValue()).longValue();
        }
        for (Map.Entry entry : segmentOverlapMap.entrySet()) {
            hard2Score -= ((Long)entry.getValue()).longValue();
        }
        for (Allocation allocation : schedule.getAllocationList()) {
            long longEndDeliverytime;
            if (allocation.getDelay() == null || batchRoutePathMap.get(allocation.getBatch().getId()) == null || !allocation.getRoutePath().getPath().equals(batchRoutePathMap.get(allocation.getBatch().getId())) || (longEndDeliverytime = allocation.getEndDeliveryTime().longValue()) <= soft0Score) continue;
            soft0Score = longEndDeliverytime;
        }
        HashMap<String, Boolean> segmentMapCount = new HashMap<String, Boolean>();
        for (Allocation allocation : schedule.getAllocationList()) {
            segmentMapCount.put(allocation.getSegment().getName(), true);
        }
        long l = segmentMapCount.size();
        HashMap<String, Boolean> segmentMap = new HashMap<String, Boolean>();
        for (AllocationPath allocationPath : schedule.getAllocationPathList()) {
            if (allocationPath.getRoutePath() == null) continue;
            for (String s : RoutePath.getSegmentArray(allocationPath.getRoutePath().getPath())) {
                segmentMap.put(s, true);
            }
        }
        soft0Score = -soft0Score;
        long soft1Score = (long)segmentMap.size() - l;
        return BendableLongScore.of((long[])new long[]{hard0Score, hard1Score, hard2Score}, (long[])new long[]{soft0Score, soft1Score});
    }

    private void computeOverlap(List<Allocation> allocationList, Allocation allocation, Map<Long, String> batchRoutePathMap, Map<String, Long> segmentOverlapMap) {
        Long allocationStartInjectionTime = allocation.getStartInjectionTime();
        Long allocationEndInjectionTime = allocation.getEndInjectionTime();
        Long allocationStartDeliveryTime = allocation.getStartDeliveryTime();
        Long allocationEndDeliveryTime = allocation.getEndDeliveryTime();
        for (Allocation allocation2 : allocationList) {
            if (allocation2.getDelay() == null || Objects.equals(allocation2.getBatch().getId(), allocation.getBatch().getId()) || batchRoutePathMap.get(allocation2.getBatch().getId()) == null || !allocation2.getRoutePath().getPath().equals(batchRoutePathMap.get(allocation2.getBatch().getId())) || !allocation2.getSegment().getName().equals(allocation.getSegment().getName())) continue;
            Long allocation2StartInjectionTime = allocation2.getStartInjectionTime();
            Long allocation2EndInjectionTime = allocation2.getEndInjectionTime();
            Long allocation2StartDeliveryTime = allocation2.getStartDeliveryTime();
            Long allocation2EndDeliveryTime = allocation2.getEndDeliveryTime();
            long newOverlapPenaltyValue = 0L;
            if (allocation2StartInjectionTime <= allocationStartInjectionTime && allocation2EndInjectionTime >= allocationEndInjectionTime) {
                newOverlapPenaltyValue = allocationEndInjectionTime - allocationStartInjectionTime;
            } else if (allocation2StartInjectionTime >= allocationStartInjectionTime && allocation2EndInjectionTime <= allocationEndInjectionTime) {
                newOverlapPenaltyValue = allocation2EndInjectionTime - allocation2StartInjectionTime;
            } else if (allocation2StartInjectionTime <= allocationStartInjectionTime && allocation2EndInjectionTime > allocationStartInjectionTime) {
                newOverlapPenaltyValue = allocation2EndInjectionTime - allocationStartInjectionTime;
            } else if (allocation2StartInjectionTime < allocationEndInjectionTime && allocation2EndInjectionTime >= allocationEndInjectionTime) {
                newOverlapPenaltyValue = allocationEndInjectionTime - allocation2StartInjectionTime;
            }
            if (allocation2StartDeliveryTime <= allocationStartDeliveryTime && allocation2EndDeliveryTime >= allocationEndDeliveryTime) {
                newOverlapPenaltyValue += allocationEndDeliveryTime - allocationStartDeliveryTime;
            } else if (allocation2StartDeliveryTime >= allocationStartDeliveryTime && allocation2EndDeliveryTime <= allocationEndDeliveryTime) {
                newOverlapPenaltyValue += allocation2EndDeliveryTime - allocation2StartDeliveryTime;
            } else if (allocation2StartDeliveryTime <= allocationStartDeliveryTime && allocation2EndDeliveryTime > allocationStartDeliveryTime) {
                newOverlapPenaltyValue += allocation2EndDeliveryTime - allocationStartDeliveryTime;
            } else if (allocation2StartDeliveryTime < allocationEndDeliveryTime && allocation2EndDeliveryTime >= allocationEndDeliveryTime) {
                newOverlapPenaltyValue += allocationEndDeliveryTime - allocation2StartDeliveryTime;
            }
            if (allocation2StartInjectionTime >= allocationStartInjectionTime && allocation2EndDeliveryTime <= allocationEndDeliveryTime) {
                newOverlapPenaltyValue += allocationEndDeliveryTime - allocation2EndDeliveryTime;
            }
            if (allocation2StartInjectionTime <= allocationStartInjectionTime && allocation2EndDeliveryTime >= allocationEndDeliveryTime) {
                newOverlapPenaltyValue += allocation2EndDeliveryTime - allocationEndDeliveryTime;
            }
            if (newOverlapPenaltyValue <= 0L) continue;
            segmentOverlapMap.put(allocation.getSegment().getId().toString() + "#" + allocation2.getSegment().getId().toString(), newOverlapPenaltyValue);
        }
    }
}

