/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.taskassigning.swingui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Vector;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JViewport;
import javax.swing.Scrollable;
import org.optaplanner.examples.common.business.SolutionBusiness;
import org.optaplanner.examples.common.swingui.SolutionPanel;
import org.optaplanner.examples.common.swingui.components.LabeledComboBoxRenderer;
import org.optaplanner.examples.taskassigning.domain.Employee;
import org.optaplanner.examples.taskassigning.domain.Skill;
import org.optaplanner.examples.taskassigning.domain.Task;
import org.optaplanner.examples.taskassigning.domain.TaskAssigningSolution;
import org.optaplanner.examples.taskassigning.swingui.TaskAssigningPanel;
import org.optaplanner.swing.impl.SwingUtils;
import org.optaplanner.swing.impl.TangoColorFactory;

public class TaskOverviewPanel
extends JPanel
implements Scrollable {
    public static final int HEADER_ROW_HEIGHT = 50;
    public static final int HEADER_COLUMN_WIDTH = 150;
    public static final int ROW_HEIGHT = 50;
    public static final int TIME_COLUMN_WIDTH = 60;
    private final TaskAssigningPanel taskAssigningPanel;
    private final ImageIcon[] affinityIcons;
    private final ImageIcon[] priorityIcons;
    private TangoColorFactory skillColorFactory;
    private int consumedDuration = 0;

    public TaskOverviewPanel(TaskAssigningPanel taskAssigningPanel) {
        this.taskAssigningPanel = taskAssigningPanel;
        this.affinityIcons = new ImageIcon[]{new ImageIcon(this.getClass().getResource("affinityNone.png")), new ImageIcon(this.getClass().getResource("affinityLow.png")), new ImageIcon(this.getClass().getResource("affinityMedium.png")), new ImageIcon(this.getClass().getResource("affinityHigh.png"))};
        this.priorityIcons = new ImageIcon[]{new ImageIcon(this.getClass().getResource("priorityMinor.png")), new ImageIcon(this.getClass().getResource("priorityMajor.png")), new ImageIcon(this.getClass().getResource("priorityCritical.png"))};
        this.setLayout(null);
        this.setMinimumSize(new Dimension(300, 400));
    }

    public void resetPanel(TaskAssigningSolution taskAssigningSolution) {
        this.removeAll();
        this.skillColorFactory = new TangoColorFactory();
        List<Employee> employeeList = taskAssigningSolution.getEmployeeList();
        ArrayList<Task> unassignedTaskList = new ArrayList<Task>(taskAssigningSolution.getTaskList());
        int rowIndex = 0;
        for (Employee employee : employeeList) {
            this.add(this.createEmployeeLabel(employee, rowIndex));
            ++rowIndex;
        }
        rowIndex = 0;
        for (Employee employee : employeeList) {
            for (Task task : employee.getTasks()) {
                this.add(this.createTaskButton(task, rowIndex));
                unassignedTaskList.remove(task);
            }
            ++rowIndex;
        }
        for (Task task : unassignedTaskList) {
            this.add(this.createTaskButton(task, rowIndex));
            ++rowIndex;
        }
        int maxUnassignedTaskDuration = unassignedTaskList.stream().mapToInt(Task::getDuration).max().orElse(0);
        int maxEmployeeEndTime = employeeList.stream().mapToInt(Employee::getEndTime).max().orElse(0);
        int taskTableWidth = Math.max(maxEmployeeEndTime, maxUnassignedTaskDuration + this.consumedDuration);
        for (int timeGrain = 0; timeGrain < taskTableWidth; timeGrain += 60) {
            this.add(this.createTimeLabel(timeGrain));
        }
        if (taskTableWidth % 60 != 0) {
            taskTableWidth += 60 - taskTableWidth % 60;
        }
        Dimension size = new Dimension(taskTableWidth + 150, 50 + rowIndex * 50);
        this.setSize(size);
        this.setPreferredSize(size);
        this.repaint();
    }

    public void setConsumedDuration(int consumedDuration) {
        this.consumedDuration = consumedDuration;
        this.repaint();
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        g.setColor(TangoColorFactory.ALUMINIUM_2);
        int lineX = 150 + this.consumedDuration;
        g.fillRect(150, 0, lineX, this.getHeight());
        g.setColor(Color.WHITE);
        g.fillRect(lineX, 0, this.getWidth(), this.getHeight());
    }

    private JLabel createEmployeeLabel(Employee employee, int rowIndex) {
        JLabel employeeLabel = new JLabel(employee.getLabel(), new TaskOrEmployeeIcon(employee), 2);
        employeeLabel.setOpaque(true);
        employeeLabel.setToolTipText(employee.getToolText());
        employeeLabel.setLocation(0, 50 + rowIndex * 50);
        employeeLabel.setSize(150, 50);
        employeeLabel.setBorder(BorderFactory.createLineBorder(Color.BLACK, 1));
        return employeeLabel;
    }

    private JButton createTaskButton(Task task, int rowIndex) {
        JButton taskButton = SwingUtils.makeSmallButton((JButton)new JButton(new TaskAction(task)));
        taskButton.setBackground(TangoColorFactory.ALUMINIUM_1);
        taskButton.setHorizontalTextPosition(0);
        taskButton.setVerticalTextPosition(1);
        taskButton.setSize(task.getDuration(), 50);
        int x = 150 + (task.getEmployee() == null ? task.getReadyTime() : task.getStartTime().intValue());
        int y = 50 + rowIndex * 50;
        taskButton.setLocation(x, y);
        return taskButton;
    }

    private JLabel createTimeLabel(int timeGrain) {
        int minutesInDay = timeGrain % 600;
        int hours = 8 + minutesInDay / 60;
        int minutesInHour = minutesInDay % 60;
        JLabel timeLabel = new JLabel(String.format("%02d:%02d", hours, minutesInHour));
        timeLabel.setBorder(BorderFactory.createLineBorder(Color.BLACK, 1));
        timeLabel.setLocation(timeGrain + 150, 0);
        timeLabel.setSize(60, 50);
        return timeLabel;
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return SolutionPanel.PREFERRED_SCROLLABLE_VIEWPORT_SIZE;
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        return 20;
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        return 20;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        if (this.getParent() instanceof JViewport) {
            return this.getParent().getWidth() > this.getPreferredSize().width;
        }
        return false;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        if (this.getParent() instanceof JViewport) {
            return this.getParent().getHeight() > this.getPreferredSize().height;
        }
        return false;
    }

    private class TaskOrEmployeeIcon
    implements Icon {
        private static final int SKILL_ICON_WIDTH = 8;
        private static final int SKILL_ICON_HEIGHT = 16;
        private final ImageIcon priorityIcon;
        private final List<Color> skillColorList;
        private final ImageIcon affinityIcon;

        private TaskOrEmployeeIcon(Task task) {
            this.priorityIcon = TaskOverviewPanel.this.priorityIcons[task.getPriority().ordinal()];
            this.skillColorList = task.getTaskType().getRequiredSkillList().stream().map(arg_0 -> ((TangoColorFactory)TaskOverviewPanel.this.skillColorFactory).pickColor(arg_0)).collect(Collectors.toList());
            this.affinityIcon = TaskOverviewPanel.this.affinityIcons[task.getAffinity().ordinal()];
        }

        private TaskOrEmployeeIcon(Employee employee) {
            this.priorityIcon = null;
            this.skillColorList = employee.getSkillSet().stream().sorted(Comparator.comparing(Skill::getName)).map(arg_0 -> ((TangoColorFactory)TaskOverviewPanel.this.skillColorFactory).pickColor(arg_0)).collect(Collectors.toList());
            this.affinityIcon = null;
        }

        @Override
        public int getIconWidth() {
            int width = 0;
            if (this.priorityIcon != null) {
                width += this.priorityIcon.getIconWidth();
            }
            width += this.skillColorList.size() * 8;
            if (this.affinityIcon != null) {
                width += this.affinityIcon.getIconWidth();
            }
            return width;
        }

        @Override
        public int getIconHeight() {
            int height = 16;
            if (this.priorityIcon != null && this.priorityIcon.getIconHeight() > height) {
                height = this.priorityIcon.getIconHeight();
            }
            if (this.affinityIcon != null && this.affinityIcon.getIconHeight() > height) {
                height = this.affinityIcon.getIconHeight();
            }
            return height;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            int innerX = x;
            if (this.priorityIcon != null) {
                this.priorityIcon.paintIcon(c, g, innerX, y);
                innerX += this.priorityIcon.getIconWidth();
            }
            for (Color skillColor : this.skillColorList) {
                g.setColor(skillColor);
                g.fillRect(innerX + 1, y + 1, 6, 14);
                g.setColor(TangoColorFactory.ALUMINIUM_5);
                g.drawRect(innerX + 1, y + 1, 6, 14);
                innerX += 8;
            }
            if (this.affinityIcon != null) {
                this.affinityIcon.paintIcon(c, g, innerX, y);
                innerX += this.affinityIcon.getIconWidth();
            }
        }
    }

    private class TaskAction
    extends AbstractAction {
        private final Task task;

        public TaskAction(Task task) {
            super(task.getCode(), new TaskOrEmployeeIcon(task));
            this.task = task;
            this.putValue("ShortDescription", task.getToolText());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JComboBox indexListField = new JComboBox();
            JComboBox<Employee> employeeListField = new JComboBox<Employee>(new Vector<Employee>(((TaskAssigningSolution)TaskOverviewPanel.this.taskAssigningPanel.getSolution()).getEmployeeList()));
            employeeListField.addItemListener(itemEvent -> {
                if (itemEvent.getStateChange() == 1) {
                    indexListField.setModel(new DefaultComboBoxModel<Integer>(this.availableIndexes((Employee)itemEvent.getItem())));
                }
            });
            LabeledComboBoxRenderer.applyToComboBox(employeeListField);
            this.selectCurrentEmployee(employeeListField);
            JCheckBox unassignCheckBox = new JCheckBox("Or unassign.");
            unassignCheckBox.addActionListener(checkBoxEvent -> {
                employeeListField.setEnabled(!unassignCheckBox.isSelected());
                indexListField.setEnabled(!unassignCheckBox.isSelected());
            });
            unassignCheckBox.setVisible(this.task.getEmployee() != null);
            JPanel listFieldsPanel = new JPanel(new GridLayout(4, 1));
            listFieldsPanel.add(new JLabel("Select employee and index:"));
            listFieldsPanel.add(employeeListField);
            listFieldsPanel.add(indexListField);
            listFieldsPanel.add(unassignCheckBox);
            int result = JOptionPane.showConfirmDialog(TaskOverviewPanel.this.getRootPane(), listFieldsPanel, "Move " + this.task.getCode(), 2);
            if (result == 0) {
                Employee selectedEmployee = (Employee)employeeListField.getSelectedItem();
                Integer selectedIndex = (Integer)indexListField.getSelectedItem();
                this.doProblemChange(selectedEmployee, selectedIndex, unassignCheckBox.isSelected());
                TaskOverviewPanel.this.taskAssigningPanel.getSolverAndPersistenceFrame().resetScreen();
            }
        }

        private Vector<Integer> availableIndexes(Employee selectedEmployee) {
            int availableIndexes = selectedEmployee.getTasks().size();
            if (selectedEmployee == this.task.getEmployee()) {
                --availableIndexes;
            }
            return IntStream.rangeClosed(0, availableIndexes).boxed().collect(Collectors.toCollection(Vector::new));
        }

        private void selectCurrentEmployee(JComboBox<Employee> employeeListField) {
            employeeListField.setSelectedItem(null);
            if (this.task.getEmployee() == null) {
                employeeListField.setSelectedIndex(0);
            } else {
                employeeListField.setSelectedItem(this.task.getEmployee());
            }
        }

        private void doProblemChange(Employee selectedEmployee, Integer selectedIndex, boolean unassignTask) {
            SolutionBusiness solutionBusiness = TaskOverviewPanel.this.taskAssigningPanel.getSolutionBusiness();
            if (unassignTask) {
                solutionBusiness.doProblemChange((workingSolution, problemChangeDirector) -> problemChangeDirector.changeVariable((Object)selectedEmployee, "tasks", e -> e.getTasks().remove(selectedIndex)));
            } else if (this.task.getEmployee() == null) {
                solutionBusiness.doProblemChange((workingSolution, problemChangeDirector) -> problemChangeDirector.changeVariable((Object)selectedEmployee, "tasks", e -> e.getTasks().add(selectedIndex, this.task)));
            } else {
                solutionBusiness.doProblemChange((workingSolution, problemChangeDirector) -> {
                    Task removedTask = this.task.getEmployee().getTasks().get(this.task.getIndex());
                    problemChangeDirector.changeVariable((Object)this.task.getEmployee(), "tasks", e -> e.getTasks().remove(this.task));
                    if (this.task.getEmployee() != selectedEmployee) {
                        problemChangeDirector.changeVariable((Object)selectedEmployee, "tasks", e -> e.getTasks().add(selectedIndex, removedTask));
                    }
                });
            }
        }
    }
}

