/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.vehiclerouting.app;

import java.io.File;
import java.util.stream.IntStream;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.optaplanner.core.api.solver.Solver;
import org.optaplanner.core.api.solver.SolverFactory;
import org.optaplanner.core.config.localsearch.LocalSearchPhaseConfig;
import org.optaplanner.core.config.solver.EnvironmentMode;
import org.optaplanner.core.config.solver.SolverConfig;
import org.optaplanner.core.config.solver.termination.TerminationConfig;
import org.optaplanner.examples.common.TurtleTest;
import org.optaplanner.examples.common.app.CommonApp;
import org.optaplanner.examples.vehiclerouting.app.VehicleRoutingApp;
import org.optaplanner.examples.vehiclerouting.domain.VehicleRoutingSolution;
import org.optaplanner.examples.vehiclerouting.persistence.VehicleRoutingImporter;

class VehicleRoutingMultiThreadedReproducibilityTest {
    private static final int REPETITION_COUNT = 10;
    private static final int STEP_LIMIT = 5000;
    private static final String MOVE_THREAD_COUNT = "4";
    private static final String DATA_SET = "import/belgium/basic/air/belgium-n50-k10.vrp";
    private final VehicleRoutingApp vehicleRoutingApp = new VehicleRoutingApp();
    private VehicleRoutingSolution[] vehicleRoutingSolutions = new VehicleRoutingSolution[10];
    private SolverFactory<VehicleRoutingSolution> solverFactory;

    VehicleRoutingMultiThreadedReproducibilityTest() {
    }

    @BeforeEach
    void createUninitializedSolutions() {
        VehicleRoutingImporter importer = new VehicleRoutingImporter();
        for (int i = 0; i < 10; ++i) {
            VehicleRoutingSolution solution;
            File dataSetFile = new File(CommonApp.determineDataDir((String)this.vehicleRoutingApp.getDataDirName()), DATA_SET);
            this.vehicleRoutingSolutions[i] = solution = (VehicleRoutingSolution)importer.readSolution(dataSetFile);
        }
        SolverConfig solverConfig = SolverConfig.createFromXmlResource((String)this.vehicleRoutingApp.getSolverConfigResource());
        solverConfig.withEnvironmentMode(EnvironmentMode.REPRODUCIBLE).withMoveThreadCount(MOVE_THREAD_COUNT);
        solverConfig.getPhaseConfigList().forEach(phaseConfig -> {
            if (LocalSearchPhaseConfig.class.isAssignableFrom(phaseConfig.getClass())) {
                phaseConfig.setTerminationConfig(new TerminationConfig().withStepCountLimit(Integer.valueOf(5000)));
            }
        });
        this.solverFactory = SolverFactory.create((SolverConfig)solverConfig);
    }

    @TurtleTest
    void multiThreadedSolvingIsReproducible() {
        IntStream.range(0, 10).forEach(this::solveAndCompareWithPrevious);
    }

    private void solveAndCompareWithPrevious(int iteration) {
        VehicleRoutingSolution bestSolution;
        Solver solver = this.solverFactory.buildSolver();
        this.vehicleRoutingSolutions[iteration] = bestSolution = (VehicleRoutingSolution)solver.solve((Object)this.vehicleRoutingSolutions[iteration]);
        if (iteration > 0) {
            VehicleRoutingSolution previousBestSolution = this.vehicleRoutingSolutions[iteration - 1];
            Assertions.assertThat((Comparable)previousBestSolution.getScore()).isEqualTo((Object)bestSolution.getScore());
        }
    }
}

