/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.cheaptime.domain;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.optaplanner.examples.cheaptime.domain.Period;
import org.optaplanner.examples.cheaptime.domain.Resource;
import org.optaplanner.examples.cheaptime.domain.TaskRequirement;
import org.optaplanner.examples.common.domain.AbstractPersistable;

@XStreamAlias(value="CtTask")
public class Task
extends AbstractPersistable {
    private long powerConsumptionMicros;
    private int duration;
    private int startPeriodRangeFrom;
    private int startPeriodRangeTo;
    private List<TaskRequirement> taskRequirementList;

    public Task() {
    }

    public Task(long id, Period startInclusive, Period endExclusive, int duration, long powerConsumptionMicros, TaskRequirement ... taskRequirements) {
        super(id);
        this.startPeriodRangeFrom = startInclusive.getIndex();
        this.startPeriodRangeTo = endExclusive.getIndex();
        this.duration = duration;
        this.powerConsumptionMicros = powerConsumptionMicros;
        this.taskRequirementList = Arrays.stream(taskRequirements).collect(Collectors.toList());
    }

    public long getPowerConsumptionMicros() {
        return this.powerConsumptionMicros;
    }

    public void setPowerConsumptionMicros(long powerConsumptionMicros) {
        this.powerConsumptionMicros = powerConsumptionMicros;
    }

    public int getDuration() {
        return this.duration;
    }

    public void setDuration(int duration) {
        this.duration = duration;
    }

    public int getStartPeriodRangeFrom() {
        return this.startPeriodRangeFrom;
    }

    public void setStartPeriodRangeFrom(int startPeriodRangeFrom) {
        this.startPeriodRangeFrom = startPeriodRangeFrom;
    }

    public int getStartPeriodRangeTo() {
        return this.startPeriodRangeTo;
    }

    public void setStartPeriodRangeTo(int startPeriodRangeTo) {
        this.startPeriodRangeTo = startPeriodRangeTo;
    }

    public List<TaskRequirement> getTaskRequirementList() {
        return this.taskRequirementList;
    }

    public void setTaskRequirementList(List<TaskRequirement> taskRequirementList) {
        this.taskRequirementList = taskRequirementList;
    }

    public int getUsage(Resource resource) {
        return this.taskRequirementList.get(resource.getIndex()).getResourceUsage();
    }

    public int getResourceUsageMultiplicand() {
        int multiplicand = 1;
        for (TaskRequirement taskRequirement : this.taskRequirementList) {
            multiplicand *= taskRequirement.getResourceUsage();
        }
        return multiplicand;
    }

    public String getLabel() {
        return "Task " + this.id;
    }
}

