/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.cheaptime.persistence;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import org.optaplanner.examples.cheaptime.domain.CheapTimeSolution;
import org.optaplanner.examples.cheaptime.domain.Machine;
import org.optaplanner.examples.cheaptime.domain.MachineCapacity;
import org.optaplanner.examples.cheaptime.domain.Period;
import org.optaplanner.examples.cheaptime.domain.Resource;
import org.optaplanner.examples.cheaptime.domain.Task;
import org.optaplanner.examples.cheaptime.domain.TaskAssignment;
import org.optaplanner.examples.cheaptime.domain.TaskRequirement;
import org.optaplanner.examples.cheaptime.score.CheapTimeCostCalculator;
import org.optaplanner.examples.common.business.SolutionBusiness;
import org.optaplanner.examples.common.persistence.AbstractSolutionImporter;
import org.optaplanner.examples.common.persistence.AbstractTxtSolutionImporter;
import org.optaplanner.examples.common.persistence.SolutionConverter;

public class CheapTimeImporter
extends AbstractTxtSolutionImporter<CheapTimeSolution> {
    public static void main(String[] args) {
        SolutionConverter<CheapTimeSolution> converter = SolutionConverter.createImportConverter("cheaptime", new CheapTimeImporter(), CheapTimeSolution.class);
        converter.convert("demo01", "demo01.xml");
        converter.convert("sample01", "sample01.xml");
        converter.convert("instance00", "instance00.xml");
        converter.convert("instance01", "instance01.xml");
        converter.convert("instance02", "instance02.xml");
        converter.convert("instance03", "instance03.xml");
    }

    @Override
    public boolean isInputFileDirectory() {
        return true;
    }

    @Override
    public String getInputFileSuffix() {
        throw new IllegalStateException("The inputFile is a directory, so there is no suffix.");
    }

    @Override
    public AbstractTxtSolutionImporter.TxtInputBuilder<CheapTimeSolution> createTxtInputBuilder() {
        return new CheapTimeInputBuilder();
    }

    @Override
    public CheapTimeSolution readSolution(File inputFile) {
        File instanceFile = new File(inputFile, "instance.txt");
        return (CheapTimeSolution)super.readSolution(instanceFile);
    }

    public static class CheapTimeInputBuilder
    extends AbstractTxtSolutionImporter.TxtInputBuilder<CheapTimeSolution> {
        private CheapTimeSolution solution;
        private int resourceListSize;

        @Override
        public CheapTimeSolution readSolution() throws IOException {
            this.solution = new CheapTimeSolution();
            this.solution.setId(0L);
            int timeResolutionInMinutes = this.readIntegerValue();
            this.solution.setTimeResolutionInMinutes(timeResolutionInMinutes);
            this.solution.setGlobalPeriodRangeFrom(0);
            this.solution.setGlobalPeriodRangeTo(1440 / timeResolutionInMinutes);
            this.readForecastFile();
            this.readResourceList();
            this.readMachineList();
            this.readTaskList();
            this.createTaskAssignmentList();
            BigInteger possibleSolutionSize = BigInteger.ONE;
            for (Task task : this.solution.getTaskList()) {
                possibleSolutionSize = possibleSolutionSize.multiply(BigInteger.valueOf(task.getStartPeriodRangeTo() - task.getStartPeriodRangeFrom()));
            }
            possibleSolutionSize = possibleSolutionSize.multiply(BigInteger.valueOf(this.solution.getMachineList().size()).pow(this.solution.getTaskList().size()));
            this.logger.info("CheapTime {} has {} resources, {} machines, {} periods and {} tasks with a search space of {}.", new Object[]{this.getInputId(), this.solution.getResourceList().size(), this.solution.getMachineList().size(), this.solution.getGlobalPeriodRangeTo(), this.solution.getTaskList().size(), AbstractSolutionImporter.getFlooredPossibleSolutionSize(possibleSolutionSize)});
            return this.solution;
        }

        @Override
        public String getInputId() {
            return SolutionBusiness.getBaseFileName(this.inputFile.getParentFile());
        }

        private void readResourceList() throws IOException {
            this.resourceListSize = this.readIntegerValue();
            ArrayList<Resource> resourceList = new ArrayList<Resource>(this.resourceListSize);
            for (int i = 0; i < this.resourceListSize; ++i) {
                Resource resource = new Resource();
                resource.setId(Long.valueOf(i));
                resource.setIndex(i);
                resourceList.add(resource);
            }
            this.solution.setResourceList(resourceList);
        }

        private void readMachineList() throws IOException {
            int machineListSize = this.readIntegerValue();
            ArrayList<Machine> machineList = new ArrayList<Machine>(machineListSize);
            ArrayList<MachineCapacity> machineCapacityList = new ArrayList<MachineCapacity>(machineListSize * this.resourceListSize);
            long machineCapacityId = 0L;
            for (int i = 0; i < machineListSize; ++i) {
                Machine machine = new Machine();
                String[] machineLineTokens = this.splitBySpacesOrTabs(this.readStringValue(), 4);
                machine.setId(Long.parseLong(machineLineTokens[0]));
                machine.setIndex(i);
                machine.setPowerConsumptionMicros(CheapTimeCostCalculator.parseMicroCost(machineLineTokens[1]));
                machine.setSpinUpDownCostMicros(CheapTimeCostCalculator.parseMicroCost(machineLineTokens[2]) + CheapTimeCostCalculator.parseMicroCost(machineLineTokens[3]));
                String[] capacityLineTokens = this.splitBySpacesOrTabs(this.readStringValue(), this.resourceListSize);
                ArrayList<MachineCapacity> machineCapacityListOfMachine = new ArrayList<MachineCapacity>(this.resourceListSize);
                for (int j = 0; j < this.resourceListSize; ++j) {
                    MachineCapacity machineCapacity = new MachineCapacity();
                    machineCapacity.setId(machineCapacityId);
                    ++machineCapacityId;
                    machineCapacity.setResource(this.solution.getResourceList().get(j));
                    machineCapacity.setCapacity(Integer.parseInt(capacityLineTokens[j]));
                    machineCapacityList.add(machineCapacity);
                    machineCapacityListOfMachine.add(machineCapacity);
                }
                machine.setMachineCapacityList(machineCapacityListOfMachine);
                machineList.add(machine);
            }
            this.solution.setMachineList(machineList);
        }

        private void readTaskList() throws IOException {
            int taskListSize = this.readIntegerValue();
            ArrayList<Task> taskList = new ArrayList<Task>(taskListSize);
            long taskRequirementId = 0L;
            for (int i = 0; i < taskListSize; ++i) {
                String[] taskLineTokens = this.splitBySpacesOrTabs(this.readStringValue(), 5);
                Task task = new Task();
                task.setId(Long.parseLong(taskLineTokens[0]));
                int duration = Integer.parseInt(taskLineTokens[1]);
                if (duration <= 0) {
                    throw new IllegalArgumentException("Task with id (" + task.getId() + ") has a duration (" + duration + ") which is not 1 or higher.");
                }
                task.setDuration(duration);
                int earliestStart = Integer.parseInt(taskLineTokens[2]);
                if (earliestStart < this.solution.getGlobalPeriodRangeFrom() || earliestStart >= this.solution.getGlobalPeriodRangeTo()) {
                    throw new IllegalArgumentException("Task with id (" + task.getId() + ") has a earliestStart (" + earliestStart + ") which is not between globalPeriodRangeFrom (" + this.solution.getGlobalPeriodRangeFrom() + ") and globalPeriodRangeTo (" + this.solution.getGlobalPeriodRangeTo() + ").");
                }
                task.setStartPeriodRangeFrom(earliestStart);
                int latestEnd = Integer.parseInt(taskLineTokens[3]);
                if (latestEnd < this.solution.getGlobalPeriodRangeFrom() || latestEnd > this.solution.getGlobalPeriodRangeTo()) {
                    throw new IllegalArgumentException("Task with id (" + task.getId() + ") has a latestEnd (" + latestEnd + ") which is not between globalPeriodRangeFrom (" + this.solution.getGlobalPeriodRangeFrom() + ") and globalPeriodRangeTo (" + this.solution.getGlobalPeriodRangeTo() + ").");
                }
                task.setPowerConsumptionMicros(CheapTimeCostCalculator.parseMicroCost(taskLineTokens[4]));
                task.setStartPeriodRangeTo(latestEnd - duration + 1);
                String[] usageLineTokens = this.splitBySpacesOrTabs(this.readStringValue(), this.resourceListSize);
                ArrayList<TaskRequirement> taskRequirementListOfTask = new ArrayList<TaskRequirement>(this.resourceListSize);
                for (int j = 0; j < this.resourceListSize; ++j) {
                    TaskRequirement taskRequirement = new TaskRequirement();
                    taskRequirement.setId(taskRequirementId);
                    ++taskRequirementId;
                    taskRequirement.setResource(this.solution.getResourceList().get(j));
                    taskRequirement.setResourceUsage(Integer.parseInt(usageLineTokens[j]));
                    taskRequirementListOfTask.add(taskRequirement);
                }
                task.setTaskRequirementList(taskRequirementListOfTask);
                taskList.add(task);
            }
            this.solution.setTaskList(taskList);
        }

        private void readForecastFile() {
            File forecastInputFile = new File(this.inputFile.getParent(), "forecast.txt");
            if (!forecastInputFile.exists()) {
                throw new IllegalArgumentException("The forecastInputFile (" + forecastInputFile + ") for instanceInputFile (" + this.inputFile + ") does not exist.");
            }
            try (BufferedReader forecastBufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(forecastInputFile), "UTF-8"));){
                ForecastInputBuilder forecastInputBuilder = new ForecastInputBuilder();
                forecastInputBuilder.setInputFile(forecastInputFile);
                forecastInputBuilder.setBufferedReader(forecastBufferedReader);
                try {
                    forecastInputBuilder.readSolution();
                }
                catch (IllegalArgumentException e) {
                    throw new IllegalArgumentException("Exception in forecastInputFile (" + forecastInputFile + ")", e);
                }
                catch (IllegalStateException e) {
                    throw new IllegalStateException("Exception in forecastInputFile (" + forecastInputFile + ")", e);
                }
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Could not read the forecastInputFile (" + forecastInputFile.getName() + ").", e);
            }
        }

        private void createTaskAssignmentList() {
            List<Task> taskList = this.solution.getTaskList();
            ArrayList<TaskAssignment> taskAssignmentList = new ArrayList<TaskAssignment>(taskList.size());
            for (Task task : taskList) {
                TaskAssignment taskAssignment = new TaskAssignment();
                taskAssignment.setId(task.getId());
                taskAssignment.setTask(task);
                taskAssignmentList.add(taskAssignment);
            }
            this.solution.setTaskAssignmentList(taskAssignmentList);
        }

        public class ForecastInputBuilder
        extends AbstractTxtSolutionImporter.TxtInputBuilder<CheapTimeSolution> {
            @Override
            public CheapTimeSolution readSolution() throws IOException {
                int periodListSize = this.readIntegerValue();
                long periodDurationPerHour = CheapTimeCostCalculator.divideTwoMicros(CheapTimeCostCalculator.toMicroCost(1440L), CheapTimeCostCalculator.toMicroCost((long)periodListSize * 60L));
                ArrayList<Period> periodList = new ArrayList<Period>(periodListSize);
                for (int i = 0; i < periodListSize; ++i) {
                    String[] lineTokens = this.splitBySpacesOrTabs(this.readStringValue(), 2);
                    int periodId = Integer.parseInt(lineTokens[0]);
                    if (periodList.size() != periodId) {
                        throw new IllegalStateException("The forecast period (" + periodId + ") does not increment normally and gets a different list index (" + periodList.size() + ").");
                    }
                    long hourlyPowerPriceMicros = CheapTimeCostCalculator.parseMicroCost(lineTokens[1]);
                    Period period = new Period(periodId, CheapTimeCostCalculator.multiplyTwoMicros(hourlyPowerPriceMicros, periodDurationPerHour));
                    periodList.add(period);
                }
                CheapTimeInputBuilder.this.solution.setPeriodList(periodList);
                return null;
            }
        }
    }
}

